/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.apidef;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.apidef.ApiSpecification;
import org.eclipse.scout.sdk.core.apidef.ApiVersion;
import org.eclipse.scout.sdk.core.apidef.IApiProvider;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;

public final class Api {
    private static final Map<Class<? extends IApiSpecification>, IApiProvider> REGISTRY = new HashMap<Class<? extends IApiSpecification>, IApiProvider>();
    private static final Map<Map.Entry<Class<? extends IApiSpecification>, ApiVersion>, IApiSpecification> API_CACHE = new HashMap<Map.Entry<Class<? extends IApiSpecification>, ApiVersion>, IApiSpecification>();

    private Api() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IApiProvider getProvider(Class<? extends IApiSpecification> apiDefinition) {
        Ensure.notNull(apiDefinition);
        Api.ensureInitialized(apiDefinition);
        Map<Class<? extends IApiSpecification>, IApiProvider> map = REGISTRY;
        synchronized (map) {
            return Ensure.notNull(REGISTRY.get(apiDefinition), "No provider for API class '{}' found.", apiDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerProvider(Class<? extends IApiSpecification> apiDefinition, IApiProvider provider) {
        Map<Class<? extends IApiSpecification>, IApiProvider> map = REGISTRY;
        synchronized (map) {
            Api.removeCachedApisOf(apiDefinition);
            return REGISTRY.put(Ensure.notNull(apiDefinition), Ensure.notNull(provider)) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterProvider(Class<? extends IApiSpecification> apiDefinition) {
        Map<Class<? extends IApiSpecification>, IApiProvider> map = REGISTRY;
        synchronized (map) {
            Api.removeCachedApisOf(apiDefinition);
            return REGISTRY.remove(apiDefinition) != null;
        }
    }

    static void removeCachedApisOf(Class<? extends IApiSpecification> apiDefinition) {
        API_CACHE.keySet().removeIf(e -> e.getKey() == apiDefinition);
    }

    static void ensureInitialized(Class<?> classToInit) {
        try {
            Class.forName(classToInit.getName(), true, classToInit.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            SdkLog.debug("Unable to locate class '{}'.", classToInit, e);
        }
    }

    public static int latestMajorVersion(Class<? extends IApiSpecification> api) {
        return Api.latest(api).maxLevel().major();
    }

    public static <API extends IApiSpecification> API latest(Class<API> api) {
        return Api.create(api, ApiVersion.LATEST);
    }

    public static Optional<ApiVersion> version(Class<? extends IApiSpecification> api, IJavaElement context) {
        return Optional.ofNullable(context).map(IJavaElement::javaEnvironment).flatMap(env -> Api.version(api, env));
    }

    public static Optional<ApiVersion> version(Class<? extends IApiSpecification> api, IJavaEnvironment context) {
        return Optional.ofNullable(context).flatMap(ctx -> Api.getProvider(api).version((IJavaEnvironment)ctx));
    }

    public static <API extends IApiSpecification> Optional<API> create(Class<API> api, IJavaElement context) {
        return Api.create(api, context == null ? null : context.javaEnvironment());
    }

    public static <API extends IApiSpecification> Optional<API> create(Class<API> api, IJavaEnvironment context) {
        return Api.version(api, context).map(version -> Api.create(api, version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <API extends IApiSpecification> API create(Class<API> api, ApiVersion version) {
        AbstractMap.SimpleImmutableEntry<Class<API>, ApiVersion> key = new AbstractMap.SimpleImmutableEntry<Class<API>, ApiVersion>(api, version);
        Map<Class<? extends IApiSpecification>, IApiProvider> map = REGISTRY;
        synchronized (map) {
            IApiSpecification definition = API_CACHE.computeIfAbsent(key, Api::doCreateApi);
            return (API)((IApiSpecification)api.cast(definition));
        }
    }

    static IApiSpecification doCreateApi(Map.Entry<Class<? extends IApiSpecification>, ApiVersion> entry) {
        Class<? extends IApiSpecification> api = entry.getKey();
        ApiVersion version = entry.getValue();
        Collection<Class<? extends IApiSpecification>> apiDefinitions = Api.getProvider(api).knownApis();
        IApiSpecification definition = Ensure.notNull(ApiSpecification.create(apiDefinitions, version), "No known API supports version {}. Available APIs: {}", version, apiDefinitions);
        if (SdkLog.isDebugEnabled()) {
            SdkLog.debug("Creating API definition '{}' supporting up to level '{}' (including).", api.getSimpleName(), definition.maxLevel().asString());
        }
        return definition;
    }

    public static <API extends IApiSpecification> Stream<API> allKnown(Class<API> api) {
        return Api.getProvider(api).knownApis().stream().map(ApiVersion::requireMaxApiLevelOf).sorted(Comparator.reverseOrder()).map(version -> Api.create(api, version));
    }

    public static Map<String, Map<ChildElementType, Map<String, String>>> dump(IApiSpecification api) {
        return Arrays.stream(Ensure.notNull(api).getClass().getMethods()).filter(m -> m.getParameterCount() == 0).filter(m -> ITypeNameSupplier.class.isAssignableFrom(m.getReturnType())).map(m -> (ITypeNameSupplier)Api.invoke(m, api)).map(Api::dump).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
    }

    public static Map.Entry<String, Map<ChildElementType, Map<String, String>>> dump(ITypeNameSupplier cns) {
        Class<?> supplierClass = Ensure.notNull(cns).getClass();
        List<Method> methods = Arrays.stream(supplierClass.getMethods()).filter(m -> m.getDeclaringClass() != Object.class).filter(m -> m.getParameterCount() == 0).filter(m -> m.getReturnType() != Void.TYPE).filter(m -> !"fqn".equals(m.getName()) && !"simpleName".equals(m.getName())).collect(Collectors.toList());
        EnumMap<ChildElementType, Map<String, String>> entries = new EnumMap<ChildElementType, Map<String, String>>(ChildElementType.class);
        for (ChildElementType type : ChildElementType.values()) {
            if (type == ChildElementType.OTHER) continue;
            entries.put(type, Api.consumeMethods(methods, cns, m -> m.getName().endsWith(type.toString())));
        }
        entries.put(ChildElementType.OTHER, Api.consumeMethods(methods, cns, null));
        return new AbstractMap.SimpleImmutableEntry<String, Map<ChildElementType, Map<String, String>>>(Ensure.notNull(cns).fqn(), entries);
    }

    static Map<String, String> consumeMethods(Collection<Method> methods, ITypeNameSupplier owner, Predicate<Method> filter) {
        Map<String, String> methodResultMapping = methods.stream().filter(m -> filter == null || filter.test((Method)m)).collect(Collectors.toMap(Method::getName, m -> String.valueOf(Api.invoke(m, owner))));
        if (methodResultMapping.isEmpty()) {
            return Collections.emptyMap();
        }
        methods.removeIf(m -> methodResultMapping.containsKey(m.getName()));
        return methodResultMapping;
    }

    static Object invoke(Method m, Object instance) {
        try {
            return m.invoke(instance, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new SdkException((CharSequence)"Cannot invoke method '{}' on '{}'.", m.getName(), instance, e);
        }
    }

    public static enum ChildElementType {
        METHOD_NAME("MethodName"),
        FIELD_NAME("FieldName"),
        TYPE_PARAM_INDEX("TypeParamIndex"),
        ANNOTATION_ELEMENT_NAME("ElementName"),
        OTHER("other");

        private final String m_suffix;

        private ChildElementType(String suffix) {
            this.m_suffix = Ensure.notBlank(suffix);
        }

        public String toString() {
            return this.m_suffix;
        }
    }
}

