/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFixCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;

public class UnusedCodeCleanUpCore
extends AbstractMultiFixCore {
    public UnusedCodeCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public UnusedCodeCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        boolean requireAST = this.requireAST();
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirementsCore(requireAST, false, false, requiredOptions);
    }

    private boolean requireAST() {
        boolean removeUnuseMembers = this.isEnabled("cleanup.remove_unused_private_members");
        return removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_methods") || removeUnuseMembers && this.isEnabled("cleanup.remove_private_constructors") || removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_fields") || removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_types") || this.isEnabled("cleanup.remove_unused_local_variables") || this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports") || this.isEnabled("cleanup.remove_unused_method_parameters");
    }

    @Override
    public ICleanUpFixCore createFix(CompilationUnit compilationUnit) throws CoreException {
        boolean removeUnuseMembers = this.isEnabled("cleanup.remove_unused_private_members");
        return UnusedCodeFixCore.createCleanUp(compilationUnit, removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_methods"), removeUnuseMembers && this.isEnabled("cleanup.remove_private_constructors"), removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_fields"), removeUnuseMembers && this.isEnabled("cleanup.remove_unused_private_types"), this.isEnabled("cleanup.remove_unused_local_variables"), this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports"), false, true);
    }

    @Override
    public ICleanUpFixCore createFix(CompilationUnit compilationUnit, IProblemLocationCore[] problems) throws CoreException {
        boolean removeMembers = this.isEnabled("cleanup.remove_unused_private_members");
        return UnusedCodeFixCore.createCleanUp(compilationUnit, problems, removeMembers && this.isEnabled("cleanup.remove_unused_private_methods"), removeMembers && this.isEnabled("cleanup.remove_private_constructors"), removeMembers && this.isEnabled("cleanup.remove_unused_private_fields"), removeMembers && this.isEnabled("cleanup.remove_unused_private_types"), this.isEnabled("cleanup.remove_unused_local_variables"), this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports"), false, true);
    }

    public Map<String, String> getRequiredOptions() {
        boolean removeMembers;
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports")) {
            result.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
        }
        if ((removeMembers = this.isEnabled("cleanup.remove_unused_private_members")) && (this.isEnabled("cleanup.remove_unused_private_methods") || this.isEnabled("cleanup.remove_private_constructors") || this.isEnabled("cleanup.remove_unused_private_fields") || this.isEnabled("cleanup.remove_unused_private_types"))) {
            result.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            result.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        }
        if (this.isEnabled("cleanup.remove_unused_method_parameters")) {
            result.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.remove_unused_imports")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedImport_description);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedMethod_description);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_private_constructors")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedConstructor_description);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_types")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedType_description);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedField_description);
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedVariable_description);
        }
        if (this.isEnabled("cleanup.remove_unused_method_parameters")) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedParameter_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        StringBuilder buf = new StringBuilder();
        if (!this.isEnabled("cleanup.remove_unused_imports")) {
            buf.append("import pack.Bar;\n");
        }
        buf.append("class Example {\n");
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_unused_private_types")) {
            buf.append("    private class Sub {}\n");
        }
        buf.append("    public Example(boolean b) {}\n");
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_private_constructors")) {
            buf.append("    private Example() {}\n");
        }
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_unused_private_fields")) {
            buf.append("    private int fField;\n");
        }
        if (!this.isEnabled("cleanup.remove_unused_private_members") || !this.isEnabled("cleanup.remove_unused_private_methods")) {
            buf.append("    private void foo() {}\n");
        }
        buf.append("    public void bar() {\n");
        if (!this.isEnabled("cleanup.remove_unused_local_variables")) {
            buf.append("        int i= 10;\n");
        }
        buf.append("    }\n");
        if (this.isEnabled("cleanup.remove_unused_method_parameters")) {
            String code = "    public void zoz() {\n        zozo();\n    }\n\n    private void zozo() {\n        System.out.println(\"\");\n    };\n";
            buf.append(code);
        } else {
            String code = "    public void zoz() {\n        zozo(34);\n    }\n\n    private void zozo(int k) {\n        System.out.println(\"\");\n    };\n";
            buf.append(code);
        }
        buf.append("}\n");
        if (this.isEnabled("cleanup.remove_unused_imports")) {
            buf.append("\n");
        }
        if (this.isEnabled("cleanup.remove_unused_private_members")) {
            if (this.isEnabled("cleanup.remove_unused_private_types")) {
                buf.append("\n");
            }
            if (this.isEnabled("cleanup.remove_private_constructors")) {
                buf.append("\n");
            }
            if (this.isEnabled("cleanup.remove_unused_private_fields")) {
                buf.append("\n");
            }
            if (this.isEnabled("cleanup.remove_unused_private_methods")) {
                buf.append("\n");
            }
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocationCore problem) {
        if (UnusedCodeFixCore.isUnusedImport(problem)) {
            return this.isEnabled("cleanup.remove_unused_imports");
        }
        if (UnusedCodeFixCore.isUnusedMember(problem)) {
            return this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_private_constructors") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_types") || this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields") || this.isEnabled("cleanup.remove_unused_local_variables");
        }
        if (UnusedCodeFixCore.isUnusedParameter(problem)) {
            return this.isEnabled("cleanup.remove_unused_method_parameters");
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unused_imports") && !this.isEnabled("cleanup.organize_imports")) {
            IProblem[] iProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem problem = iProblemArray[n2];
                int id = problem.getID();
                if (id == 268435844 || id == 268435842 || id == 0x10000181 || id == 268435843 || id == 268435846) {
                    ++result;
                }
                ++n2;
            }
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_methods")) {
            result += UnusedCodeCleanUpCore.getNumberOfProblems(problems, 603979894);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_private_constructors")) {
            result += UnusedCodeCleanUpCore.getNumberOfProblems(problems, 603979910);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_types")) {
            result += UnusedCodeCleanUpCore.getNumberOfProblems(problems, 553648135);
        }
        if (this.isEnabled("cleanup.remove_unused_private_members") && this.isEnabled("cleanup.remove_unused_private_fields")) {
            result += UnusedCodeCleanUpCore.getNumberOfProblems(problems, 570425421);
        }
        if (this.isEnabled("cleanup.remove_unused_local_variables")) {
            result += UnusedCodeCleanUpCore.getNumberOfProblems(problems, 536870973);
        }
        if (this.isEnabled("cleanup.remove_unused_method_parameters")) {
            result += UnusedCodeCleanUpCore.getNumberOfProblems(problems, 536870974);
        }
        return result;
    }
}

