/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.ecj.metavalue;

import java.util.stream.Stream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.scout.sdk.core.model.api.AbstractMetaValue;
import org.eclipse.scout.sdk.core.model.api.ArrayMetaValue;
import org.eclipse.scout.sdk.core.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.MetaValueType;
import org.eclipse.scout.sdk.core.model.ecj.metavalue.ConstantMetaValue;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MemberSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;

public final class MetaValueFactory {
    private static final IMetaValue NULL_META_VALUE = new AbstractMetaValue(){

        public MetaValueType type() {
            return MetaValueType.Null;
        }

        protected Object getInternalObject(Class<?> expectedType) {
            return null;
        }

        public String toString() {
            return "null";
        }
    };

    private MetaValueFactory() {
    }

    public static IMetaValue createNull() {
        return NULL_META_VALUE;
    }

    public static IMetaValue createUnknown(final Object o) {
        if (o == null) {
            return MetaValueFactory.createNull();
        }
        return new AbstractMetaValue(){

            public MetaValueType type() {
                return MetaValueType.Unknown;
            }

            protected Object getInternalObject(Class<?> expectedType) {
                return o;
            }

            public String toString() {
                StringBuilder b = new StringBuilder(this.type().toString());
                b.append('(');
                b.append(o);
                b.append(')');
                return b.toString();
            }
        };
    }

    public static IMetaValue createFromType(final TypeSpi type) {
        if (type == null) {
            return MetaValueFactory.createNull();
        }
        return new AbstractMetaValue(){

            public MetaValueType type() {
                return MetaValueType.Type;
            }

            protected Object getInternalObject(Class<?> expectedType) {
                if (IType.class == expectedType || Object.class == expectedType) {
                    return type.wrap();
                }
                if (String.class == expectedType) {
                    return type.getName();
                }
                return type;
            }

            public String toString() {
                return type.getElementName() + ".class";
            }
        };
    }

    public static IMetaValue createFromEnum(final MemberSpi enumConstant) {
        if (enumConstant == null) {
            return MetaValueFactory.createNull();
        }
        return new AbstractMetaValue(){

            public MetaValueType type() {
                return MetaValueType.Enum;
            }

            protected Object getInternalObject(Class<?> expectedType) {
                if (IField.class == expectedType || Object.class == expectedType) {
                    return enumConstant.wrap();
                }
                if (String.class == expectedType) {
                    return enumConstant.getElementName();
                }
                return enumConstant;
            }

            public String toString() {
                return enumConstant.getDeclaringType().getElementName() + "." + enumConstant.getElementName();
            }
        };
    }

    public static IMetaValue createFromAnnotation(final JavaElementSpi a) {
        if (a == null) {
            return MetaValueFactory.createNull();
        }
        return new AbstractMetaValue(){

            public MetaValueType type() {
                return MetaValueType.Annotation;
            }

            public Stream<IJavaElement> children() {
                return Stream.of((IJavaElement)this.as(IAnnotation.class));
            }

            protected Object getInternalObject(Class<?> expectedType) {
                if (IAnnotation.class == expectedType || Object.class == expectedType) {
                    return a.wrap();
                }
                return a;
            }

            public String toString() {
                return this.getInternalObject(IAnnotation.class).toString();
            }
        };
    }

    public static IMetaValue createArray(IMetaValue[] metaArray) {
        if (metaArray == null) {
            return MetaValueFactory.createNull();
        }
        return new ArrayMetaValue(metaArray);
    }

    public static IMetaValue createFromConstant(Constant c) {
        if (c == null) {
            return MetaValueFactory.createNull();
        }
        return switch (c.typeID()) {
            case 10 -> new ConstantMetaValue(c, MetaValueType.Int);
            case 12 -> MetaValueFactory.createNull();
            case 3 -> new ConstantMetaValue(c, MetaValueType.Byte);
            case 4 -> new ConstantMetaValue(c, MetaValueType.Short);
            case 2 -> new ConstantMetaValue(c, MetaValueType.Char);
            case 9 -> new ConstantMetaValue(c, MetaValueType.Float);
            case 8 -> new ConstantMetaValue(c, MetaValueType.Double);
            case 5 -> new ConstantMetaValue(c, MetaValueType.Bool);
            case 7 -> new ConstantMetaValue(c, MetaValueType.Long);
            case 11 -> new ConstantMetaValue(c, MetaValueType.String);
            default -> MetaValueFactory.createUnknown(c);
        };
    }
}

