/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.ecj;

import java.util.Objects;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.JavaTypes;

public class TypeNameDescriptor {
    private final String m_fqn;
    private final String m_primaryTypeName;
    private final String m_innerTypeNames;
    private final int m_arrayDimension;

    public static TypeNameDescriptor of(String fqn) {
        int firstDollarPos = ((String)Ensure.notNull((Object)fqn)).indexOf(36);
        int arrayDim = TypeNameDescriptor.getArrayDimension(fqn);
        if (arrayDim > 0) {
            fqn = fqn.substring(0, fqn.length() - arrayDim * 2);
        }
        if (firstDollarPos > 0) {
            String primaryType = fqn.substring(0, firstDollarPos);
            String innerTypePart = fqn.substring(firstDollarPos + 1);
            return new TypeNameDescriptor(fqn, primaryType, innerTypePart, arrayDim);
        }
        return new TypeNameDescriptor(fqn, fqn, null, arrayDim);
    }

    protected static int getArrayDimension(String fqn) {
        int pos = fqn.indexOf(JavaTypes.arrayMarker());
        if (pos < 0) {
            return 0;
        }
        return (fqn.length() - pos) / 2;
    }

    protected TypeNameDescriptor(String fqn, String primaryTypeName, String innerTypeNames, int arrayDimension) {
        this.m_fqn = fqn;
        this.m_primaryTypeName = primaryTypeName;
        this.m_innerTypeNames = innerTypeNames;
        this.m_arrayDimension = arrayDimension;
    }

    public boolean hasInnerType() {
        return this.m_innerTypeNames != null;
    }

    public String getFullyQualifiedName() {
        return this.m_fqn;
    }

    public String getPrimaryTypeName() {
        return this.m_primaryTypeName;
    }

    public String getInnerTypeNames() {
        return this.m_innerTypeNames;
    }

    public int getArrayDimension() {
        return this.m_arrayDimension;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.m_arrayDimension;
        result = prime * result + (this.m_innerTypeNames == null ? 0 : this.m_innerTypeNames.hashCode());
        result = prime * result + this.m_primaryTypeName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeNameDescriptor other = (TypeNameDescriptor)obj;
        if (this.m_arrayDimension != other.m_arrayDimension) {
            return false;
        }
        return Objects.equals(this.m_innerTypeNames, other.m_innerTypeNames) && Objects.equals(this.m_primaryTypeName, other.m_primaryTypeName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TypeNameDescriptor [");
        builder.append("primaryTypeName=").append(this.getPrimaryTypeName()).append(", ");
        if (this.m_innerTypeNames != null) {
            builder.append("innerTypeNames=").append(this.m_innerTypeNames).append(", ");
        }
        builder.append("arrayDimension=").append(this.getArrayDimension()).append(']');
        return builder.toString();
    }
}

