/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.ecj;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.scout.sdk.core.model.CompilationUnitInfo;
import org.eclipse.scout.sdk.core.util.Strings;

public class StringBasedCompilationUnitWithEcj
implements ICompilationUnit {
    private final char[][] m_packageName;
    private final char[] m_fileName;
    private final char[] m_src;
    private final char[] m_mainTypeName;
    private final String m_fqn;
    private final char[] m_moduleName;
    private final String m_destinationPath;

    public StringBasedCompilationUnitWithEcj(CompilationUnitInfo cuInfo, char[] src, String moduleName) {
        this.m_destinationPath = cuInfo.targetFileAsString();
        String pck = cuInfo.packageName();
        this.m_packageName = pck != null ? CharOperation.splitOn((char)'.', (char[])pck.toCharArray()) : null;
        this.m_fileName = this.m_destinationPath.toCharArray();
        this.m_mainTypeName = cuInfo.mainTypeSimpleName().toCharArray();
        this.m_fqn = cuInfo.mainTypeFullyQualifiedName();
        this.m_src = src;
        this.m_moduleName = Strings.isEmpty((CharSequence)moduleName) ? ModuleBinding.UNNAMED : moduleName.toCharArray();
    }

    public char[] getFileName() {
        return this.m_fileName;
    }

    public char[] getContents() {
        return this.m_src;
    }

    public char[] getMainTypeName() {
        return this.m_mainTypeName;
    }

    public char[][] getPackageName() {
        return this.m_packageName;
    }

    public boolean ignoreOptionalProblems() {
        return true;
    }

    public String getFullyQualifiedName() {
        return this.m_fqn;
    }

    public char[] getModuleName() {
        return this.m_moduleName;
    }

    public String getDestinationPath() {
        return this.m_destinationPath;
    }
}

