/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.ecj;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.MethodParameterImplementor;
import org.eclipse.scout.sdk.core.model.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationAnnotationWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationMethodWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class DeclarationMethodParameterWithEcj
extends AbstractJavaElementWithEcj<IMethodParameter>
implements MethodParameterSpi {
    private final DeclarationMethodWithEcj m_declaringMethod;
    private final Argument m_astNode;
    private final int m_index;
    private final FinalValue<String> m_name;
    private final FinalValue<TypeSpi> m_dataType;
    private final FinalValue<List<DeclarationAnnotationWithEcj>> m_annotations;
    private final FinalValue<ISourceRange> m_source;
    private int m_flags;

    protected DeclarationMethodParameterWithEcj(AbstractJavaEnvironment env, DeclarationMethodWithEcj declaringMethod, Argument astNode, int index) {
        super(env);
        this.m_declaringMethod = (DeclarationMethodWithEcj)((Object)Ensure.notNull((Object)((Object)declaringMethod)));
        this.m_astNode = (Argument)Ensure.notNull((Object)astNode);
        this.m_index = index;
        this.m_flags = -1;
        this.m_name = new FinalValue();
        this.m_dataType = new FinalValue();
        this.m_annotations = new FinalValue();
        this.m_source = new FinalValue();
    }

    public MethodParameterSpi internalFindNewElement() {
        MethodSpi newMethod = this.getDeclaringMethod().internalFindNewElement();
        if (newMethod != null && newMethod.getParameters().size() > this.m_index) {
            return (MethodParameterSpi)newMethod.getParameters().get(this.m_index);
        }
        return null;
    }

    protected IMethodParameter internalCreateApi() {
        return new MethodParameterImplementor((MethodParameterSpi)this);
    }

    public Argument getInternalArgument() {
        return this.m_astNode;
    }

    public DeclarationMethodWithEcj getDeclaringMethod() {
        return this.m_declaringMethod;
    }

    public String getElementName() {
        return (String)this.m_name.computeIfAbsentAndGet(() -> new String(this.m_astNode.name));
    }

    public TypeSpi getDataType() {
        return (TypeSpi)this.m_dataType.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), DeclarationMethodParameterWithEcj.resolveParameterType(this), () -> (TypeBinding)this.withNewElement(DeclarationMethodParameterWithEcj::resolveParameterType)));
    }

    protected static TypeBinding resolveParameterType(DeclarationMethodParameterWithEcj methodParam) {
        return SpiWithEcjUtils.resolveTypeOfArgument((AbstractVariableDeclaration)methodParam.m_astNode, (BlockScope)methodParam.getDeclaringMethod().getInternalMethodDeclaration().scope, methodParam.javaEnvWithEcj());
    }

    public int getIndex() {
        return this.m_index;
    }

    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithEcjUtils.getMethodFlags(this.m_astNode.modifiers, false, SpiWithEcjUtils.hasDeprecatedAnnotation(this.getAnnotations()));
        }
        return this.m_flags;
    }

    public List<DeclarationAnnotationWithEcj> getAnnotations() {
        return (List)this.m_annotations.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createDeclarationAnnotations(this.javaEnvWithEcj(), (AnnotatableSpi)this, this.m_astNode.annotations));
    }

    public ISourceRange getSource() {
        return (ISourceRange)this.m_source.computeIfAbsentAndGet(() -> {
            CompilationUnitSpi cu = this.m_declaringMethod.getDeclaringType().getCompilationUnit();
            Argument decl = this.m_astNode;
            return this.javaEnvWithEcj().getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
        });
    }
}

