/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.eclipse.scout.sdk.core.util.Ensure;

public class CharSequenceInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 2048;
    private static final int EOF = -1;
    private static final int NO_MARK = -1;
    private final CharsetEncoder m_encoder;
    private final CharBuffer m_cbuf;
    private final ByteBuffer m_bbuf;
    private int m_markCbuf;
    private int m_markBbuf;

    public CharSequenceInputStream(CharSequence cs, Charset charset, int bufferSize) {
        this.m_encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        float maxBytesPerChar = this.m_encoder.maxBytesPerChar();
        if ((float)bufferSize < maxBytesPerChar) {
            throw new IllegalArgumentException("Buffer size " + bufferSize + " is less than maxBytesPerChar " + maxBytesPerChar);
        }
        this.m_bbuf = ByteBuffer.allocate(bufferSize);
        this.m_bbuf.flip();
        this.m_cbuf = CharBuffer.wrap(cs);
        this.m_markCbuf = -1;
        this.m_markBbuf = -1;
    }

    public CharSequenceInputStream(CharSequence cs, String charset, int bufferSize) {
        this(cs, Charset.forName(charset), bufferSize);
    }

    public CharSequenceInputStream(CharSequence cs, Charset charset) {
        this(cs, charset, 2048);
    }

    public CharSequenceInputStream(CharSequence cs, String charset) {
        this(cs, charset, 2048);
    }

    private void fillBuffer() throws CharacterCodingException {
        this.m_bbuf.compact();
        CoderResult result = this.m_encoder.encode(this.m_cbuf, this.m_bbuf, true);
        if (result.isError()) {
            result.throwException();
        }
        this.m_bbuf.flip();
    }

    @Override
    public int read(byte[] b, int off, int len) throws CharacterCodingException {
        if (len < 0 || off + len > ((byte[])Ensure.notNull((Object)b)).length) {
            throw new IndexOutOfBoundsException("Array Size=" + b.length + ", offset=" + off + ", length=" + len);
        }
        if (len == 0) {
            return 0;
        }
        if (!this.m_bbuf.hasRemaining() && !this.m_cbuf.hasRemaining()) {
            return -1;
        }
        int bytesRead = 0;
        while (len > 0) {
            if (this.m_bbuf.hasRemaining()) {
                int chunk = Math.min(this.m_bbuf.remaining(), len);
                this.m_bbuf.get(b, off, chunk);
                off += chunk;
                len -= chunk;
                bytesRead += chunk;
                continue;
            }
            this.fillBuffer();
            if (this.m_bbuf.hasRemaining() || this.m_cbuf.hasRemaining()) continue;
        }
        return bytesRead == 0 && !this.m_cbuf.hasRemaining() ? -1 : bytesRead;
    }

    @Override
    public int read() throws CharacterCodingException {
        do {
            if (this.m_bbuf.hasRemaining()) {
                return this.m_bbuf.get() & 0xFF;
            }
            this.fillBuffer();
        } while (this.m_bbuf.hasRemaining() || this.m_cbuf.hasRemaining());
        return -1;
    }

    @Override
    public int read(byte[] b) throws CharacterCodingException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws CharacterCodingException {
        long skipped = 0L;
        while (n > 0L && this.available() > 0) {
            this.read();
            --n;
            ++skipped;
        }
        return skipped;
    }

    @Override
    public int available() {
        return this.m_bbuf.remaining() + this.m_cbuf.remaining();
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.m_markCbuf = this.m_cbuf.position();
        this.m_markBbuf = this.m_bbuf.position();
        this.m_cbuf.mark();
        this.m_bbuf.mark();
    }

    @Override
    public synchronized void reset() throws CharacterCodingException {
        if (this.m_markCbuf != -1) {
            if (this.m_cbuf.position() != 0) {
                this.m_encoder.reset();
                this.m_cbuf.rewind();
                this.m_bbuf.rewind();
                this.m_bbuf.limit(0);
                while (this.m_cbuf.position() < this.m_markCbuf) {
                    this.m_bbuf.rewind();
                    this.m_bbuf.limit(0);
                    this.fillBuffer();
                }
            }
            if (this.m_cbuf.position() != this.m_markCbuf) {
                throw new IllegalStateException("Unexpected CharBuffer postion: actual=" + this.m_cbuf.position() + " expected=" + this.m_markCbuf);
            }
            this.m_bbuf.position(this.m_markBbuf);
            this.m_markCbuf = -1;
            this.m_markBbuf = -1;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

