/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.uniqueid;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Ensure;

public final class UniqueIds {
    private static final List<Function<String, String>> STORE = new ArrayList<Function<String, String>>();

    private UniqueIds() {
    }

    public static synchronized boolean registerIdProvider(Function<String, String> provider) {
        if (STORE.contains(Ensure.notNull(provider))) {
            return false;
        }
        STORE.add(0, provider);
        return true;
    }

    public static synchronized boolean removeIdProvider(Function<String, String> provider) {
        return STORE.remove(provider);
    }

    public static synchronized List<Function<String, String>> providers() {
        return new ArrayList<Function<String, String>>(STORE);
    }

    public static String next(String dataType) {
        for (Function<String, String> p : UniqueIds.providers()) {
            try {
                String value = p.apply(dataType);
                if (value == null) continue;
                return value;
            }
            catch (RuntimeException e) {
                SdkLog.warning((CharSequence)"Exception in UniqueIdProvider '{}'.", (Object[])new Object[]{p.getClass().getName(), e});
            }
        }
        return null;
    }
}

