/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.query;

import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.s.apidef.ScoutApi;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.util.search.FileQueryInput;
import org.eclipse.scout.sdk.core.s.util.search.FileRange;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SourceState;
import org.eclipse.scout.sdk.core.util.Strings;

public final class TranslationPatterns {
    public static final String IGNORE_MARKER = "NO-NLS-CHECK";
    private static final Map<Class<? extends AbstractTranslationPattern>, AbstractTranslationPattern> PATTERN_MAP = new HashMap<Class<? extends AbstractTranslationPattern>, AbstractTranslationPattern>();

    private TranslationPatterns() {
    }

    public static synchronized boolean registerPattern(AbstractTranslationPattern pattern) {
        return PATTERN_MAP.put(((AbstractTranslationPattern)Ensure.notNull((Object)pattern)).getClass(), pattern) != null;
    }

    public static synchronized boolean removePattern(AbstractTranslationPattern pattern) {
        return PATTERN_MAP.remove(((AbstractTranslationPattern)Ensure.notNull((Object)pattern)).getClass()) != null;
    }

    public static synchronized Stream<AbstractTranslationPattern> all() {
        return new HashSet<AbstractTranslationPattern>(PATTERN_MAP.values()).stream();
    }

    static {
        Stream.of(JavaTextsGetPattern.INSTANCE, JsSessionTextPattern.INSTANCE, TsSessionTextPattern.INSTANCE, JsModelTextKeyPattern.INSTANCE, TsModelTextKeyPattern.INSTANCE, HtmlScoutMessagePattern.INSTANCE).forEach(TranslationPatterns::registerPattern);
    }

    public static abstract class AbstractTranslationPattern {
        protected static final String NLS_KEY_PAT = ITranslation.KEY_REGEX.pattern();

        public abstract Pattern pattern();

        public abstract String fileExtension();

        public abstract Optional<FileRange> keyRangeIfAccept(MatchResult var1, FileQueryInput var2);

        protected static FileRange toFileRange(MatchResult match, FileQueryInput fileQueryInput, int keyGroup) {
            int startIndex = match.start(keyGroup);
            int endIndex = match.end(keyGroup);
            CharBuffer key = CharBuffer.wrap(fileQueryInput.fileContent(), startIndex, endIndex);
            return new FileRange(fileQueryInput.file(), fileQueryInput.module(), key, startIndex, endIndex);
        }

        protected static boolean lineEndsWithIgnoreMarker(CharSequence content, int offset) {
            int lineEnd = Strings.nextLineEnd((CharSequence)content, (int)offset);
            CharBuffer end = CharBuffer.wrap(content, lineEnd - TranslationPatterns.IGNORE_MARKER.length(), lineEnd);
            return Strings.equals((CharSequence)TranslationPatterns.IGNORE_MARKER, (CharSequence)end, (boolean)false);
        }

        protected static boolean isKeyInCode(CharSequence content, int offset) {
            int posBeforeKeyMatch = offset - 2;
            return SourceState.isInCode((CharSequence)content, (int)posBeforeKeyMatch);
        }

        protected static boolean isAcceptedCodeMatch(MatchResult match, int keyGroup, CharSequence content) {
            int endIndex = match.end(keyGroup);
            if (AbstractTranslationPattern.lineEndsWithIgnoreMarker(content, endIndex)) {
                return false;
            }
            int startIndex = match.start(keyGroup);
            return AbstractTranslationPattern.isKeyInCode(content, startIndex);
        }

        protected static Optional<FileRange> keyRangeIfInCode(MatchResult match, FileQueryInput fileQueryInput, int keyGroup) {
            if (!AbstractTranslationPattern.isAcceptedCodeMatch(match, keyGroup, fileQueryInput.fileContent())) {
                return Optional.empty();
            }
            return Optional.of(AbstractTranslationPattern.toFileRange(match, fileQueryInput, keyGroup));
        }
    }

    public static class JavaTextsGetPattern
    extends AbstractTranslationPattern {
        public static final AbstractTranslationPattern INSTANCE = new JavaTextsGetPattern();
        public static final Pattern REGEX = Pattern.compile(JavaTextsGetPattern.computeTextsGetRegex());

        private static String computeTextsGetRegex() {
            return ScoutApi.allKnown().map(JavaTextsGetPattern::toTextsGetRegex).distinct().collect(Collectors.joining("|"));
        }

        private static String toTextsGetRegex(IScoutVariousApi api) {
            IScoutVariousApi.TEXTS texts = api.TEXTS();
            return texts.simpleName() + "\\." + texts.getMethodName() + "\\((?:[a-zA-Z0-9_]+,\\s*)?(\")?(" + NLS_KEY_PAT + ")(\")?\\s*[,)]";
        }

        protected JavaTextsGetPattern() {
        }

        @Override
        public Pattern pattern() {
            return REGEX;
        }

        @Override
        public String fileExtension() {
            return "java";
        }

        @Override
        public Optional<FileRange> keyRangeIfAccept(MatchResult match, FileQueryInput fileQueryInput) {
            return JavaTextsGetPattern.keyRangeIfInCode(match, fileQueryInput, 2);
        }
    }

    public static class JsSessionTextPattern
    extends AbstractTranslationPattern {
        public static final AbstractTranslationPattern INSTANCE = new JsSessionTextPattern();
        public static final Pattern REGEX = Pattern.compile("session\\.text\\((['`\"]?)(" + NLS_KEY_PAT + ")(['`\"]?)\\s*[,)]");

        protected JsSessionTextPattern() {
        }

        @Override
        public Pattern pattern() {
            return REGEX;
        }

        @Override
        public String fileExtension() {
            return "js";
        }

        @Override
        public Optional<FileRange> keyRangeIfAccept(MatchResult match, FileQueryInput fileQueryInput) {
            return JsSessionTextPattern.keyRangeIfInCode(match, fileQueryInput, 2);
        }
    }

    public static class TsSessionTextPattern
    extends JsSessionTextPattern {
        public static final AbstractTranslationPattern INSTANCE = new TsSessionTextPattern();

        protected TsSessionTextPattern() {
        }

        @Override
        public String fileExtension() {
            return "ts";
        }
    }

    public static class JsModelTextKeyPattern
    extends AbstractTranslationPattern {
        public static final String MODEL_TEXT_KEY_PREFIX = "${textKey:";
        public static final String MODEL_TEXT_KEY_SUFFIX = "}";
        public static final AbstractTranslationPattern INSTANCE = new JsModelTextKeyPattern();
        public static final Pattern REGEX = Pattern.compile(Pattern.quote("${textKey:") + "(" + NLS_KEY_PAT + ")");

        protected JsModelTextKeyPattern() {
        }

        @Override
        public Pattern pattern() {
            return REGEX;
        }

        @Override
        public String fileExtension() {
            return "js";
        }

        @Override
        public Optional<FileRange> keyRangeIfAccept(MatchResult match, FileQueryInput fileQueryInput) {
            int keyGroup = 1;
            if (JsModelTextKeyPattern.lineEndsWithIgnoreMarker(fileQueryInput.fileContent(), match.end(keyGroup))) {
                return Optional.empty();
            }
            int startIndex = match.start(1);
            if (!SourceState.isInString((CharSequence)fileQueryInput.fileContent(), (int)startIndex)) {
                return Optional.empty();
            }
            return Optional.of(JsModelTextKeyPattern.toFileRange(match, fileQueryInput, keyGroup));
        }
    }

    public static class TsModelTextKeyPattern
    extends JsModelTextKeyPattern {
        public static final AbstractTranslationPattern INSTANCE = new TsModelTextKeyPattern();

        @Override
        public String fileExtension() {
            return "ts";
        }
    }

    public static class HtmlScoutMessagePattern
    extends AbstractTranslationPattern {
        public static final String ATTRIBUTE_NAME = "key";
        public static final String SCOUT_MESSAGE_TAG_NAME = "scout:message";
        public static final AbstractTranslationPattern INSTANCE = new HtmlScoutMessagePattern();
        public static final Pattern REGEX = Pattern.compile("\\s+key=['\"](" + NLS_KEY_PAT + ")[\"']");

        protected HtmlScoutMessagePattern() {
        }

        @Override
        public Pattern pattern() {
            return REGEX;
        }

        @Override
        public String fileExtension() {
            return "html";
        }

        @Override
        public Optional<FileRange> keyRangeIfAccept(MatchResult match, FileQueryInput fileQueryInput) {
            int keyGroup = 1;
            CharSequence textToNextNewLine = HtmlScoutMessagePattern.textToNextNewLine(fileQueryInput.fileContent(), match.end(keyGroup));
            boolean isIgnored = Strings.endsWith((CharSequence)textToNextNewLine, (CharSequence)"NO-NLS-CHECK -->", (boolean)false);
            if (isIgnored) {
                return Optional.empty();
            }
            return Optional.of(HtmlScoutMessagePattern.toFileRange(match, fileQueryInput, keyGroup));
        }

        public static CharSequence textToNextNewLine(CharSequence searchIn, int offset) {
            int lineEnd = Strings.nextLineEnd((CharSequence)searchIn, (int)offset);
            return searchIn.subSequence(offset, lineEnd);
        }
    }
}

