/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.query;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.Translations;
import org.eclipse.scout.sdk.core.s.nls.query.TranslationPatterns;
import org.eclipse.scout.sdk.core.s.util.search.FileQueryInput;
import org.eclipse.scout.sdk.core.s.util.search.FileQueryMatch;
import org.eclipse.scout.sdk.core.s.util.search.FileRange;
import org.eclipse.scout.sdk.core.s.util.search.IFileQuery;
import org.eclipse.scout.sdk.core.util.Strings;

public class TranslationKeysQuery
implements IFileQuery {
    private static final String LITERAL_DELIMITER = "['`\"]";
    private static final Pattern TRANSLATION_LITERAL_PATTERN = Pattern.compile("['`\"](" + ITranslation.KEY_REGEX.pattern() + ")['`\"]");
    private final Set<String> m_acceptedFileExtensions = Translations.DependencyScope.supportedFileExtensions().keySet();
    private final Map<Path, Set<FileQueryMatch>> m_result = new HashMap<Path, Set<FileQueryMatch>>();
    private final String m_name;

    public TranslationKeysQuery() {
        this(null);
    }

    public TranslationKeysQuery(String name) {
        this.m_name = Strings.notBlank((CharSequence)name).orElse("Search all translation keys");
    }

    @Override
    public void searchIn(FileQueryInput input) {
        if (!this.m_acceptedFileExtensions.contains(input.fileExtension())) {
            return;
        }
        CharSequence fileContent = input.fileContent();
        Stream.of(TRANSLATION_LITERAL_PATTERN, TranslationPatterns.JsModelTextKeyPattern.REGEX).flatMap(pat -> pat.matcher(fileContent).results()).map(r -> TranslationKeysQuery.toMatch(input, r)).forEach(m -> this.m_result.computeIfAbsent(input.file(), k -> new HashSet()).add(m));
    }

    protected static FileQueryMatch toMatch(FileQueryInput input, MatchResult result) {
        return new FileQueryMatch(input.file(), input.module(), result.group(1), result.start(1), result.end(1));
    }

    public Stream<String> keysFound() {
        return this.result().map(FileRange::text).map(Objects::toString).distinct();
    }

    public Map<String, Set<FileQueryMatch>> resultByKey() {
        return this.result().collect(Collectors.groupingBy(m -> m.text().toString(), Collectors.toSet()));
    }

    public Stream<FileQueryMatch> result(String nlsKey) {
        return this.result().filter(m -> Objects.equals(nlsKey, m.text().toString()));
    }

    @Override
    public Set<FileQueryMatch> result(Path file) {
        Set<FileQueryMatch> set = this.m_result.get(file);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Stream<FileQueryMatch> result() {
        return this.m_result.values().stream().flatMap(Collection::stream);
    }

    @Override
    public String name() {
        return this.m_name;
    }
}

