/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.query;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.s.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.s.apidef.ScoutApi;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Translations;
import org.eclipse.scout.sdk.core.s.nls.query.TranslationPatterns;
import org.eclipse.scout.sdk.core.s.util.search.FileQueryInput;
import org.eclipse.scout.sdk.core.s.util.search.FileQueryMatch;
import org.eclipse.scout.sdk.core.s.util.search.FileRange;
import org.eclipse.scout.sdk.core.s.util.search.IFileQuery;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class MissingTranslationQuery
implements IFileQuery {
    public static final String JS_TEXTS_FILE_NAME = "texts.js";
    private final Set<String> m_javaTextsFileName = ScoutApi.allKnown().map(IScoutVariousApi::TEXTS).map(ITypeNameSupplier::simpleName).map(name -> name + ".java").collect(Collectors.toSet());
    private final Map<String, List<TranslationPatterns.AbstractTranslationPattern>> m_searchPatterns;
    private final Map<CompositeObject, Optional<Set<String>>> m_keysByModuleCache;
    private final Map<Path, Set<FileQueryMatch>> m_matches;
    private final BiFunction<Path, Translations.DependencyScope, List<ITranslationStore>> m_storeSupplier;

    public MissingTranslationQuery(IEnvironment env, IProgress progress) {
        this((p, s) -> Translations.storesForModule(p, env, progress, s).collect(Collectors.toList()));
    }

    public MissingTranslationQuery(BiFunction<Path, Translations.DependencyScope, List<ITranslationStore>> storeSupplier) {
        this.m_storeSupplier = (BiFunction)Ensure.notNull(storeSupplier);
        this.m_keysByModuleCache = new ConcurrentHashMap<CompositeObject, Optional<Set<String>>>();
        this.m_matches = new ConcurrentHashMap<Path, Set<FileQueryMatch>>();
        this.m_searchPatterns = TranslationPatterns.all().collect(Collectors.groupingBy(TranslationPatterns.AbstractTranslationPattern::fileExtension));
    }

    @Override
    public String name() {
        return "Search for text keys that are used in the code but cannot be found";
    }

    protected boolean acceptCandidate(FileQueryInput candidate) {
        if (!this.m_searchPatterns.containsKey(candidate.fileExtension())) {
            return false;
        }
        Path fullPath = candidate.file();
        if (MissingTranslationQuery.pathContainsSegment(fullPath, "archetype-resources") || MissingTranslationQuery.pathContainsSegment(fullPath, "generated-resources") || fullPath.endsWith(JS_TEXTS_FILE_NAME)) {
            return false;
        }
        Path fileName = fullPath.getFileName();
        if (fileName == null) {
            return false;
        }
        String fileNameAsString = fileName.toString();
        return !this.m_javaTextsFileName.contains(fileNameAsString);
    }

    protected static boolean pathContainsSegment(Iterable<Path> path, String name) {
        Path toSearch = Paths.get(name, new String[0]);
        for (Path segment : path) {
            if (!segment.equals(toSearch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void searchIn(FileQueryInput input) {
        if (!this.acceptCandidate(input)) {
            return;
        }
        String fileExtension = input.fileExtension();
        Translations.DependencyScope dependencyScope = Translations.DependencyScope.forFileExtension(fileExtension).orElseThrow(() -> Ensure.newFail((CharSequence)"Unsupported file extension: {}.", (Object[])new Object[]{fileExtension}));
        List<TranslationPatterns.AbstractTranslationPattern> patterns = this.m_searchPatterns.get(fileExtension);
        CharSequence content = input.fileContent();
        for (TranslationPatterns.AbstractTranslationPattern search : patterns) {
            Matcher matcher = search.pattern().matcher(content);
            while (matcher.find()) {
                this.checkMatch(matcher, search, input, dependencyScope);
            }
        }
    }

    protected void checkMatch(MatchResult match, TranslationPatterns.AbstractTranslationPattern search, FileQueryInput fileQueryInput, Translations.DependencyScope scope) {
        int keyGroup;
        if (match.groupCount() > 1) {
            boolean noLiteral;
            keyGroup = 2;
            boolean bl = noLiteral = Strings.isEmpty((CharSequence)match.group(1)) || Strings.isEmpty((CharSequence)match.group(3));
            if (noLiteral) {
                if (!this.tryToResolveConstant(match.group(keyGroup), fileQueryInput, scope)) {
                    this.registerMatchIfNotIgnored(match, Level.INFO.intValue(), search, fileQueryInput);
                }
                return;
            }
        } else {
            keyGroup = 1;
        }
        this.registerMatchIfKeyIsMissing(match, keyGroup, Level.WARNING.intValue(), search, scope, fileQueryInput);
    }

    protected boolean tryToResolveConstant(String constantName, FileQueryInput fileQueryInput, Translations.DependencyScope scope) {
        AssignmentPattern findAssignment = new AssignmentPattern(constantName);
        CharSequence content = fileQueryInput.fileContent();
        Matcher constantMatcher = findAssignment.pattern().matcher(content);
        boolean constantFound = false;
        while (constantMatcher.find()) {
            this.registerMatchIfKeyIsMissing(constantMatcher, 1, Level.WARNING.intValue(), findAssignment, scope, fileQueryInput);
            constantFound = true;
        }
        return constantFound;
    }

    protected void registerMatchIfKeyIsMissing(MatchResult match, int keyGroup, int severity, TranslationPatterns.AbstractTranslationPattern pattern, Translations.DependencyScope scope, FileQueryInput queryInput) {
        String key = match.group(keyGroup);
        if (this.keyExistsForModule(queryInput.module(), key, scope)) {
            return;
        }
        this.registerMatchIfNotIgnored(match, severity, pattern, queryInput);
    }

    protected void registerMatchIfNotIgnored(MatchResult match, int severity, TranslationPatterns.AbstractTranslationPattern pattern, FileQueryInput queryInput) {
        pattern.keyRangeIfAccept(match, queryInput).map(range -> FileQueryMatch.fromFileRange(range, severity)).ifPresent(m -> this.m_matches.computeIfAbsent(queryInput.file(), file -> ConcurrentHashMap.newKeySet()).add(m));
    }

    protected boolean keyExistsForModule(Path modulePath, String key, Translations.DependencyScope scope) {
        return this.accessibleKeysForModule(modulePath, scope).map(keys -> keys.contains(key)).orElse(true);
    }

    protected Optional<Set<String>> accessibleKeysForModule(Path modulePath, Translations.DependencyScope scope) {
        CompositeObject key = new CompositeObject(new Object[]{modulePath, scope});
        return this.m_keysByModuleCache.computeIfAbsent(key, mp -> this.computeAccessibleKeysForModule(modulePath, scope));
    }

    protected Optional<Set<String>> computeAccessibleKeysForModule(Path modulePath, Translations.DependencyScope scope) {
        List<ITranslationStore> stores = this.m_storeSupplier.apply(modulePath, scope);
        if (stores.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(stores.stream().flatMap(ITranslationStore::keys).collect(Collectors.toSet()));
    }

    @Override
    public Stream<FileQueryMatch> result() {
        return this.m_matches.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Set<FileQueryMatch> result(Path file) {
        return MissingTranslationQuery.getFromResultMap(this.m_matches, file);
    }

    protected static <K, V> Set<V> getFromResultMap(Map<K, Set<V>> map, K key) {
        Set<V> ranges = map.get(key);
        if (ranges == null || ranges.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ranges);
    }

    private static final class AssignmentPattern
    extends TranslationPatterns.AbstractTranslationPattern {
        private final Pattern m_pattern;

        private AssignmentPattern(String constantName) {
            this.m_pattern = Pattern.compile("\\s+" + constantName + "\\s*=\\s*[\"`'](" + NLS_KEY_PAT + ")[\"`'];");
        }

        @Override
        public Pattern pattern() {
            return this.m_pattern;
        }

        @Override
        public String fileExtension() {
            return null;
        }

        @Override
        public Optional<FileRange> keyRangeIfAccept(MatchResult match, FileQueryInput fileQueryInput) {
            return AssignmentPattern.keyRangeIfInCode(match, fileQueryInput, 1);
        }
    }
}

