/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.properties;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.environment.NullProgress;
import org.eclipse.scout.sdk.core.s.nls.IEditableTranslationStore;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.TranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.properties.AbstractTranslationPropertiesFile;
import org.eclipse.scout.sdk.core.s.nls.properties.EditableTranslationFile;
import org.eclipse.scout.sdk.core.s.nls.properties.ITranslationPropertiesFile;
import org.eclipse.scout.sdk.core.s.nls.properties.PropertiesTextProviderService;
import org.eclipse.scout.sdk.core.util.Ensure;

public class PropertiesTranslationStore
implements IEditableTranslationStore {
    private final PropertiesTextProviderService m_svc;
    private final Map<String, TranslationEntry> m_translations;
    private final Map<Language, ITranslationPropertiesFile> m_files;
    private final Set<ITranslationPropertiesFile> m_newFiles;
    private boolean m_isEditable;
    private boolean m_isDirty;

    public PropertiesTranslationStore(PropertiesTextProviderService svc) {
        this.m_svc = (PropertiesTextProviderService)Ensure.notNull((Object)svc);
        this.m_translations = new HashMap<String, TranslationEntry>();
        this.m_files = new HashMap<Language, ITranslationPropertiesFile>();
        this.m_newFiles = new HashSet<ITranslationPropertiesFile>();
    }

    public void load(Collection<ITranslationPropertiesFile> translationFiles, IProgress progress) {
        Ensure.notNull(translationFiles);
        int ticksByFile = 100;
        progress.init(translationFiles.size() * ticksByFile, "Load translation files for service '{}'.", this.service().type().name());
        boolean isEditable = !translationFiles.isEmpty();
        this.m_translations.clear();
        this.translationFiles().clear();
        for (ITranslationPropertiesFile f : translationFiles) {
            f.load(progress.newChild(ticksByFile));
            this.loadFileContent(f);
            this.translationFiles().put(f.language(), f);
            if (f.isEditable()) continue;
            isEditable = false;
        }
        this.setDirty(false);
        this.m_isEditable = isEditable;
    }

    protected void loadFileContent(ITranslationPropertiesFile f) {
        f.allEntries().forEach((key, value) -> this.m_translations.computeIfAbsent((String)key, k -> new TranslationEntry((String)k, (ITranslationStore)this)).putText(f.language(), (String)value));
    }

    @Override
    public ITranslationEntry changeKey(String oldKey, String newKey) {
        this.throwIfReadOnly();
        TranslationEntry removed = (TranslationEntry)this.removeTranslation(oldKey);
        if (removed == null) {
            SdkLog.warning((CharSequence)"Cannot update key '{}' to '{}' because it could not be found.", (Object[])new Object[]{oldKey, newKey});
            return null;
        }
        this.setDirty(true);
        removed.setKey(newKey);
        this.addTranslationEntry(removed);
        return removed;
    }

    @Override
    public ITranslationEntry setTranslation(ITranslation newEntry) {
        this.throwIfReadOnly();
        this.ensureAllLanguagesExist(newEntry);
        this.setDirty(true);
        TranslationEntry entryToModify = this.m_translations.get(newEntry.key());
        if (entryToModify == null) {
            return this.addNewTranslation(newEntry);
        }
        return this.updateTranslation(entryToModify, newEntry);
    }

    protected void ensureAllLanguagesExist(ITranslation translation) {
        translation.languages().filter(lang -> this.languages().noneMatch(existing -> existing.equals(lang))).forEach(this::addNewLanguage);
    }

    protected ITranslationEntry addNewTranslation(ITranslation newTranslation) {
        TranslationEntry newEntry = new TranslationEntry(newTranslation, (ITranslationStore)this);
        this.setDirty(true);
        this.addTranslationEntry(newEntry);
        return newEntry;
    }

    protected void addTranslationEntry(TranslationEntry entryToAdd) {
        this.m_translations.put(entryToAdd.key(), entryToAdd);
        entryToAdd.texts().forEach((key, value) -> this.updateTextInFile((Language)key, entryToAdd.key(), (String)value));
    }

    protected ITranslationEntry updateTranslation(ITranslation existingTranslation, ITranslation newTranslation) {
        String key = newTranslation.key();
        existingTranslation.languages().forEach(l -> this.translationFiles().get(l).removeTranslation(key));
        TranslationEntry newEntry = new TranslationEntry(newTranslation, (ITranslationStore)this);
        this.addTranslationEntry(newEntry);
        for (Map.Entry<Language, String> newTranslations : newEntry.texts().entrySet()) {
            this.translationFiles().get(newTranslations.getKey()).setTranslation(key, newTranslations.getValue());
        }
        return newEntry;
    }

    @Override
    public ITranslationEntry removeTranslation(String key) {
        this.throwIfReadOnly();
        this.setDirty(true);
        this.translationFiles().values().forEach(f -> f.removeTranslation(key));
        return this.m_translations.remove(key);
    }

    protected void updateTextInFile(Language l, String key, String text) {
        ITranslationPropertiesFile file = this.translationFiles().get(l);
        if (file == null) {
            SdkLog.warning((CharSequence)"Cannot add text '{}' for key '{}' and language '{}' because this language does not exist in store {}.", (Object[])new Object[]{text, key, l, this});
            return;
        }
        file.setTranslation(key, text);
    }

    @Override
    public void addNewLanguage(Language language) {
        this.throwIfReadOnly();
        Ensure.notNull((Object)language);
        Path directory = this.translationFiles().values().stream().filter(f -> f instanceof EditableTranslationFile).map(f -> (EditableTranslationFile)f).findAny().orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot create new language because the store '{}' is not editable.", (Object[])new Object[]{this})).path().getParent();
        String fileName = AbstractTranslationPropertiesFile.getPropertiesFileName(this.service().filePrefix(), language);
        EditableTranslationFile newFile = new EditableTranslationFile(directory.resolve(fileName), language);
        newFile.load(new NullProgress());
        this.setDirty(true);
        this.translationFiles().put(language, newFile);
        this.m_newFiles.add(newFile);
    }

    @Override
    public void flush(IEnvironment env, IProgress progress) {
        if (!this.isDirty()) {
            return;
        }
        for (ITranslationPropertiesFile f : this.translationFiles().values()) {
            f.flush(env, progress);
        }
        this.m_newFiles.clear();
        this.setDirty(false);
    }

    protected void throwIfReadOnly() {
        if (!this.isEditable()) {
            throw Ensure.newFail((CharSequence)"Translation store {} is read-only.", (Object[])new Object[]{this});
        }
    }

    protected void setDirty(boolean dirty) {
        this.m_isDirty = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.m_isDirty;
    }

    @Override
    public boolean isEditable() {
        return this.m_isEditable;
    }

    @Override
    public boolean containsKey(String key) {
        return this.m_translations.containsKey(key);
    }

    @Override
    public boolean containsLanguage(Language language) {
        return this.m_files.containsKey(language);
    }

    @Override
    public Stream<String> keys() {
        return this.m_translations.keySet().stream();
    }

    @Override
    public long size() {
        return this.m_translations.size();
    }

    @Override
    public Optional<ITranslationEntry> get(String key) {
        return Optional.ofNullable((ITranslationEntry)this.m_translations.get(key));
    }

    @Override
    public Optional<String> get(String key, Language language) {
        return this.get(key).flatMap(t -> t.text(language));
    }

    @Override
    public Optional<Map<String, String>> get(Language language) {
        return Optional.ofNullable(this.translationFiles().get(language)).map(ITranslationPropertiesFile::allEntries);
    }

    @Override
    public Stream<? extends ITranslationEntry> entries() {
        return this.m_translations.values().stream();
    }

    @Override
    public Stream<Language> languages() {
        return this.translationFiles().keySet().stream();
    }

    @Override
    public PropertiesTextProviderService service() {
        return this.m_svc;
    }

    @Override
    public void reload(IProgress progress) {
        this.translationFiles().values().removeAll(this.m_newFiles);
        this.m_newFiles.clear();
        this.load(new ArrayList<ITranslationPropertiesFile>(this.translationFiles().values()), progress);
    }

    protected Map<Language, ITranslationPropertiesFile> translationFiles() {
        return this.m_files;
    }

    public Map<Language, ITranslationPropertiesFile> files() {
        return Collections.unmodifiableMap(this.m_files);
    }

    public int hashCode() {
        return this.service().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ITranslationStore other = (ITranslationStore)obj;
        return this.service().equals(other.service());
    }

    public String toString() {
        return PropertiesTranslationStore.class.getSimpleName() + " [" + this.service().type().name() + "]";
    }
}

