/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.properties;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.ISdkConstants;
import org.eclipse.scout.sdk.core.s.apidef.IScoutAbstractApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.nls.TextProviderService;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.JavaTypes;

public class PropertiesTextProviderService
extends TextProviderService {
    protected static final Pattern REGEX_RESOURCE_BUNDLE_GETTER = Pattern.compile("return\\s*\"([^\"]*)\"\\s*;", 32);
    public static final char FOLDER_SEGMENT_DELIMITER = '/';
    private final String m_folder;
    private final String m_filePrefix;

    protected PropertiesTextProviderService(IType txtSvc, String folder, String filePrefix) {
        super(txtSvc);
        this.m_folder = (String)Ensure.notNull((Object)folder);
        this.m_filePrefix = (String)Ensure.notNull((Object)filePrefix);
    }

    public static Optional<PropertiesTextProviderService> create(IType txtSvc) {
        return ((IType)Ensure.notNull((Object)txtSvc)).javaEnvironment().api(IScoutApi.class).map(IScoutAbstractApi::AbstractDynamicNlsTextProviderService).map(IScoutAbstractApi.AbstractDynamicNlsTextProviderService::getDynamicNlsBaseNameMethodName).flatMap(getDynamicNlsBaseName -> PropertiesTextProviderService.create(txtSvc, getDynamicNlsBaseName));
    }

    protected static Optional<PropertiesTextProviderService> create(IType txtSvc, CharSequence getDynamicNlsBaseName) {
        return txtSvc.methods().withMethodIdentifier(JavaTypes.createMethodIdentifier((CharSequence)getDynamicNlsBaseName, null)).withSuperClasses(true).first().flatMap(IMethod::sourceOfBody).map(ISourceRange::asCharSequence).map(CoreUtils::removeComments).map(REGEX_RESOURCE_BUNDLE_GETTER::matcher).filter(Matcher::find).map(m -> m.group(1)).map(ISdkConstants.REGEX_DOT::split).flatMap(segments -> PropertiesTextProviderService.fromSegments(segments, txtSvc));
    }

    protected static Optional<PropertiesTextProviderService> fromSegments(String[] segments, IType txtSvc) {
        if (segments.length < 1) {
            return Optional.empty();
        }
        String filePrefix = segments[segments.length - 1];
        String folderName = "";
        if (segments.length > 1) {
            folderName = Arrays.stream(segments, 0, segments.length - 1).collect(Collectors.joining(String.valueOf('/')));
        }
        return Optional.of(new PropertiesTextProviderService(txtSvc, folderName, filePrefix));
    }

    public String folder() {
        return this.m_folder;
    }

    public String filePrefix() {
        return this.m_filePrefix;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.m_folder, this.m_filePrefix);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PropertiesTextProviderService that = (PropertiesTextProviderService)o;
        return this.m_folder.equals(that.m_folder) && this.m_filePrefix.equals(that.m_filePrefix);
    }

    @Override
    public String toString() {
        return super.toString() + " for " + this.m_filePrefix + "*.properties files in " + this.m_folder;
    }
}

