/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.generator.properties.PropertiesGenerator;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.TranslationValidator;
import org.eclipse.scout.sdk.core.s.nls.properties.ITranslationPropertiesFile;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;

public abstract class AbstractTranslationPropertiesFile
implements ITranslationPropertiesFile {
    public static final String FILE_SUFFIX = ".properties";
    public static final Pattern FILE_PATTERN = Pattern.compile("^[^_]+(?:_(([^_]+)(?:_([^_]+))?(?:_(.+))?))?\\.properties$");
    private final Language m_language;
    private final Supplier<InputStream> m_inputSupplier;
    private PropertiesGenerator m_fileContent;

    protected AbstractTranslationPropertiesFile(Language language, Supplier<InputStream> contentSupplier) {
        this.m_language = (Language)Ensure.notNull((Object)language);
        this.m_inputSupplier = (Supplier)Ensure.notNull(contentSupplier);
    }

    private Map<String, String> entries() {
        if (this.m_fileContent == null) {
            throw Ensure.newFail((CharSequence)"Properties file has not been loaded yet.", (Object[])new Object[0]);
        }
        return this.m_fileContent.properties();
    }

    @Override
    public final Language language() {
        return this.m_language;
    }

    @Override
    public Map<String, String> allEntries() {
        return Collections.unmodifiableMap(this.entries());
    }

    @Override
    public final Stream<String> allKeys() {
        return this.entries().keySet().stream();
    }

    @Override
    public final Optional<String> translation(String key) {
        return Optional.ofNullable(this.entries().get(key));
    }

    @Override
    public boolean load(IProgress progress) {
        PropertiesGenerator newContent = this.readEntries();
        if (Objects.equals(this.m_fileContent, newContent)) {
            return false;
        }
        this.m_fileContent = newContent;
        this.removeInvalidEntries(newContent.properties().entrySet());
        return true;
    }

    private void removeInvalidEntries(Iterable<Map.Entry<String, String>> entries) {
        Iterator<Map.Entry<String, String>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!TranslationValidator.isForbidden(TranslationValidator.validateKey(entry.getKey()))) continue;
            if (this.isEditable()) {
                SdkLog.warning((CharSequence)"Skipping entry '{}={}' found in '{}' because the key is invalid.", (Object[])new Object[]{entry.getKey(), entry.getValue(), this.source()});
            }
            iterator.remove();
        }
    }

    private PropertiesGenerator readEntries() {
        PropertiesGenerator propertiesGenerator;
        block8: {
            InputStream in = (InputStream)Ensure.notNull((Object)this.m_inputSupplier.get());
            try {
                propertiesGenerator = PropertiesGenerator.create((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SdkException((CharSequence)"Error reading properties file for language '{}'.", new Object[]{this.language(), e});
                }
            }
            in.close();
        }
        return propertiesGenerator;
    }

    @Override
    public boolean setTranslation(String key, String text) {
        this.throwIfReadOnly();
        Ensure.notBlank((CharSequence)key);
        if (text == null) {
            return this.removeTranslation(key);
        }
        String oldTranslation = this.entries().put(key, text);
        return !text.equals(oldTranslation);
    }

    @Override
    public boolean removeTranslation(String key) {
        this.throwIfReadOnly();
        return this.entries().remove(Ensure.notBlank((CharSequence)key)) != null;
    }

    @Override
    public void flush(IEnvironment env, IProgress progress) {
        this.throwIfReadOnly();
        this.writeEntries(this.m_fileContent, env, progress);
    }

    protected void throwIfReadOnly() {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("Cannot modify a ready-only resource.");
        }
    }

    protected abstract void writeEntries(PropertiesGenerator var1, IEnvironment var2, IProgress var3);

    protected abstract Object source();

    public static Optional<Language> parseLanguageFromFileName(String fileName, String prefix) {
        if (Strings.isBlank((CharSequence)fileName)) {
            return Optional.empty();
        }
        if (Strings.hasText((CharSequence)prefix) && !fileName.startsWith(prefix)) {
            return Optional.empty();
        }
        Matcher matcher = FILE_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String languagePart = matcher.group(1);
        if (Strings.isBlank((CharSequence)languagePart)) {
            return Optional.of(Language.LANGUAGE_DEFAULT);
        }
        return Language.parse(languagePart);
    }

    public static String getPropertiesFileName(String prefix, Language language) {
        return prefix + "_" + language.locale() + FILE_SUFFIX;
    }
}

