/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls.manager;

import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.manager.IStackedTranslation;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public final class TranslationManagerEvent {
    public static final int TYPE_NEW_TRANSLATION = 2;
    public static final int TYPE_REMOVE_TRANSLATION = 4;
    public static final int TYPE_UPDATE_TRANSLATION = 8;
    public static final int TYPE_KEY_CHANGED = 16;
    public static final int TYPE_NEW_LANGUAGE = 32;
    public static final int TYPE_FLUSH = 64;
    public static final int TYPE_RELOAD = 128;
    private final TranslationManager m_manager;
    private final int m_type;
    private final IStackedTranslation m_entry;
    private final String m_key;
    private final Language m_language;

    private TranslationManagerEvent(TranslationManager source, int type, IStackedTranslation entry, String key) {
        this.m_type = type;
        this.m_manager = source;
        this.m_entry = entry;
        this.m_key = key;
        this.m_language = null;
    }

    private TranslationManagerEvent(TranslationManager source, int type, Language lang) {
        this.m_type = type;
        this.m_manager = source;
        this.m_language = lang;
        this.m_entry = null;
        this.m_key = null;
    }

    public static TranslationManagerEvent createChangeKeyEvent(TranslationManager source, IStackedTranslation newEntry, String oldKey) {
        return new TranslationManagerEvent(source, 16, newEntry, oldKey);
    }

    public static TranslationManagerEvent createRemoveTranslationEvent(TranslationManager source, IStackedTranslation removedEntry) {
        return new TranslationManagerEvent(source, 4, removedEntry, removedEntry.key());
    }

    public static TranslationManagerEvent createUpdateTranslationEvent(TranslationManager source, IStackedTranslation updatedEntry) {
        return new TranslationManagerEvent(source, 8, updatedEntry, updatedEntry.key());
    }

    public static TranslationManagerEvent createAddTranslationEvent(TranslationManager source, IStackedTranslation newEntry) {
        return new TranslationManagerEvent(source, 2, newEntry, newEntry.key());
    }

    public static TranslationManagerEvent createAddLanguageEvent(TranslationManager source, Language newLanguage) {
        return new TranslationManagerEvent(source, 32, newLanguage);
    }

    public static TranslationManagerEvent createFlushEvent(TranslationManager source) {
        return new TranslationManagerEvent(source, 64, null);
    }

    public static TranslationManagerEvent createReloadEvent(TranslationManager source) {
        return new TranslationManagerEvent(source, 128, null);
    }

    public TranslationManager source() {
        return this.m_manager;
    }

    public int type() {
        return this.m_type;
    }

    public Optional<IStackedTranslation> translation() {
        return Optional.ofNullable(this.m_entry);
    }

    public Optional<String> key() {
        return Optional.ofNullable(this.m_key);
    }

    public Optional<Language> language() {
        return Optional.ofNullable(this.m_language);
    }

    static String typeName(int type) {
        return switch (type) {
            case 2 -> "NewTranslation";
            case 16 -> "KeyChange";
            case 4 -> "RemoveTranslation";
            case 32 -> "NewLanguage";
            case 128 -> "Reload";
            case 8 -> "UpdateTranslation";
            case 64 -> "Flush";
            default -> throw Ensure.newFail((CharSequence)"Unknown event type '{}'.", (Object[])new Object[]{type});
        };
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", TranslationManagerEvent.class.getSimpleName() + " [", "]").add("type=" + TranslationManagerEvent.typeName(this.m_type));
        if (Strings.hasText((CharSequence)this.m_key)) {
            joiner.add("key=" + this.m_key);
        }
        if (this.m_type == 16 && this.m_entry != null) {
            joiner.add("newKey=" + this.m_entry.key());
        }
        if (this.m_language != null) {
            joiner.add("language=" + this.m_language);
        }
        return joiner.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.m_entry == null ? 0 : this.m_entry.hashCode());
        result = prime * result + (this.m_key == null ? 0 : this.m_key.hashCode());
        result = prime * result + (this.m_language == null ? 0 : this.m_language.hashCode());
        result = prime * result + this.m_manager.hashCode();
        result = prime * result + this.m_type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TranslationManagerEvent other = (TranslationManagerEvent)obj;
        return this.m_type == other.m_type && Objects.equals(this.m_key, other.m_key) && Objects.equals(this.m_entry, other.m_entry) && Objects.equals(this.m_language, other.m_language) && Objects.equals(this.m_manager, other.m_manager);
    }
}

