/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.FilteredTranslationStore;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Translations;
import org.eclipse.scout.sdk.core.s.nls.UiTextContributor;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.StreamUtils;
import org.eclipse.scout.sdk.core.util.Strings;

public final class WebModuleTranslationStores {
    private WebModuleTranslationStores() {
    }

    static Stream<ITranslationStore> allForNodeModule(Path modulePath, IEnvironment env, IProgress progress) {
        progress.init(20, "Resolve translation stores visible in npm and UiTextContributor dependencies of module '{}'.", modulePath);
        return Stream.of(WebModuleTranslationStores.resolveStoresReferencedInUiTextContributors(modulePath, env, progress.newChild(10)), WebModuleTranslationStores.resolveStoresFromScoutJsBackend(modulePath, env, progress.newChild(10))).flatMap(Function.identity());
    }

    static Stream<ITranslationStore> resolveStoresReferencedInUiTextContributors(Path modulePath, IEnvironment env, IProgress progress) {
        Stream<Stream> textContributorTypes = Stream.of(WebModuleTranslationStores.resolveTextContributorsReferencedInPom(modulePath, env, progress), WebModuleTranslationStores.resolveTextContributorsReferencedInPackageJson(modulePath, env));
        Map<Path, List<UiTextContributor>> textContributorsByModule = textContributorTypes.flatMap(Function.identity()).filter(StreamUtils.firstBy(IType::name)).map(type -> WebModuleTranslationStores.createUiTextContributor(type, progress)).collect(Collectors.groupingBy(c -> WebModuleTranslationStores.moduleOfContributor(c, env)));
        return textContributorsByModule.entrySet().stream().flatMap(entry -> WebModuleTranslationStores.resolveStoresProvidingTranslationsOfContributor((Path)entry.getKey(), (Collection)entry.getValue(), env, progress));
    }

    static Stream<IType> resolveTextContributorsReferencedInPom(Path modulePath, IEnvironment env, IProgress progress) {
        return Translations.storeSuppliers().stream().flatMap(supplier -> supplier.visibleTextContributorsForJavaModule(modulePath, env, progress));
    }

    static Stream<IType> resolveTextContributorsReferencedInPackageJson(Path modulePath, IEnvironment env) {
        return WebModuleTranslationStores.loadPackageJson(modulePath).map(WebModuleTranslationStores::getTextContributorsReferencedInPackageJson).orElseGet(Stream::empty).flatMap(env::findType);
    }

    static Stream<ITranslationStore> resolveStoresFromScoutJsBackend(Path modulePath, IEnvironment env, IProgress progress) {
        Stream<Path> includedModulesByNamingConventions = Stream.of(new AbstractMap.SimpleImmutableEntry<String, String>(".ui", ".app"), new AbstractMap.SimpleImmutableEntry<String, String>(".ui.html", ".app"), new AbstractMap.SimpleImmutableEntry<String, String>(".ui.html", ".ui.html.app")).map(nameMapping -> WebModuleTranslationStores.findIncludedModuleByNamingConvention(modulePath, (String)nameMapping.getKey(), (String)nameMapping.getValue())).filter(Objects::nonNull);
        return Stream.concat(includedModulesByNamingConventions, Stream.of(modulePath)).flatMap(targetModulePath -> Translations.storesForModule(targetModulePath, env, progress, Translations.DependencyScope.JAVA));
    }

    static Path findIncludedModuleByNamingConvention(Path sourceModulePath, String sourceModuleSuffix, String targetModuleSuffix) {
        Path fileName = sourceModulePath.getFileName();
        if (fileName == null) {
            return null;
        }
        String sourceModuleFolderName = fileName.toString().toLowerCase(Locale.US);
        if (!sourceModuleFolderName.endsWith(sourceModuleSuffix)) {
            return null;
        }
        String targetModuleName = sourceModuleFolderName.substring(0, sourceModuleFolderName.length() - sourceModuleSuffix.length()) + targetModuleSuffix;
        Path parent = sourceModulePath.getParent();
        if (parent == null) {
            return null;
        }
        Path targetModulePath = parent.resolve(targetModuleName);
        if (Files.isReadable(targetModulePath) && Files.isDirectory(targetModulePath, new LinkOption[0])) {
            return targetModulePath;
        }
        return null;
    }

    static Path moduleOfContributor(UiTextContributor contributor, IEnvironment env) {
        return env.rootOfJavaEnvironment(contributor.type().javaEnvironment());
    }

    static Stream<ITranslationStore> resolveStoresProvidingTranslationsOfContributor(Path modulePath, Collection<UiTextContributor> contributorsInModule, IEnvironment env, IProgress progress) {
        Set keysOfContributor = contributorsInModule.stream().flatMap(UiTextContributor::keys).collect(Collectors.toSet());
        if (keysOfContributor.isEmpty()) {
            return Stream.empty();
        }
        return Translations.storesForModule(modulePath, env, progress, Translations.DependencyScope.JAVA).map(store -> new FilteredTranslationStore((ITranslationStore)store, keysOfContributor)).filter(store -> store.entries().findAny().isPresent()).peek(store -> SdkLog.debug((CharSequence)"Translation store '{}' found in module '{}' (referenced from accessible UiTextContributor).", (Object[])new Object[]{store, modulePath}));
    }

    static Stream<String> getTextContributorsReferencedInPackageJson(CharSequence packageJsonContent) {
        return Translations.uiTextContributorMappings().entrySet().stream().filter(entry -> Strings.indexOf((CharSequence)((CharSequence)entry.getKey()), (CharSequence)packageJsonContent) >= 0).flatMap(entry -> ((Set)entry.getValue()).stream()).distinct();
    }

    static Optional<CharSequence> loadPackageJson(Path modulePath) {
        Path packageJsonFile = modulePath.resolve("package.json");
        if (!Files.isRegularFile(packageJsonFile, new LinkOption[0]) || !Files.isReadable(packageJsonFile)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Strings.fromFile((Path)packageJsonFile, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new SdkException((CharSequence)"Cannot read package.json file to analyze dependency structure.", new Object[]{e});
        }
    }

    static UiTextContributor createUiTextContributor(IType contributorType, IProgress progress) {
        UiTextContributor contributor = new UiTextContributor(contributorType);
        try {
            SdkLog.debug((CharSequence)"loading ui text contributor '{}'.", (Object[])new Object[]{contributorType.name()});
            contributor.load(progress);
        }
        catch (SdkException e) {
            SdkLog.warning((CharSequence)"Cannot calculate available text keys for ui text contributor '{}'.", (Object[])new Object[]{contributorType.name(), e});
        }
        return contributor;
    }
}

