/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutChartApi;
import org.eclipse.scout.sdk.core.s.apidef.ScoutApi;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.FilteredTranslationStore;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStoreSupplier;
import org.eclipse.scout.sdk.core.s.nls.WebModuleTranslationStores;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public final class Translations {
    private static final DependencyScope[] ALL_SCOPES = (DependencyScope[])Arrays.stream(DependencyScope.values()).filter(scope -> scope != DependencyScope.ALL).toArray(DependencyScope[]::new);
    private static final Set<ITranslationStoreSupplier> SUPPLIERS = new HashSet<ITranslationStoreSupplier>();
    private static final Map<String, Set<String>> UI_TEXT_CONTRIBUTORS = new HashMap<String, Set<String>>();

    private Translations() {
    }

    private static Map<String, ITypeNameSupplier> getPredefinedTextContributorMappings(IScoutApi api) {
        HashMap<String, ITypeNameSupplier> mappings = new HashMap<String, ITypeNameSupplier>(2);
        mappings.put("@eclipse-scout/core", api.UiTextContributor());
        api.api(IScoutChartApi.class).ifPresent(chartApi -> mappings.put("@eclipse-scout/chart", chartApi.ChartUiTextContributor()));
        return mappings;
    }

    public static synchronized boolean registerUiTextContributor(String ownerNodeModuleName, String contributorFqn) {
        return !UI_TEXT_CONTRIBUTORS.computeIfAbsent(ownerNodeModuleName, k -> new HashSet()).add((String)Ensure.notBlank((CharSequence)contributorFqn));
    }

    public static synchronized boolean removeUiTextContributor(String ownerNodeModuleName) {
        return UI_TEXT_CONTRIBUTORS.remove(ownerNodeModuleName) != null;
    }

    public static synchronized Map<String, Set<String>> uiTextContributorMappings() {
        HashMap<String, Set<String>> copy = new HashMap<String, Set<String>>(UI_TEXT_CONTRIBUTORS.size());
        for (Map.Entry<String, Set<String>> entry : UI_TEXT_CONTRIBUTORS.entrySet()) {
            copy.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return copy;
    }

    public static synchronized boolean registerStoreSupplier(ITranslationStoreSupplier supplier) {
        return SUPPLIERS.add(supplier);
    }

    public static synchronized boolean removeStoreSupplier(ITranslationStoreSupplier supplier) {
        return SUPPLIERS.remove(supplier);
    }

    public static synchronized List<ITranslationStoreSupplier> storeSuppliers() {
        return new ArrayList<ITranslationStoreSupplier>(SUPPLIERS);
    }

    public static Optional<TranslationManager> createManager(Path modulePath, IEnvironment env, IProgress progress, DependencyScope scope) {
        Stream<ITranslationStore> stores = Translations.storesForModule(modulePath, env, progress, scope);
        return TranslationManager.create(modulePath, stores, scope);
    }

    public static Optional<TranslationManager> createManager(Path modulePath, IEnvironment env, IProgress progress, DependencyScope ... scopes) {
        Stream<ITranslationStore> stores = Translations.storesForModule(modulePath, env, progress, scopes);
        return TranslationManager.create(modulePath, stores, scopes);
    }

    public static Optional<TranslationManager> createManager(Stream<ITranslationStore> stores) {
        return TranslationManager.create(null, stores, new DependencyScope[0]);
    }

    public static Stream<Set<ITranslationStore>> storesHavingImplicitOverrides(Stream<ITranslationStore> allStores) {
        return allStores.distinct().collect(Collectors.groupingBy(s -> s.service().order(), Collectors.toList())).values().stream().filter(group -> group.size() > 1).map(Translations::storesWithCommonKeys).filter(group -> !group.isEmpty());
    }

    static Set<ITranslationStore> storesWithCommonKeys(List<ITranslationStore> group) {
        HashSet<ITranslationStore> result = new HashSet<ITranslationStore>(group.size());
        for (int i = 0; i < group.size(); ++i) {
            ITranslationStore storeToCheck = group.get(i);
            for (int j = i + 1; j < group.size(); ++j) {
                ITranslationStore storeToCompare = group.get(j);
                if (!storeToCheck.keys().anyMatch(storeToCompare::containsKey)) continue;
                result.add(storeToCheck);
                result.add(storeToCompare);
            }
        }
        return result;
    }

    public static Stream<ITranslationStore> storesForModule(Path modulePath, IEnvironment env, IProgress progress, DependencyScope ... scopes) {
        return Translations.combineSameStores(Translations.computeStoresForModule(modulePath, env, progress, scopes));
    }

    public static Stream<ITranslationStore> storesForModule(Path modulePath, IEnvironment env, IProgress progress, DependencyScope scope) {
        return Translations.combineSameStores(Translations.computeStoresForModule(modulePath, env, progress, scope));
    }

    static Stream<ITranslationStore> computeStoresForModule(Path modulePath, IEnvironment env, IProgress progress, DependencyScope ... scopes) {
        if (scopes == null || scopes.length < 1) {
            return Translations.computeStoresForModule(modulePath, env, progress, DependencyScope.ALL);
        }
        int ticksByScope = 10000;
        progress.init(ticksByScope * scopes.length, "Resolve translation stores for module '{}'.", modulePath);
        return Arrays.stream(scopes).filter(Objects::nonNull).flatMap(scope -> Translations.computeStoresForModule(modulePath, env, progress.newChild(ticksByScope), scope));
    }

    static Stream<ITranslationStore> computeStoresForModule(Path modulePath, IEnvironment env, IProgress progress, DependencyScope scope) {
        if (scope == null || scope == DependencyScope.ALL) {
            return Translations.computeStoresForModule(modulePath, env, progress, ALL_SCOPES);
        }
        return switch (scope) {
            case DependencyScope.JAVA -> Translations.forJavaModule(modulePath, env, progress);
            case DependencyScope.NODE -> Translations.forNodeModule(modulePath, env, progress);
            default -> throw Ensure.newFail((CharSequence)"Scope not implemented: {}", (Object[])new Object[]{scope});
        };
    }

    static Stream<ITranslationStore> forJavaModule(Path modulePath, IEnvironment env, IProgress progress) {
        int ticksBySupplier = 1000;
        List<ITranslationStoreSupplier> suppliers = Translations.storeSuppliers();
        progress.init(suppliers.size() * ticksBySupplier, "Search translation stores for Java module at '{}'.", modulePath);
        return suppliers.stream().flatMap(supplier -> supplier.visibleStoresForJavaModule(modulePath, env, progress.newChild(ticksBySupplier))).filter(Translations::isContentAvailable);
    }

    static Stream<ITranslationStore> forNodeModule(Path modulePath, IEnvironment env, IProgress progress) {
        SdkLog.debug((CharSequence)"Search translation stores for Node module at '{}'.", (Object[])new Object[]{modulePath});
        return WebModuleTranslationStores.allForNodeModule(modulePath, env, progress).filter(Translations::isContentAvailable);
    }

    static Stream<ITranslationStore> combineSameStores(Stream<ITranslationStore> stores) {
        return stores.collect(Collectors.toMap(s -> s.service().type().name(), Function.identity(), Translations::mergeStores)).values().stream();
    }

    public static Optional<? extends ITranslationStore> createStore(IType textService, IProgress progress) {
        Ensure.notNull((Object)textService);
        Ensure.notNull((Object)progress);
        int ticksBySupplier = 1000;
        List<ITranslationStoreSupplier> suppliers = Translations.storeSuppliers();
        progress.init(ticksBySupplier * suppliers.size(), "Creating translation store for service '{}'.", textService);
        return suppliers.stream().map(supplier -> supplier.createStoreForService(textService, progress.newChild(ticksBySupplier))).flatMap(Optional::stream).findFirst();
    }

    static ITranslationStore mergeStores(ITranslationStore a, ITranslationStore b) {
        boolean aIsFiltered = a instanceof FilteredTranslationStore;
        boolean bIsFiltered = b instanceof FilteredTranslationStore;
        if (!aIsFiltered && !bIsFiltered) {
            return a.size() >= b.size() ? a : b;
        }
        if (aIsFiltered && !bIsFiltered) {
            return b;
        }
        if (!aIsFiltered) {
            return a;
        }
        FilteredTranslationStore filteredA = (FilteredTranslationStore)a;
        FilteredTranslationStore filteredB = (FilteredTranslationStore)b;
        Set<String> filterA = filteredA.keysFilter();
        Set<String> filterB = filteredB.keysFilter();
        HashSet<String> newFilter = new HashSet<String>(filterA.size() + filterB.size());
        newFilter.addAll(filterA);
        newFilter.addAll(filterB);
        return new FilteredTranslationStore(filteredA.nestedStore(), newFilter);
    }

    static boolean isContentAvailable(ITranslationStore s) {
        if (s == null) {
            return false;
        }
        if (s.languages().findAny().isEmpty()) {
            SdkLog.warning((CharSequence)"{} contains no languages! Please check the configuration.", (Object[])new Object[]{s});
            return false;
        }
        return true;
    }

    static {
        ScoutApi.allKnown().map(Translations::getPredefinedTextContributorMappings).map(Map::entrySet).flatMap(Collection::stream).distinct().forEach(mapping -> Translations.registerUiTextContributor((String)mapping.getKey(), ((ITypeNameSupplier)mapping.getValue()).fqn()));
    }

    public static enum DependencyScope {
        JAVA,
        NODE,
        ALL;

        private static final Map<String, DependencyScope> FILE_TYPE_MAPPING;

        public static Optional<DependencyScope> forFileExtension(CharSequence name) {
            return FILE_TYPE_MAPPING.entrySet().stream().filter(entry -> DependencyScope.isOrHasExtension(name, (String)entry.getKey())).findAny().map(Map.Entry::getValue);
        }

        private static boolean isOrHasExtension(CharSequence name, String extension) {
            return Strings.equals((CharSequence)name, (CharSequence)extension, (boolean)false) || Strings.endsWith((CharSequence)name, (CharSequence)("." + extension), (boolean)false);
        }

        public static Map<String, DependencyScope> supportedFileExtensions() {
            return Collections.unmodifiableMap(FILE_TYPE_MAPPING);
        }

        static {
            FILE_TYPE_MAPPING = new HashMap<String, DependencyScope>(3);
            FILE_TYPE_MAPPING.put("java", JAVA);
            FILE_TYPE_MAPPING.put("js", NODE);
            FILE_TYPE_MAPPING.put("ts", NODE);
            FILE_TYPE_MAPPING.put("html", JAVA);
        }
    }
}

