/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.lookupcall;

import java.util.Optional;
import org.eclipse.scout.sdk.core.generator.field.FieldGenerator;
import org.eclipse.scout.sdk.core.generator.type.PrimaryTypeGenerator;
import org.eclipse.scout.sdk.core.s.generator.annotation.ScoutAnnotationGenerator;
import org.eclipse.scout.sdk.core.s.generator.method.ScoutMethodGenerator;
import org.eclipse.scout.sdk.core.util.Strings;

public class LookupCallGenerator<TYPE extends LookupCallGenerator<TYPE>>
extends PrimaryTypeGenerator<TYPE> {
    private String m_superType;
    private String m_keyType;
    private String m_lookupServiceInterface;
    private String m_classIdValue;

    protected void setup() {
        if (this.superType().isPresent() && this.keyType().isPresent()) {
            StringBuilder superTypeBuilder = new StringBuilder(this.superType().orElseThrow());
            superTypeBuilder.append('<');
            superTypeBuilder.append(this.keyType().orElseThrow());
            superTypeBuilder.append('>');
            this.withSuperClass(superTypeBuilder.toString());
        }
        ((LookupCallGenerator)this.withAnnotation(this.classIdValue().map(ScoutAnnotationGenerator::createClassId).orElse(null))).withField(FieldGenerator.createSerialVersionUid(), new Object[0]);
        if (this.lookupServiceInterface().isPresent() && this.keyType().isPresent()) {
            this.withMethod(ScoutMethodGenerator.createGetConfiguredService(this.lookupServiceInterface().orElseThrow(), this.keyType().orElseThrow()), new Object[0]);
        }
    }

    public Optional<String> superType() {
        return Strings.notBlank((CharSequence)this.m_superType);
    }

    public TYPE withSuperType(String superType) {
        this.m_superType = superType;
        return (TYPE)((Object)((LookupCallGenerator)this.thisInstance()));
    }

    public Optional<String> keyType() {
        return Strings.notBlank((CharSequence)this.m_keyType);
    }

    public TYPE withKeyType(String keyType) {
        this.m_keyType = keyType;
        return (TYPE)((Object)((LookupCallGenerator)this.thisInstance()));
    }

    public Optional<String> lookupServiceInterface() {
        return Strings.notBlank((CharSequence)this.m_lookupServiceInterface);
    }

    public TYPE withLookupServiceInterface(String lookupServiceIfc) {
        this.m_lookupServiceInterface = lookupServiceIfc;
        return (TYPE)((Object)((LookupCallGenerator)this.thisInstance()));
    }

    public Optional<String> classIdValue() {
        return Strings.notBlank((CharSequence)this.m_classIdValue);
    }

    public TYPE withClassIdValue(String classIdValue) {
        this.m_classIdValue = classIdValue;
        return (TYPE)((Object)((LookupCallGenerator)this.thisInstance()));
    }
}

