/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.util.Locale;
import org.eclipse.scout.sdk.core.builder.java.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.generator.annotation.AnnotationGenerator;
import org.eclipse.scout.sdk.core.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.generator.method.MethodGenerator;
import org.eclipse.scout.sdk.core.generator.method.MethodOverrideGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.generator.type.PrimaryTypeGenerator;
import org.eclipse.scout.sdk.core.generator.type.TypeGenerator;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.s.apidef.IScoutAbstractApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.s.builder.java.body.IScoutMethodBodyBuilder;
import org.eclipse.scout.sdk.core.s.builder.java.body.ScoutMethodBodyBuilder;
import org.eclipse.scout.sdk.core.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.transformer.SimpleWorkingCopyTransformerBuilder;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class WebServiceClientGenerator<TYPE extends WebServiceClientGenerator<TYPE>>
extends PrimaryTypeGenerator<TYPE> {
    private String m_portType;
    private String m_service;

    protected void setup() {
        ((WebServiceClientGenerator)((WebServiceClientGenerator)((WebServiceClientGenerator)((WebServiceClientGenerator)((WebServiceClientGenerator)this.withSuperClassFrom(IScoutApi.class, this::buildSuperType)).withInterface(this.portType())).withType(this.createUrlPropertyType(), new Object[0])).withMethod(WebServiceClientGenerator.createExecInstallHandlers(), new Object[0])).withMethod(this.createGetConfiguredEndpointUrlProperty(), new Object[0])).withAllMethodsImplemented(new SimpleWorkingCopyTransformerBuilder().withMethodMapper(this::fillOverriddenMethods).build());
    }

    protected String buildSuperType(IScoutAbstractApi api) {
        StringBuilder superTypeFqnBuilder = new StringBuilder(api.AbstractWebServiceClient().fqn());
        superTypeFqnBuilder.append('<').append(this.service()).append(", ").append(this.portType()).append('>');
        return superTypeFqnBuilder.toString();
    }

    protected IMethodGenerator<?, ?> fillOverriddenMethods(IWorkingCopyTransformer.ITransformInput<IMethod, IMethodGenerator<?, ?>> input) {
        return ((IMethodGenerator)input.requestDefaultWorkingCopy()).withBody(b -> b.appendCallToSame((CharSequence)(((IScoutApi)b.context().requireApi(IScoutApi.class)).AbstractWebServiceClient().newInvocationContextMethodName() + "().getPort()")));
    }

    protected String getBaseName() {
        return Strings.removeSuffix((String)((String)this.elementName().orElseThrow(() -> Ensure.newFail((CharSequence)"WebService client has no name.", (Object[])new Object[0]))), (CharSequence)"WebServiceClient");
    }

    public String urlPropertyName() {
        return "jaxws." + this.getBaseName().toLowerCase(Locale.US) + ".url";
    }

    protected String getPropertyClassName() {
        return this.getBaseName() + "WebServiceUrlProperty";
    }

    protected ITypeGenerator<?> createUrlPropertyType() {
        return ((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)TypeGenerator.create().asPublic()).asStatic()).withElementName(this.getPropertyClassName())).withSuperClassFrom(IScoutApi.class, api -> api.AbstractStringConfigProperty().fqn()).withMethod((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().asPublic()).withReturnType(String.class.getName()).withElementNameFrom(IScoutApi.class, api -> api.IConfigProperty().getKeyMethodName())).withBody(b -> ((IMethodBodyBuilder)b.returnClause().stringLiteral((CharSequence)this.urlPropertyName())).semicolon()).withAnnotation(AnnotationGenerator.createOverride()), new Object[0]).withMethod((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().asPublic()).withReturnType(String.class.getName()).withElementNameFrom(IScoutApi.class, api -> api.IConfigProperty().descriptionMethodName())).withBody(b -> ((IMethodBodyBuilder)((IMethodBodyBuilder)b.returnClause().stringLiteral((CharSequence)"")).semicolon()).appendTodo((CharSequence)"documentation")).withAnnotation(AnnotationGenerator.createOverride()), new Object[0]);
    }

    protected IMethodGenerator<?, ?> createGetConfiguredEndpointUrlProperty() {
        return ((IMethodGenerator)MethodOverrideGenerator.createOverride().withElementNameFrom(IScoutApi.class, api -> api.AbstractWebServiceClient().getConfiguredEndpointUrlPropertyMethodName())).withBody(b -> b.returnClassLiteral(this.getPropertyClassName()));
    }

    protected static IMethodGenerator<?, ?> createExecInstallHandlers() {
        return ((IMethodGenerator)MethodOverrideGenerator.createOverride().withElementNameFrom(IScoutApi.class, api -> api.AbstractWebServiceClient().execInstallHandlersMethodName())).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)ScoutMethodBodyBuilder.create(b).appendParameterName(0)).dot()).append("add")).parenthesisOpen()).appendBeansGetFrom(IScoutApi.class, IScoutVariousApi::LogHandler).parenthesisClose()).semicolon()).nl()).appendParameterName(0)).dot()).append("add")).parenthesisOpen()).appendBeansGetFrom(IScoutApi.class, IScoutVariousApi::WsConsumerCorrelationIdHandler).parenthesisClose()).semicolon());
    }

    public String portType() {
        return this.m_portType;
    }

    public TYPE withPortType(String portType) {
        this.m_portType = (String)Ensure.notBlank((CharSequence)portType);
        return (TYPE)((Object)((WebServiceClientGenerator)this.thisInstance()));
    }

    public String service() {
        return this.m_service;
    }

    public TYPE withService(String service) {
        this.m_service = (String)Ensure.notBlank((CharSequence)service);
        return (TYPE)((Object)((WebServiceClientGenerator)this.thisInstance()));
    }
}

