/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.util.Strings;

public class JaxwsBindingGenerator
implements ISourceGenerator<ISourceBuilder<?>> {
    private String m_wsPackage;
    private URI m_wsdlLocation;
    private Iterable<JaxWsUtils.JaxWsBindingMapping> m_names = Collections.emptyList();

    public void generate(ISourceBuilder<?> builder) {
        URI wsdlLocation = this.wsdlLocation().orElseThrow();
        String wsPackage = this.wsPackage().orElseThrow();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>").nl();
        builder.append("<!-- binding to customize webservice artifacts (jaxws-namespace: ").append("http://java.sun.com/xml/ns/jaxws").append(" -->").nl();
        builder.append("<jaxws:bindings wsdlLocation=\"").append(wsdlLocation.toString()).append('\"').nl();
        builder.append("  xmlns:jaxws=\"").append("http://java.sun.com/xml/ns/jaxws").append('\"').nl();
        builder.append("  xmlns:jaxb=\"").append("http://java.sun.com/xml/ns/jaxb").append('\"').nl();
        builder.append("  xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"").nl();
        builder.append("  xmlns:xjc=\"http://java.sun.com/xml/ns/jaxb/xjc\"").nl();
        builder.append("  xmlns:javaee=\"http://java.sun.com/xml/ns/javaee\"").nl();
        builder.append("  xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">").nl();
        builder.append("  <jaxws:bindings node=\"wsdl:definitions\">").nl();
        builder.append("    <jaxws:package name=\"").append(wsPackage).append("\"/>").nl();
        builder.append("  </jaxws:bindings>").nl();
        for (JaxWsUtils.JaxWsBindingMapping mapping : this.names()) {
            String nodeAttr = mapping.isPortType() ? JaxWsUtils.getPortTypeXPath(mapping.getWsdlName()) : JaxWsUtils.getWebServiceXPath(mapping.getWsdlName());
            builder.append("  <jaxws:bindings node=\"").append(nodeAttr).append("\">").nl();
            builder.append("    <jaxws:class name=\"").append(mapping.getClassName()).append("\" />").nl();
            builder.append("  </jaxws:bindings>").nl();
        }
        builder.append("</jaxws:bindings>").nl();
    }

    public Optional<String> wsPackage() {
        return Strings.notBlank((CharSequence)this.m_wsPackage);
    }

    public JaxwsBindingGenerator withWsPackage(String wsPackage) {
        this.m_wsPackage = wsPackage;
        return this;
    }

    public Optional<URI> wsdlLocation() {
        return Optional.ofNullable(this.m_wsdlLocation);
    }

    public JaxwsBindingGenerator withWsdlLocation(URI wsdlLocation) {
        this.m_wsdlLocation = wsdlLocation;
        return this;
    }

    public Iterable<JaxWsUtils.JaxWsBindingMapping> names() {
        return this.m_names;
    }

    public JaxwsBindingGenerator withNames(Iterable<JaxWsUtils.JaxWsBindingMapping> names) {
        this.m_names = Objects.requireNonNullElse(names, Collections.emptyList());
        return this;
    }
}

