/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.generator.annotation;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.builder.java.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.annotation.AnnotationGenerator;
import org.eclipse.scout.sdk.core.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotation;
import org.eclipse.scout.sdk.core.s.annotation.OrderAnnotation;
import org.eclipse.scout.sdk.core.s.apidef.IScoutAnnotationApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class ScoutAnnotationGenerator<TYPE extends ScoutAnnotationGenerator<TYPE>>
extends AnnotationGenerator<TYPE> {
    public static final String DO_CONVENIENCE_METHODS_GENERATED_COMMENT = "DoConvenienceMethodsGenerator";

    public static IAnnotationGenerator<?> createOrder(double orderNr) {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::Order).withElementFrom(IScoutApi.class, api -> api.Order().valueElementName(), ISourceGenerator.raw((CharSequence)OrderAnnotation.convertToJavaSource(orderNr)));
    }

    public static IAnnotationGenerator<?> createExtends(CharSequence extendedType) {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::Extends).withElementFrom(IScoutApi.class, api -> api.Extends().valueElementName(), b -> b.classLiteral(extendedType));
    }

    public static IAnnotationGenerator<?> createClassId(CharSequence classIdValue) {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::ClassId).withElementFrom(IScoutApi.class, api -> api.ClassId().valueElementName(), b -> b.stringLiteral(classIdValue));
    }

    public static IAnnotationGenerator<?> createBefore() {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::Before);
    }

    public static IAnnotationGenerator<?> createApplicationScoped() {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::ApplicationScoped);
    }

    public static IAnnotationGenerator<?> createBeanMock() {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::BeanMock);
    }

    public static IAnnotationGenerator<?> createDoConvenienceMethodsGenerated() {
        return ScoutAnnotationGenerator.createGenerated((CharSequence)DO_CONVENIENCE_METHODS_GENERATED_COMMENT, null);
    }

    public static IAnnotationGenerator<?> createAuthentication() {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::Authentication).withElementFrom(IScoutApi.class, api -> api.Authentication().methodElementName(), b -> ScoutAnnotationGenerator.createClazz(IScoutApi.class, IScoutVariousApi::BasicAuthenticationMethod).generate(b)).withElementFrom(IScoutApi.class, api -> api.Authentication().verifierElementName(), b -> ScoutAnnotationGenerator.createClazz(IScoutApi.class, IScoutVariousApi::BasicAuthenticationMethod).generate(b));
    }

    public static <API extends IApiSpecification> IAnnotationGenerator<?> createClazz(Class<API> apiClass, Function<API, ITypeNameSupplier> referenceProvider) {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::Clazz).withElementFrom(IScoutApi.class, api -> api.Clazz().valueElementName(), b -> b.classLiteralFrom(apiClass, referenceProvider));
    }

    public static IAnnotationGenerator<?> createClazz(CharSequence clazzFqn) {
        ITypeNameSupplier fqn = ITypeNameSupplier.of((CharSequence)clazzFqn);
        return ScoutAnnotationGenerator.createClazz(null, api -> fqn);
    }

    public static IAnnotationGenerator<?> createHandler(CharSequence handlerFqn) {
        ITypeNameSupplier fqn = ITypeNameSupplier.of((CharSequence)handlerFqn);
        return ScoutAnnotationGenerator.createHandler(null, api -> fqn);
    }

    public static <API extends IApiSpecification> IAnnotationGenerator<?> createHandler(Class<API> apiClass, Function<API, ITypeNameSupplier> referenceProvider) {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::Handler).withElementFrom(IScoutApi.class, api -> api.Handler().valueElementName(), b -> ScoutAnnotationGenerator.createClazz(apiClass, referenceProvider).generate(b));
    }

    public static IAnnotationGenerator<?> createTunnelToServer() {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::TunnelToServer);
    }

    public static IAnnotationGenerator<?> createTest() {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::Test);
    }

    public static IAnnotationGenerator<?> createRunWithSubject(ISourceGenerator<IExpressionBuilder<?>> valueBuilder) {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::RunWithSubject).withElementFrom(IScoutApi.class, api -> api.RunWithSubject().valueElementName(), Optional.ofNullable(valueBuilder).orElseGet(() -> b -> b.stringLiteral((CharSequence)"anonymous")));
    }

    public static IAnnotationGenerator<?> createRunWithClientSession(CharSequence clientSession) {
        ITypeNameSupplier session = ITypeNameSupplier.of((CharSequence)clientSession);
        return ScoutAnnotationGenerator.createRunWithClientSessionFrom(null, api -> session);
    }

    public static <API extends IApiSpecification> IAnnotationGenerator<?> createRunWithClientSession(ApiFunction<API, ITypeNameSupplier> clientSessionProvider) {
        if (clientSessionProvider == null) {
            return ScoutAnnotationGenerator.createRunWithClientSessionFrom(null, null);
        }
        return ScoutAnnotationGenerator.createRunWithClientSessionFrom(clientSessionProvider.apiClass().orElse(null), clientSessionProvider.apiFunction());
    }

    public static <API extends IApiSpecification> IAnnotationGenerator<?> createRunWithClientSessionFrom(Class<API> apiSpec, Function<API, ITypeNameSupplier> clientSessionProvider) {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::RunWithClientSession).withElementFrom(IScoutApi.class, api -> api.RunWithClientSession().valueElementName(), b -> b.classLiteral((CharSequence)Optional.ofNullable(clientSessionProvider).map(p -> new ApiFunction(apiSpec, p)).map(a -> (ITypeNameSupplier)a.apply(b.context())).map(ITypeNameSupplier::fqn).filter(Strings::hasText).orElseGet(() -> ((IScoutApi)b.context().requireApi(IScoutApi.class)).TestEnvironmentClientSession().fqn())));
    }

    public static IAnnotationGenerator<?> createRunWithServerSession(CharSequence serverSession) {
        ITypeNameSupplier session = ITypeNameSupplier.of((CharSequence)serverSession);
        return ScoutAnnotationGenerator.createRunWithServerSession(null, api -> session);
    }

    public static <API extends IApiSpecification> IAnnotationGenerator<?> createRunWithServerSession(ApiFunction<API, ITypeNameSupplier> serverSessionProvider) {
        Ensure.notNull(serverSessionProvider);
        return ScoutAnnotationGenerator.createRunWithServerSession(serverSessionProvider.apiClass().orElse(null), serverSessionProvider.apiFunction());
    }

    public static <API extends IApiSpecification> IAnnotationGenerator<?> createRunWithServerSession(Class<API> apiSpec, Function<API, ITypeNameSupplier> serverSessionProvider) {
        Ensure.notNull(serverSessionProvider);
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::RunWithServerSession).withElementFrom(IScoutApi.class, api -> api.RunWithServerSession().valueElementName(), b -> b.classLiteralFrom(apiSpec, serverSessionProvider));
    }

    public static IAnnotationGenerator<?> createRunWith(CharSequence runner) {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::RunWith).withElementFrom(IScoutApi.class, api -> api.RunWith().valueElementName(), b -> b.classLiteral(Ensure.notBlank((CharSequence)runner)));
    }

    public static IAnnotationGenerator<?> createData(CharSequence pageDataType) {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::Data).withElementFrom(IScoutApi.class, api -> api.Data().valueElementName(), b -> b.classLiteral(Ensure.notBlank((CharSequence)pageDataType)));
    }

    public static IAnnotationGenerator<?> createFormData() {
        return ScoutAnnotationGenerator.createFormData(null, null, null);
    }

    public static IAnnotationGenerator<?> createFormData(CharSequence formDataClass, FormDataAnnotation.SdkCommand sdkCommand, FormDataAnnotation.DefaultSubtypeSdkCommand defaultSubtypeCommand) {
        IAnnotationGenerator generator = ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::FormData);
        if (Strings.hasText((CharSequence)formDataClass)) {
            generator.withElementFrom(IScoutApi.class, api -> api.FormData().valueElementName(), b -> b.classLiteral(formDataClass));
        }
        if (sdkCommand != null && FormDataAnnotation.SdkCommand.DEFAULT != sdkCommand) {
            generator.withElementFrom(IScoutApi.class, api -> api.FormData().sdkCommandElementName(), b -> ((IExpressionBuilder)((IExpressionBuilder)b.refFrom(IScoutApi.class, api -> api.FormData().fqn())).append(".SdkCommand.")).append(sdkCommand.name()));
        }
        if (defaultSubtypeCommand != null && FormDataAnnotation.DefaultSubtypeSdkCommand.DEFAULT != defaultSubtypeCommand) {
            generator.withElementFrom(IScoutApi.class, api -> api.FormData().defaultSubtypeSdkCommandElementName(), b -> ((IExpressionBuilder)((IExpressionBuilder)b.ref((CharSequence)generator.elementName().orElseThrow())).append(".DefaultSubtypeSdkCommand.")).append(defaultSubtypeCommand.name()));
        }
        return generator;
    }

    public static IAnnotationGenerator<?> createReplace() {
        return ScoutAnnotationGenerator.create().withAnnotationNameFrom(IScoutApi.class, IScoutAnnotationApi::Replace);
    }
}

