/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.derived;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.MissingTypeException;
import org.eclipse.scout.sdk.core.s.derived.IDerivedResourceHandler;
import org.eclipse.scout.sdk.core.s.derived.IDerivedResourceInput;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;

public abstract class AbstractDerivedResourceHandler
implements IDerivedResourceHandler {
    private final IDerivedResourceInput m_input;

    protected AbstractDerivedResourceHandler(IDerivedResourceInput input) {
        this.m_input = (IDerivedResourceInput)Ensure.notNull((Object)input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<? extends IFuture<?>> apply(IEnvironment env, IProgress progress) {
        String backup = CoreUtils.getUsername();
        try {
            CoreUtils.setUsernameForThread((String)"Scout robot");
            Collection<? extends IFuture<?>> collection = this.execute(env, progress);
            return collection;
        }
        catch (MissingTypeException mte) {
            String inputTypeName = this.getInput().getSourceType(env).map(IType::name).orElse(null);
            SdkLog.info((CharSequence)"Skip type '{}' because it contains compile errors", (Object[])new Object[]{inputTypeName, mte});
            List list = Collections.emptyList();
            return list;
        }
        finally {
            CoreUtils.setUsernameForThread((String)backup);
        }
    }

    protected abstract Collection<? extends IFuture<?>> execute(IEnvironment var1, IProgress var2);

    public IDerivedResourceInput getInput() {
        return this.m_input;
    }

    public final int hashCode() {
        return this.m_input.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDerivedResourceHandler other = (AbstractDerivedResourceHandler)obj;
        return this.m_input.equals(other.m_input);
    }
}

