/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.apidef;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.apidef.Api;
import org.eclipse.scout.sdk.core.apidef.ApiVersion;
import org.eclipse.scout.sdk.core.apidef.IApiProvider;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.Scout10Api;
import org.eclipse.scout.sdk.core.s.apidef.Scout11Api;
import org.eclipse.scout.sdk.core.s.apidef.Scout22010Api;
import org.eclipse.scout.sdk.core.s.apidef.Scout22Api;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.util.maven.MavenArtifactVersions;

public final class ScoutApi {
    public static final String SCOUT_RT_PLATFORM_NAME = "org.eclipse.scout.rt.platform";

    private ScoutApi() {
    }

    public static IScoutApi latest() {
        return (IScoutApi)Api.latest(IScoutApi.class);
    }

    public static int latestMajorVersion() {
        return Api.latestMajorVersion(IScoutApi.class);
    }

    public static Optional<IScoutApi> create(IJavaElement context) {
        return Api.create(IScoutApi.class, (IJavaElement)context);
    }

    public static Optional<IScoutApi> create(IJavaEnvironment context) {
        return Api.create(IScoutApi.class, (IJavaEnvironment)context);
    }

    public static Optional<ApiVersion> version(IJavaEnvironment context) {
        return Api.version(IScoutApi.class, (IJavaEnvironment)context);
    }

    public static Optional<ApiVersion> version(Path moduleDir, IEnvironment env) {
        return env.findJavaEnvironment(moduleDir).flatMap(je -> Api.version(IScoutApi.class, (IJavaEnvironment)je));
    }

    public static Stream<IScoutApi> allKnown() {
        return Api.allKnown(IScoutApi.class);
    }

    static boolean register() {
        Api.registerProvider(IScoutApi.class, (IApiProvider)new ScoutApiProvider());
        return true;
    }

    public static class ScoutApiProvider
    implements IApiProvider {
        public Collection<Class<? extends IApiSpecification>> knownApis() {
            return Arrays.asList(Scout10Api.class, Scout11Api.class, Scout22010Api.class, Scout22Api.class);
        }

        public Optional<ApiVersion> version(IJavaEnvironment context) {
            return MavenArtifactVersions.usedIn(ScoutApi.SCOUT_RT_PLATFORM_NAME, context);
        }
    }
}

