/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.annotation;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.model.api.IMember;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.annotation.DataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotation;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;

public class FormDataAnnotationDescriptor {
    private final Set<IType> m_interfaceTypes = new LinkedHashSet<IType>();
    private FormDataAnnotation.SdkCommand m_sdkCommand;
    private FormDataAnnotation.DefaultSubtypeSdkCommand m_defaultSubtypeSdkCommand;
    private int m_genericOrdinal = -1;
    private IType m_formDataType;
    private IType m_superType;
    private IAnnotatable m_annotationOwner;
    private IType m_genericOrdinalDefinitionType;

    protected FormDataAnnotationDescriptor() {
    }

    public static FormDataAnnotationDescriptor of(IType type) {
        FormDataAnnotationDescriptor descriptor = new FormDataAnnotationDescriptor();
        if (type == null) {
            return descriptor;
        }
        IScoutApi scoutApi = (IScoutApi)type.javaEnvironment().requireApi(IScoutApi.class);
        if (type.isInstanceOf((ITypeNameSupplier)scoutApi.IFormExtension()) || type.isInstanceOf((ITypeNameSupplier)scoutApi.IFormFieldExtension())) {
            Optional<DataAnnotationDescriptor> dataAnnotation = DataAnnotationDescriptor.of(type);
            dataAnnotation.ifPresent(dataAnnotationDescriptor -> {
                descriptor.setAnnotationOwner((IAnnotatable)type);
                descriptor.setDefaultSubtypeSdkCommand(FormDataAnnotation.DefaultSubtypeSdkCommand.CREATE);
                descriptor.setFormDataType(dataAnnotationDescriptor.getDataType());
                descriptor.setGenericOrdinal(-1);
                descriptor.setSdkCommand(FormDataAnnotation.SdkCommand.CREATE);
                descriptor.setSuperType(dataAnnotationDescriptor.getSuperDataType().orElseGet(() -> type.javaEnvironment().findType((ITypeNameSupplier)scoutApi.AbstractFormFieldData()).orElse(null)));
            });
        } else {
            FormDataAnnotationDescriptor.parseFormDataAnnotationRec(descriptor, type, scoutApi, true);
        }
        return descriptor;
    }

    private static void parseFormDataAnnotationRec(FormDataAnnotationDescriptor descriptorToFill, IType type, IScoutApi api, boolean isOwner) {
        if (type == null) {
            return;
        }
        String replaceAnnotationFqn = api.Replace().fqn();
        boolean replaceAnnotationPresent = type.annotations().withName((CharSequence)replaceAnnotationFqn).existsAny();
        IType superType = type.superClass().orElse(null);
        FormDataAnnotationDescriptor.parseFormDataAnnotationRec(descriptorToFill, superType, api, replaceAnnotationPresent);
        type.superInterfaces().forEach(superInterface -> FormDataAnnotationDescriptor.parseFormDataAnnotationRec(descriptorToFill, superInterface, api, replaceAnnotationPresent));
        if (replaceAnnotationPresent && superType != null && !superType.annotations().withName((CharSequence)replaceAnnotationFqn).existsAny()) {
            Optional declaringType = superType.declaringType();
            while (declaringType.isPresent()) {
                FormDataAnnotationDescriptor declaringTypeFormDataAnnotation = FormDataAnnotationDescriptor.of((IType)declaringType.orElseThrow());
                if (FormDataAnnotationDescriptor.isIgnore(declaringTypeFormDataAnnotation)) {
                    descriptorToFill.setSdkCommand(FormDataAnnotation.SdkCommand.IGNORE);
                    break;
                }
                declaringType = ((IType)declaringType.orElseThrow()).declaringType();
            }
        }
        boolean cumulativeAttribsOnly = replaceAnnotationPresent && !FormDataAnnotationDescriptor.isIgnore(descriptorToFill) && !type.isInstanceOf((ITypeNameSupplier)api.IForm());
        FormDataAnnotationDescriptor.fillFormDataAnnotation((IAnnotatable)type, descriptorToFill, isOwner, cumulativeAttribsOnly);
    }

    private static void fillFormDataAnnotation(IAnnotatable element, FormDataAnnotationDescriptor descriptorToFill, boolean isOwner, boolean cumulativeAttributesOnly) {
        boolean isMemberType;
        Optional optFda = element.annotations().withManagedWrapper(FormDataAnnotation.class).first();
        if (optFda.isEmpty()) {
            return;
        }
        FormDataAnnotation formDataAnnotation = (FormDataAnnotation)((Object)optFda.orElseThrow());
        IType dtoType = null;
        if (!formDataAnnotation.isValueDefault()) {
            dtoType = formDataAnnotation.value();
        }
        FormDataAnnotation.SdkCommand sdkCommand = null;
        if (!formDataAnnotation.isSdkCommandDefault()) {
            sdkCommand = formDataAnnotation.sdkCommand();
        }
        FormDataAnnotation.DefaultSubtypeSdkCommand subTypeCommand = null;
        if (!formDataAnnotation.isDefaultSubtypeSdkCommandDefault()) {
            subTypeCommand = formDataAnnotation.defaultSubtypeSdkCommand();
        }
        int genericOrdinal = formDataAnnotation.genericOrdinal();
        IType[] interfaces = formDataAnnotation.interfaces();
        if (!cumulativeAttributesOnly) {
            if (dtoType != null) {
                if (isOwner) {
                    descriptorToFill.setFormDataType(dtoType);
                } else {
                    descriptorToFill.setSuperType(dtoType);
                }
            }
            if (isOwner && sdkCommand != null) {
                descriptorToFill.setSdkCommand(sdkCommand);
            }
            if (subTypeCommand != null) {
                descriptorToFill.setDefaultSubtypeSdkCommand(subTypeCommand);
            }
            if (genericOrdinal > -1) {
                descriptorToFill.setGenericOrdinal(genericOrdinal);
                if (element instanceof IType) {
                    descriptorToFill.setGenericOrdinalDefinitionType((IType)element);
                } else if (element instanceof IMethod) {
                    descriptorToFill.setGenericOrdinalDefinitionType(((IMethod)element).requireDeclaringType());
                }
            }
        }
        descriptorToFill.setAnnotationOwner(element);
        if (interfaces != null && interfaces.length > 0) {
            descriptorToFill.addInterfaces(interfaces);
        }
        boolean bl = isMemberType = element instanceof IMember && ((IMember)element).declaringType().isPresent();
        if (isOwner && sdkCommand == FormDataAnnotation.SdkCommand.USE && dtoType != null && isMemberType) {
            descriptorToFill.setSuperType(dtoType);
            descriptorToFill.setFormDataType(null);
            descriptorToFill.setSdkCommand(FormDataAnnotation.SdkCommand.CREATE);
        }
        if (element instanceof IMethod && descriptorToFill.getSdkCommand() == null) {
            descriptorToFill.setSdkCommand(FormDataAnnotation.SdkCommand.CREATE);
        }
    }

    public static boolean isCreate(FormDataAnnotationDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        return descriptor.getSdkCommand() == FormDataAnnotation.SdkCommand.CREATE || descriptor.getSdkCommand() == null && descriptor.getDefaultSubtypeSdkCommand() == FormDataAnnotation.DefaultSubtypeSdkCommand.CREATE;
    }

    public static boolean isIgnore(FormDataAnnotationDescriptor descriptor) {
        return descriptor.getSdkCommand() == FormDataAnnotation.SdkCommand.IGNORE || descriptor.getSdkCommand() == null && descriptor.getDefaultSubtypeSdkCommand() == FormDataAnnotation.DefaultSubtypeSdkCommand.IGNORE;
    }

    public static boolean isSdkCommandDefault(FormDataAnnotationDescriptor descriptor) {
        return descriptor != null && descriptor.getSdkCommand() == FormDataAnnotation.SdkCommand.DEFAULT;
    }

    public static boolean isSdkCommandCreate(FormDataAnnotationDescriptor descriptor) {
        return descriptor != null && descriptor.getSdkCommand() == FormDataAnnotation.SdkCommand.CREATE;
    }

    public static boolean isSdkCommandUse(FormDataAnnotationDescriptor descriptor) {
        return descriptor != null && descriptor.getSdkCommand() == FormDataAnnotation.SdkCommand.USE;
    }

    public static boolean isSdkCommandIgnore(FormDataAnnotationDescriptor descriptor) {
        return descriptor != null && descriptor.getSdkCommand() == FormDataAnnotation.SdkCommand.IGNORE;
    }

    public static boolean isDefaultSubtypeSdkCommandCreate(FormDataAnnotationDescriptor descriptor) {
        return descriptor != null && descriptor.getDefaultSubtypeSdkCommand() == FormDataAnnotation.DefaultSubtypeSdkCommand.CREATE;
    }

    public static boolean isDefaultSubtypeSdkCommandIgnore(FormDataAnnotationDescriptor descriptor) {
        return descriptor != null && descriptor.getDefaultSubtypeSdkCommand() == FormDataAnnotation.DefaultSubtypeSdkCommand.IGNORE;
    }

    public static boolean isDefaultSubtypeSdkCommandDefault(FormDataAnnotationDescriptor descriptor) {
        return descriptor != null && descriptor.getDefaultSubtypeSdkCommand() == FormDataAnnotation.DefaultSubtypeSdkCommand.DEFAULT;
    }

    public IType getFormDataType() {
        return this.m_formDataType;
    }

    protected void setFormDataType(IType formDataType) {
        this.m_formDataType = formDataType;
    }

    public FormDataAnnotation.SdkCommand getSdkCommand() {
        return this.m_sdkCommand;
    }

    protected void setSdkCommand(FormDataAnnotation.SdkCommand sdkCommand) {
        this.m_sdkCommand = sdkCommand;
    }

    public FormDataAnnotation.DefaultSubtypeSdkCommand getDefaultSubtypeSdkCommand() {
        return this.m_defaultSubtypeSdkCommand;
    }

    protected void setDefaultSubtypeSdkCommand(FormDataAnnotation.DefaultSubtypeSdkCommand defaultSubtypeSdkCommand) {
        this.m_defaultSubtypeSdkCommand = defaultSubtypeSdkCommand;
    }

    public int getGenericOrdinal() {
        return this.m_genericOrdinal;
    }

    protected void setGenericOrdinal(int genericOrdinal) {
        this.m_genericOrdinal = genericOrdinal;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    protected void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public IType getAnnotationOwnerAsType() {
        if (this.m_annotationOwner instanceof IType) {
            return (IType)this.m_annotationOwner;
        }
        return null;
    }

    public IAnnotatable getAnnotationOwner() {
        return this.m_annotationOwner;
    }

    protected void setAnnotationOwner(IAnnotatable annotationOwner) {
        this.m_annotationOwner = annotationOwner;
    }

    protected void addInterface(IType ifc) {
        this.m_interfaceTypes.add(ifc);
    }

    protected void addInterfaces(IType[] interfaces) {
        Collections.addAll(this.m_interfaceTypes, interfaces);
    }

    public Set<IType> getInterfaces() {
        return Collections.unmodifiableSet(this.m_interfaceTypes);
    }

    public IType getGenericOrdinalDefinitionType() {
        return this.m_genericOrdinalDefinitionType;
    }

    protected void setGenericOrdinalDefinitionType(IType genericOrdinalDefinitionType) {
        this.m_genericOrdinalDefinitionType = genericOrdinalDefinitionType;
    }
}

