/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.annotation;

import java.util.Optional;
import org.eclipse.scout.sdk.core.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.annotation.DataAnnotation;
import org.eclipse.scout.sdk.core.s.apidef.IScoutAnnotationApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;

public class DataAnnotationDescriptor {
    private final IType m_dataType;
    private final IType m_superDataType;
    private final IType m_annotationHolder;

    protected DataAnnotationDescriptor(IType dataType, IType superdataType, IType holder) {
        this.m_dataType = dataType;
        this.m_superDataType = superdataType;
        this.m_annotationHolder = holder;
    }

    public static Optional<DataAnnotationDescriptor> of(IType type) {
        if (type == null) {
            return Optional.empty();
        }
        Optional<IType> dtoType = DataAnnotationDescriptor.getDataAnnotationValue((IAnnotatable)type);
        if (dtoType.isEmpty()) {
            return Optional.empty();
        }
        Optional<Object> superType = Optional.empty();
        Optional curType = type.superClass();
        while (curType.isPresent() && !(superType = DataAnnotationDescriptor.getDataAnnotationValue((IAnnotatable)curType.orElseThrow())).isPresent()) {
            curType = ((IType)curType.orElseThrow()).superClass();
        }
        return Optional.of(new DataAnnotationDescriptor(dtoType.orElseThrow(), superType.orElse(null), type));
    }

    private static Optional<IType> getDataAnnotationValue(IAnnotatable owner) {
        Optional<IType> dataType = DataAnnotation.valueOf(owner);
        if (dataType.isPresent()) {
            return dataType;
        }
        IScoutAnnotationApi.PageData pageDataApi = ((IScoutApi)owner.javaEnvironment().requireApi(IScoutApi.class)).PageData();
        return owner.annotations().withName((CharSequence)pageDataApi.fqn()).first().flatMap(annotation -> annotation.element(pageDataApi.valueElementName())).map(element -> (IType)element.value().as(IType.class));
    }

    public IType getDataType() {
        return this.m_dataType;
    }

    public Optional<IType> getSuperDataType() {
        return Optional.ofNullable(this.m_superDataType);
    }

    public IType getAnnotationHolder() {
        return this.m_annotationHolder;
    }
}

