/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.diagnostics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.lsp4e.IMarkerAttributeComputer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.diagnostics.DiagnosticAnnotation;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class LSPDiagnosticsToMarkers
implements Consumer<PublishDiagnosticsParams> {
    public static final String LSP_DIAGNOSTIC = "lspDiagnostic";
    public static final String LANGUAGE_SERVER_ID = "languageServerId";
    public static final String LS_DIAGNOSTIC_MARKER_TYPE = "org.eclipse.lsp4e.diagnostic";
    private final @NonNull String languageServerId;
    private final @NonNull String markerType;
    private final Optional<IMarkerAttributeComputer> markerAttributeComputer;

    public LSPDiagnosticsToMarkers(@NonNull String serverId, @Nullable String markerType, @Nullable IMarkerAttributeComputer markerAttributeComputer) {
        this.languageServerId = serverId;
        this.markerType = markerType != null ? markerType : LS_DIAGNOSTIC_MARKER_TYPE;
        this.markerAttributeComputer = Optional.ofNullable(markerAttributeComputer);
    }

    public LSPDiagnosticsToMarkers(@NonNull String serverId) {
        this(serverId, null, null);
    }

    @Deprecated
    public LSPDiagnosticsToMarkers(IProject project, @NonNull String serverId) {
        this(serverId);
    }

    @Override
    public void accept(PublishDiagnosticsParams diagnostics) {
        try {
            String uri = diagnostics.getUri();
            IResource resource = LSPEclipseUtils.findResourceFor(uri);
            if (resource != null && resource.isAccessible()) {
                this.updateMarkers(diagnostics, resource);
            } else {
                LSPEclipseUtils.findOpenEditorsFor(LSPEclipseUtils.toUri(uri)).stream().map(reference -> reference.getEditor(true)).filter(Objects::nonNull).map(LSPEclipseUtils::getTextViewer).filter(Objects::nonNull).filter(ISourceViewer.class::isInstance).map(ISourceViewer.class::cast).forEach(sourceViewer -> this.updateEditorAnnotations((ISourceViewer)sourceViewer, diagnostics));
            }
        }
        catch (CoreException ex) {
            LanguageServerPlugin.logError(ex);
        }
    }

    private void updateEditorAnnotations(@NonNull ISourceViewer sourceViewer, PublishDiagnosticsParams diagnostics) {
        IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
        if (annotationModel == null) {
            return;
        }
        if (annotationModel instanceof IAnnotationModelExtension var4_5) {
            HashSet toRemove = new HashSet();
            annotationModel.getAnnotationIterator().forEachRemaining(annotation -> {
                if (annotation instanceof DiagnosticAnnotation) {
                    toRemove.add(annotation);
                }
            });
            HashMap toAdd = new HashMap(diagnostics.getDiagnostics().size(), 1.0f);
            diagnostics.getDiagnostics().forEach(diagnostic -> {
                try {
                    int startOffset = LSPEclipseUtils.toOffset(diagnostic.getRange().getStart(), sourceViewer.getDocument());
                    int endOffset = LSPEclipseUtils.toOffset(diagnostic.getRange().getEnd(), sourceViewer.getDocument());
                    toAdd.put(new DiagnosticAnnotation((Diagnostic)diagnostic), new Position(startOffset, endOffset - startOffset));
                }
                catch (BadLocationException ex) {
                    LanguageServerPlugin.logError(ex);
                }
            });
            annotationModelExtension.replaceAnnotations(toRemove.toArray(new Annotation[toRemove.size()]), toAdd);
        }
    }

    private void updateMarkers(PublishDiagnosticsParams diagnostics, IResource resource) throws CoreException {
        HashSet<IMarker> toDeleteMarkers = new HashSet<IMarker>(Arrays.asList(resource.findMarkers(this.markerType, false, 1)));
        toDeleteMarkers.removeIf(marker -> !Objects.equals(marker.getAttribute(LANGUAGE_SERVER_ID, ""), this.languageServerId));
        ArrayList<Diagnostic> newDiagnostics = new ArrayList<Diagnostic>();
        HashMap<IMarker, Diagnostic> toUpdate = new HashMap<IMarker, Diagnostic>();
        boolean disconnect = !diagnostics.getDiagnostics().isEmpty() && LSPEclipseUtils.getExistingDocument(resource) == null;
        IDocument document = diagnostics.getDiagnostics().isEmpty() ? null : LSPEclipseUtils.getDocument(resource);
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            IMarker associatedMarker = this.getExistingMarkerFor(document, diagnostic, toDeleteMarkers);
            if (associatedMarker == null) {
                newDiagnostics.add(diagnostic);
                continue;
            }
            toDeleteMarkers.remove(associatedMarker);
            toUpdate.put(associatedMarker, diagnostic);
        }
        IWorkspaceRunnable runnable = monitor -> {
            block15: {
                try {
                    try {
                        Map<String, Object> markerAttributes;
                        for (Diagnostic diagnostic : newDiagnostics) {
                            markerAttributes = this.computeMarkerAttributes(document, diagnostic, resource);
                            resource.createMarker(this.markerType, markerAttributes);
                        }
                        for (Map.Entry entry : toUpdate.entrySet()) {
                            markerAttributes = this.computeMarkerAttributes(document, (Diagnostic)entry.getValue(), resource);
                            this.updateMarker(markerAttributes, (IMarker)entry.getKey());
                        }
                        toDeleteMarkers.forEach(t -> {
                            try {
                                t.delete();
                            }
                            catch (CoreException e) {
                                LanguageServerPlugin.logError(e);
                            }
                        });
                    }
                    catch (CoreException coreException) {
                        if (resource.isAccessible()) {
                            LanguageServerPlugin.logError(coreException);
                        }
                        if (document == null || !disconnect) break block15;
                        try {
                            FileBuffers.getTextFileBufferManager().disconnect(resource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e2) {
                            LanguageServerPlugin.logError(e2);
                        }
                    }
                }
                finally {
                    if (document != null && disconnect) {
                        try {
                            FileBuffers.getTextFileBufferManager().disconnect(resource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    }
                }
            }
        };
        IWorkspace ws = resource.getWorkspace();
        ws.run(runnable, ws.getRuleFactory().markerRule(resource), 1, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void updateMarker(@NonNull Map<String, Object> targetAttributes, @NonNull IMarker marker) {
        try {
            if (!targetAttributes.equals(marker.getAttributes())) {
                marker.setAttributes(targetAttributes);
            }
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    private IMarker getExistingMarkerFor(IDocument document, Diagnostic diagnostic, Set<IMarker> remainingMarkers) {
        if (document == null) {
            return null;
        }
        for (IMarker marker : remainingMarkers) {
            try {
                if (LSPEclipseUtils.toOffset(diagnostic.getRange().getStart(), document) != MarkerUtilities.getCharStart((IMarker)marker) || LSPEclipseUtils.toOffset(diagnostic.getRange().getEnd(), document) != MarkerUtilities.getCharEnd((IMarker)marker) || !Objects.equals(marker.getAttribute("message"), diagnostic.getMessage()) || !Objects.equals(marker.getAttribute(LANGUAGE_SERVER_ID), this.languageServerId)) continue;
                return marker;
            }
            catch (CoreException | BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return null;
    }

    private @NonNull Map<String, Object> computeMarkerAttributes(@Nullable IDocument document, @NonNull Diagnostic diagnostic, @NonNull IResource resource) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(8);
        attributes.put(LSP_DIAGNOSTIC, diagnostic);
        attributes.put(LANGUAGE_SERVER_ID, this.languageServerId);
        attributes.put("message", diagnostic.getMessage());
        attributes.put("severity", LSPEclipseUtils.toEclipseMarkerSeverity(diagnostic.getSeverity()));
        if (document != null) {
            Range range = diagnostic.getRange();
            int documentLength = document.getLength();
            try {
                int start = Math.min(LSPEclipseUtils.toOffset(range.getStart(), document), documentLength);
                int end = Math.min(LSPEclipseUtils.toOffset(range.getEnd(), document), documentLength);
                int lineOfStartOffset = document.getLineOfOffset(start);
                if (start == end && documentLength > end && document.getLineOfOffset(++end) != lineOfStartOffset) {
                    --start;
                    --end;
                }
                attributes.put("charStart", start);
                attributes.put("charEnd", end);
                attributes.put("lineNumber", lineOfStartOffset + 1);
            }
            catch (BadLocationException ex) {
                LanguageServerPlugin.logError(ex);
            }
        }
        this.markerAttributeComputer.ifPresent(c -> c.addMarkerAttributesForDiagnostic(diagnostic, document, resource, attributes));
        return attributes;
    }
}

