/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.internal.IMemento;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.jst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.core.IRuntime;

public abstract class RuntimeClasspathProviderDelegate {
    private volatile List<SourceAttachmentUpdate> sourceAttachments;
    private String extensionId;
    private Map<String, IPath> runtimePathMap = Collections.synchronizedMap(new HashMap());
    private Map<String, IClasspathEntry[]> previousClasspath = Collections.synchronizedMap(new HashMap());

    public final void initialize(String id) {
        this.extensionId = id;
    }

    public IClasspathEntry[] resolveClasspathContainer(IRuntime runtime) {
        return null;
    }

    public IClasspathEntry[] resolveClasspathContainer(IProject project, IRuntime runtime) {
        return null;
    }

    public IClasspathEntry[] resolveClasspathContainerImpl(IRuntime runtime) {
        return this.resolveClasspathContainerImpl(null, runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClasspathEntry[] resolveClasspathContainerImpl(IProject project, IRuntime runtime) {
        IClasspathEntry[] entries;
        block17: {
            String key;
            if (runtime == null) {
                return new IClasspathEntry[0];
            }
            this.runtimePathMap.put(runtime.getId(), runtime.getLocation());
            entries = this.resolveClasspathContainer(project, runtime);
            if (entries == null) {
                entries = this.resolveClasspathContainer(runtime);
            }
            if (entries == null) {
                entries = new IClasspathEntry[]{};
            }
            RuntimeClasspathProviderDelegate runtimeClasspathProviderDelegate = this;
            synchronized (runtimeClasspathProviderDelegate) {
                if (this.sourceAttachments == null) {
                    this.load();
                }
            }
            List<SourceAttachmentUpdate> srcAttachments = this.sourceAttachments;
            if (srcAttachments != null) {
                int size = entries.length;
                int size2 = srcAttachments.size();
                int i = 0;
                while (i < size) {
                    int j = 0;
                    while (j < size2) {
                        SourceAttachmentUpdate sau = srcAttachments.get(j);
                        if (sau.runtimeId.equals(runtime.getId()) && sau.entry.equals((Object)entries[i].getPath())) {
                            IClasspathAttribute[] consolidatedClasspathAttributes = this.consolidateClasspathAttributes(sau.attributes, entries[i].getExtraAttributes());
                            entries[i] = JavaCore.newLibraryEntry((IPath)entries[i].getPath(), (IPath)sau.sourceAttachmentPath, (IPath)sau.sourceAttachmentRootPath, (IAccessRule[])entries[i].getAccessRules(), (IClasspathAttribute[])consolidatedClasspathAttributes, (boolean)false);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (!this.previousClasspath.containsKey(key = String.valueOf(project.getName()) + "/" + runtime.getId())) {
                this.previousClasspath.put(key, entries);
            } else {
                IClasspathEntry[] previousClasspathEntries = this.previousClasspath.get(key);
                if (previousClasspathEntries == null || previousClasspathEntries.length != entries.length || this.entriesChanged(previousClasspathEntries, entries)) {
                    if (Trace.FINEST) {
                        Trace.trace("/finest", "Classpath update: " + key + " " + entries);
                    }
                    this.previousClasspath.put(key, entries);
                    Path path = new Path("org.eclipse.jst.server.core.container");
                    path = path.append(this.extensionId).append(runtime.getId());
                    try {
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[1], (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        if (!Trace.WARNING) break block17;
                        Trace.trace("/warning", "Error updating classpath", e);
                    }
                }
            }
        }
        return entries;
    }

    private boolean entriesChanged(IClasspathEntry[] previousEntries, IClasspathEntry[] entries) {
        if (previousEntries.length != entries.length) {
            return true;
        }
        int i = 0;
        while (i < previousEntries.length) {
            if (previousEntries[i] == null && entries[i] != null || previousEntries[i].getPath() == null && entries[i].getPath() != null || !previousEntries[i].getPath().equals((Object)entries[i].getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasRuntimeClasspathChanged(IRuntime runtime) {
        try {
            IPath path = this.runtimePathMap.get(runtime.getId());
            return path != null && !path.equals((Object)runtime.getLocation());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void addJarFiles(File dir, List<IClasspathEntry> list, boolean includeSubdirectories) {
        int depth = 0;
        if (includeSubdirectories) {
            depth = 2;
        }
        RuntimeClasspathProviderDelegate.addJarFiles(dir, list, depth);
    }

    private static void addJarFiles(File dir, List<IClasspathEntry> list, int depth) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String filename = file.getName().toLowerCase();
                if (!filename.startsWith(".")) {
                    if (file.isDirectory() && depth > 0) {
                        RuntimeClasspathProviderDelegate.addJarFiles(file, list, depth - 1);
                    } else if (filename.endsWith(".jar") || filename.endsWith(".zip")) {
                        Path path = new Path(file.getAbsolutePath());
                        list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                    }
                }
                ++n2;
            }
        }
    }

    protected static void addLibraryEntries(List<IClasspathEntry> list, File dir, boolean includeSubdirectories) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        RuntimeClasspathProviderDelegate.addJarFiles(dir, list, includeSubdirectories);
    }

    public void requestClasspathContainerUpdate(IRuntime runtime, IClasspathEntry[] entries) {
        if (runtime == null || entries == null) {
            return;
        }
        ArrayList<SourceAttachmentUpdate> srcAttachments = new ArrayList<SourceAttachmentUpdate>();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getSourceAttachmentPath() != null || entry.getExtraAttributes() != null && entry.getExtraAttributes().length > 0) {
                SourceAttachmentUpdate sau = new SourceAttachmentUpdate();
                sau.runtimeId = runtime.getId();
                sau.entry = entry.getPath();
                sau.sourceAttachmentPath = entry.getSourceAttachmentPath();
                sau.sourceAttachmentRootPath = entry.getSourceAttachmentRootPath();
                sau.attributes = entry.getExtraAttributes();
                srcAttachments.add(sau);
            }
            ++n2;
        }
        this.sourceAttachments = srcAttachments;
        this.save();
    }

    private void load() {
        ArrayList<SourceAttachmentUpdate> srcAttachments;
        block12: {
            srcAttachments = new ArrayList<SourceAttachmentUpdate>();
            String id = this.extensionId;
            String filename = JavaServerPlugin.getInstance().getStateLocation().append(String.valueOf(id) + ".xml").toOSString();
            if (!new File(filename).exists()) {
                return;
            }
            try {
                IMemento[] children;
                IMemento memento = XMLMemento.loadMemento(filename);
                IMemento[] iMementoArray = children = memento.getChildren("source-attachment");
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    block11: {
                        IMemento child = iMementoArray[n2];
                        try {
                            IMemento[] attrChildren;
                            SourceAttachmentUpdate sau = new SourceAttachmentUpdate();
                            sau.runtimeId = child.getString("runtime-id");
                            String temp = child.getString("entry");
                            if (temp != null) {
                                sau.entry = new Path(temp);
                            }
                            if ((temp = child.getString("source-attachment-path")) != null) {
                                sau.sourceAttachmentPath = new Path(temp);
                            }
                            if ((temp = child.getString("source-attachment-root-path")) != null) {
                                sau.sourceAttachmentRootPath = new Path(temp);
                            }
                            if ((attrChildren = child.getChildren("attribute")) != null) {
                                int size2 = attrChildren.length;
                                sau.attributes = new IClasspathAttribute[size2];
                                int j = 0;
                                while (j < size2) {
                                    String name = attrChildren[j].getString("name");
                                    String value = attrChildren[j].getString("value");
                                    sau.attributes[j] = JavaCore.newClasspathAttribute((String)name, (String)value);
                                    ++j;
                                }
                            }
                            srcAttachments.add(sau);
                        }
                        catch (Exception e) {
                            if (!Trace.WARNING) break block11;
                            Trace.trace("/warning", "Could not load source attachment: " + e);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                if (!Trace.WARNING) break block12;
                Trace.trace("/warning", "Could not load source path info", e);
            }
        }
        this.sourceAttachments = srcAttachments;
    }

    private synchronized void save() {
        block8: {
            List<SourceAttachmentUpdate> srcAttachments = this.sourceAttachments;
            if (srcAttachments == null) {
                return;
            }
            String id = this.extensionId;
            String filename = JavaServerPlugin.getInstance().getStateLocation().append(String.valueOf(id) + ".xml").toOSString();
            try {
                XMLMemento memento = XMLMemento.createWriteRoot("classpath");
                for (SourceAttachmentUpdate sau : srcAttachments) {
                    IMemento child = memento.createChild("source-attachment");
                    child.putString("runtime-id", sau.runtimeId);
                    if (sau.entry != null) {
                        child.putString("entry", sau.entry.toPortableString());
                    }
                    if (sau.sourceAttachmentPath != null) {
                        child.putString("source-attachment-path", sau.sourceAttachmentPath.toPortableString());
                    }
                    if (sau.sourceAttachmentRootPath != null) {
                        child.putString("source-attachment-root-path", sau.sourceAttachmentRootPath.toPortableString());
                    }
                    if (sau.attributes == null) continue;
                    IClasspathAttribute[] iClasspathAttributeArray = sau.attributes;
                    int n = sau.attributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathAttribute attr = iClasspathAttributeArray[n2];
                        IMemento attrChild = child.createChild("attribute");
                        attrChild.putString("name", attr.getName());
                        attrChild.putString("value", attr.getValue());
                        ++n2;
                    }
                }
                memento.saveToFile(filename);
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block8;
                Trace.trace("/severe", "Error saving source path info", e);
            }
        }
    }

    public IClasspathAttribute[] consolidateClasspathAttributes(IClasspathAttribute[] sourceAttachmentAttributes, IClasspathAttribute[] classpathEntryAttributes) {
        ArrayList<IClasspathAttribute> classpathAttributeList = new ArrayList<IClasspathAttribute>();
        classpathAttributeList.addAll(Arrays.asList(sourceAttachmentAttributes));
        int i = 0;
        while (i < classpathEntryAttributes.length) {
            boolean attributeCollision = false;
            int j = 0;
            while (j < sourceAttachmentAttributes.length) {
                String name = classpathEntryAttributes[i].getName();
                if (name != null && name.equals(sourceAttachmentAttributes[j].getName())) {
                    attributeCollision = true;
                    break;
                }
                ++j;
            }
            if (!attributeCollision) {
                classpathAttributeList.add(classpathEntryAttributes[i]);
            }
            ++i;
        }
        return classpathAttributeList.toArray(new IClasspathAttribute[classpathAttributeList.size()]);
    }

    protected class SourceAttachmentUpdate {
        String runtimeId;
        IPath entry;
        IPath sourceAttachmentPath;
        IPath sourceAttachmentRootPath;
        IClasspathAttribute[] attributes;

        protected SourceAttachmentUpdate() {
        }
    }
}

