/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.apidef.OptApiFunction;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.util.TierTree;
import org.eclipse.scout.sdk.core.util.Strings;

public interface ITier<A extends IApiSpecification>
extends Predicate<IJavaElement> {
    public String tierName();

    public String getLookupFqn(A var1);

    public Class<A> getApiClass();

    default public String getLookupFqn(OptApiFunction optApiFunction) {
        return Optional.ofNullable(optApiFunction).flatMap(oaf -> oaf.apply(this.getApiClass())).map(this::getLookupFqn).orElse(null);
    }

    @Override
    default public boolean test(IJavaElement element) {
        return ITier.of(element).filter(this::isIncludedIn).isPresent();
    }

    default public boolean isIncludedIn(ITier<?> tier) {
        return TierTree.isAvailable(tier, this);
    }

    public static Optional<ITier<?>> of(IJavaElement element) {
        return TierTree.tierOf(element);
    }

    public static Optional<ITier<?>> of(IJavaEnvironment env) {
        return TierTree.tierOf(env);
    }

    public static Optional<ITier<?>> of(Predicate<String> typeLookupStrategy, OptApiFunction optApiFunction) {
        return TierTree.tierOf(typeLookupStrategy, optApiFunction);
    }

    default public String convert(ITier<?> to, String name) {
        if (Strings.isBlank((CharSequence)name) || to == null) {
            return name;
        }
        if (to == this) {
            return name;
        }
        return Strings.replace((CharSequence)name, (CharSequence)("." + this.tierName()), (CharSequence)("." + to.tierName())).toString();
    }
}

