/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.permission;

import java.util.function.BiConsumer;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.permission.PermissionGenerator;
import org.eclipse.scout.sdk.core.util.Ensure;

public class PermissionNewOperation
implements BiConsumer<IEnvironment, IProgress> {
    private String m_permissionName;
    private IClasspathEntry m_sharedSourceFolder;
    private String m_package;
    private String m_superType;
    private IType m_createdPermission;

    @Override
    public void accept(IEnvironment env, IProgress progress) {
        progress.init(1, this.toString(), new Object[0]);
        this.setCreatedPermission(this.createPermission(env, progress.newChild(1)));
    }

    protected IType createPermission(IEnvironment env, IProgress progress) {
        Ensure.notBlank((CharSequence)this.getPermissionName(), (CharSequence)"No permission name provided", (Object[])new Object[0]);
        Ensure.notBlank((CharSequence)this.getPackage(), (CharSequence)"No package name provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getSharedSourceFolder(), (CharSequence)"No source folder provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getSuperType(), (CharSequence)"No supertype provided", (Object[])new Object[0]);
        PermissionGenerator psb = (PermissionGenerator)((PermissionGenerator)((PermissionGenerator)new PermissionGenerator().withElementName(this.getPermissionName())).withPackageName(this.getPackage())).withSuperClass(this.getSuperType());
        return env.writeCompilationUnit((ICompilationUnitGenerator<?>)psb, this.getSharedSourceFolder(), progress);
    }

    public IType getCreatedPermission() {
        return this.m_createdPermission;
    }

    protected void setCreatedPermission(IType createdPermission) {
        this.m_createdPermission = createdPermission;
    }

    public String getPermissionName() {
        return this.m_permissionName;
    }

    public void setPermissionName(String permissionName) {
        this.m_permissionName = permissionName;
    }

    public IClasspathEntry getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IClasspathEntry sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public String getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(String superType) {
        this.m_superType = superType;
    }

    public String toString() {
        return "Create new Permission";
    }
}

