/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.page;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.builder.java.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.generator.method.MethodGenerator;
import org.eclipse.scout.sdk.core.generator.methodparam.IMethodParameterGenerator;
import org.eclipse.scout.sdk.core.generator.methodparam.MethodParameterGenerator;
import org.eclipse.scout.sdk.core.generator.type.PrimaryTypeGenerator;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.classid.ClassIds;
import org.eclipse.scout.sdk.core.s.dto.DtoGeneratorFactory;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.page.PageGenerator;
import org.eclipse.scout.sdk.core.s.service.ServiceNewOperation;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.Strings;

public class PageNewOperation
implements BiConsumer<IEnvironment, IProgress> {
    private String m_pageName;
    private FinalValue<String> m_baseName = new FinalValue();
    private IClasspathEntry m_clientSourceFolder;
    private IClasspathEntry m_pageDataSourceFolder;
    private IClasspathEntry m_sharedSourceFolder;
    private IClasspathEntry m_serverSourceFolder;
    private IClasspathEntry m_testSourceFolder;
    private String m_package;
    private String m_superType;
    private String m_serverSession;
    private boolean m_createAbstractPage;
    private boolean m_pageWithTable;
    private boolean m_createPageData;
    private boolean m_createOrAppendService;
    private ServiceNewOperation m_serviceNewOperation;
    private IFuture<IType> m_createdAbstractPage;
    private String m_createdAbstractPageFqn;
    private IFuture<IType> m_createdPage;
    private String m_createdPageFqn;
    private IFuture<IType> m_createdPageData;
    private String m_createdPageDataFqn;
    private IFuture<IType> m_createdAbstractPageData;
    private String m_createdAbstractPageDataFqn;
    private IFuture<IType> m_createdServiceIfc;
    private String m_serviceIfcFqn;
    private IFuture<IType> m_createdServiceImpl;
    private String m_serviceImplFqn;
    private IFuture<IType> m_createdServiceTest;
    private String m_serviceTestFqn;
    private String m_dataFetchMethodName;

    @Override
    public void accept(IEnvironment env, IProgress progress) {
        this.validateOperation();
        this.prepareOperation();
        this.prepareProgress(progress);
        this.executeOperation(env, progress);
    }

    protected void validateOperation() {
        Ensure.notBlank((CharSequence)this.getPageName(), (CharSequence)"No page name provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getClientSourceFolder(), (CharSequence)"No client source folder provided", (Object[])new Object[0]);
        Ensure.notBlank((CharSequence)this.getPackage(), (CharSequence)"No package name provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getSuperType(), (CharSequence)"No supertype provided", (Object[])new Object[0]);
    }

    protected void prepareOperation() {
        this.setPageWithTable(this.calculatePageWithTable());
        this.setCreatePageData(this.isPageWithTable() && this.getPageDataSourceFolder() != null);
        this.setCreateOrAppendService(this.isCreatePageData() && this.getSharedSourceFolder() != null && this.getServerSourceFolder() != null);
    }

    protected void prepareProgress(IProgress progress) {
        progress.init(this.getTotalWork(), this.toString(), new Object[0]);
    }

    protected void executeOperation(IEnvironment env, IProgress progress) {
        String sharedPackage = ScoutTier.Client.convert(ScoutTier.Shared, this.getPackage());
        if (this.isCreatePageData()) {
            if (this.isCreateAbstractPage()) {
                this.setCreatedAbstractPageData(this.createPageData("Abstract" + this.getPageName(), sharedPackage, this::setCreatedAbstractPageDataFqn, env, progress.newChild(1)));
            }
            this.setCreatedPageData(this.createPageData(this.getPageName(), sharedPackage, this::setCreatedPageDataFqn, env, progress.newChild(1)));
        }
        if (this.isCreateOrAppendService()) {
            this.createOrAppendService(sharedPackage, env, progress);
        }
        if (this.isCreateAbstractPage()) {
            this.setCreatedAbstractPage(this.createAbstractPage(this.isPageWithTable(), env, progress.newChild(1)));
            this.setSuperType(this.getCreatedAbstractPageFqn());
        }
        this.setCreatedPage(this.createPage(this.isPageWithTable(), env, progress.newChild(1)));
        if (this.isCreatePageData()) {
            this.updatePageDatas(env, progress.newChild(2));
        }
    }

    protected int getTotalWork() {
        int result = 1;
        if (this.isCreateAbstractPage()) {
            ++result;
        }
        if (this.isCreatePageData()) {
            if (this.isCreateAbstractPage()) {
                ++result;
            }
            ++result;
            result += 2;
        }
        if (this.isCreateService()) {
            result += 3;
        }
        return result;
    }

    protected boolean calculatePageWithTable() {
        return this.getClientSourceFolder().javaEnvironment().findType(JavaTypes.erasure((CharSequence)this.getSuperType())).map(PageNewOperation::calculatePageWithTable).orElse(false);
    }

    protected static boolean calculatePageWithTable(IType type) {
        IScoutApi scoutApi = (IScoutApi)type.javaEnvironment().requireApi(IScoutApi.class);
        return type.isInstanceOf((ITypeNameSupplier)scoutApi.IPageWithTable());
    }

    protected void updatePageDatas(IEnvironment env, IProgress progress) {
        if (this.isCreateAbstractPage()) {
            this.getCreatedAbstractPageData().result();
            Optional<ICompilationUnitGenerator<?>> abstractPageDataGenerator = DtoGeneratorFactory.createPageDataGenerator(this.getCreatedAbstractPage().result(), this.getPageDataSourceFolder().javaEnvironment());
            env.writeCompilationUnitAsync(abstractPageDataGenerator.orElseThrow(), this.getPageDataSourceFolder(), progress.newChild(1));
        }
        this.getCreatedPageData().result();
        Optional<ICompilationUnitGenerator<?>> pageDataGenerator = DtoGeneratorFactory.createPageDataGenerator(this.getCreatedPage().result(), this.getPageDataSourceFolder().javaEnvironment());
        env.writeCompilationUnitAsync(pageDataGenerator.orElseThrow(), this.getPageDataSourceFolder(), progress.newChild(1));
    }

    protected IFuture<IType> createAbstractPage(boolean isPageWithTable, IEnvironment env, IProgress progress) {
        PageGenerator<?> pageBuilder = this.createPageBuilder(isPageWithTable, true);
        this.setCreatedAbstractPageFqn(pageBuilder.fullyQualifiedName());
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)pageBuilder, this.getClientSourceFolder(), progress);
    }

    protected String getBaseName() {
        return (String)this.m_baseName.computeIfAbsentAndGet(this::calcPageBaseName);
    }

    protected String calcPageBaseName() {
        String[] suffixes;
        String name = this.getPageName();
        for (String suffix : suffixes = new String[]{"NodePage", "TablePage", "Page"}) {
            name = Strings.removeSuffix((String)name, (CharSequence)suffix, (boolean)false);
        }
        return name;
    }

    public String getServiceBaseName() {
        return this.getBaseName();
    }

    protected String getServiceMethodName() {
        String name = this.getBaseName();
        return "get" + name + "TableData";
    }

    protected void createOrAppendService(String sharedPackage, IEnvironment env, IProgress progress) {
        if (this.isCreateService()) {
            this.createService(sharedPackage, this.getServiceBaseName(), env, progress.newChild(3));
        } else if (this.isAppendService()) {
            ServiceNewOperation op = this.getServiceNewOperation();
            this.addServiceMethods(op);
            String svcName = op.getServiceName() + "Service";
            String serverPackage = ScoutTier.Shared.convert(ScoutTier.Server, op.getSharedPackage());
            this.setServiceIfcFqn(sharedPackage + ".I" + svcName);
            this.setServiceImplFqn(serverPackage + "." + svcName);
            if (op.isCreateTest()) {
                this.setServiceTestFqn(this.getServiceImplFqn() + "Test");
            }
        }
    }

    protected void createService(String sharedPackage, String baseName, IEnvironment env, IProgress progress) {
        ServiceNewOperation serviceNewOperation = this.createServiceOperation();
        this.prepareServiceOperation(serviceNewOperation, sharedPackage, baseName);
        this.addServiceMethods(serviceNewOperation);
        serviceNewOperation.accept(env, progress);
        this.setCreatedServiceImpl(serviceNewOperation.getCreatedServiceImpl());
        this.setServiceImplFqn(serviceNewOperation.getCreatedServiceImplFqn());
        this.setCreatedServiceIfc(serviceNewOperation.getCreatedServiceInterface());
        this.setServiceIfcFqn(serviceNewOperation.getCreatedServiceInterfaceFqn());
        this.setCreatedServiceTest(serviceNewOperation.getCreatedServiceTest());
        this.setServiceTestFqn(serviceNewOperation.getCreatedServiceTestFqn());
    }

    protected void addServiceMethods(ServiceNewOperation serviceNewOperation) {
        serviceNewOperation.addMethod(this.createServiceMethod());
    }

    protected IMethodGenerator<?, ?> createServiceMethod() {
        this.setDataFetchMethodName(this.getServiceMethodName());
        return ((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().asPublic()).withFlags(512)).withReturnType(this.getCreatedPageDataFqn()).withElementName(this.getDataFetchMethodName())).withParameter(((IMethodParameterGenerator)MethodParameterGenerator.create().withElementName("filter")).withDataTypeFrom(IScoutApi.class, api -> api.SearchFilter().fqn())).withComment(IJavaElementCommentBuilder::appendDefaultElementComment)).withBody(b -> {
            String varName = "pageData";
            ((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)b.ref((CharSequence)this.getCreatedPageDataFqn())).space()).append(varName)).equalSign()).appendNew((CharSequence)this.getCreatedPageDataFqn())).parenthesisClose()).semicolon()).nl()).appendTodo((CharSequence)("fill " + varName + "."))).returnClause().append(varName)).semicolon();
        });
    }

    protected ServiceNewOperation createServiceOperation() {
        return new ServiceNewOperation();
    }

    protected void prepareServiceOperation(ServiceNewOperation serviceNewOperation, String sharedPackage, String baseName) {
        serviceNewOperation.setServiceName(baseName);
        serviceNewOperation.setSharedPackage(sharedPackage);
        serviceNewOperation.setSharedSourceFolder(this.getSharedSourceFolder());
        serviceNewOperation.setServerSourceFolder(this.getServerSourceFolder());
        if (this.getTestSourceFolder() == null) {
            return;
        }
        serviceNewOperation.setTestSourceFolder(this.getTestSourceFolder());
        serviceNewOperation.setServerSession(this.getServerSession());
        serviceNewOperation.setCreateTest(true);
    }

    protected PageGenerator<?> createPageBuilder(boolean isPageWithTable, boolean isAbstractPage) {
        PageGenerator<?> generator = this.createPageGenerator();
        this.preparePageGenerator(generator, isPageWithTable, isAbstractPage);
        return generator;
    }

    protected PageGenerator<?> createPageGenerator() {
        return new PageGenerator();
    }

    protected void preparePageGenerator(PageGenerator<?> generator, boolean isPageWithTable, boolean isAbstractPage) {
        Object name = this.getPageName();
        if (isAbstractPage) {
            name = "Abstract" + (String)name;
        }
        String fqn = this.getPackage() + "." + (String)name;
        ((PageGenerator)((Object)((PageGenerator)((Object)((PageGenerator)((Object)((PageGenerator)((Object)((PageGenerator)((Object)((PageGenerator)((PageGenerator)((PageGenerator)generator.withElementName((String)name)).withPackageName(this.getPackage())).withFlags(isAbstractPage ? 1024 : 1)).withNlsMethod(this.isCreateAbstractPage() == isAbstractPage))).withLeafMethod(isPageWithTable && this.isCreateAbstractPage() == isAbstractPage))).withClassIdValue(ClassIds.nextIfEnabled(fqn)))).withTableClassIdValue(ClassIds.nextIfEnabled(fqn)))).withDataFetchMethodName(this.getDataFetchMethodName()))).asPageWithTable(isPageWithTable).withSuperClass(this.getSuperType());
        String dtoFqn = this.getCreatedPageDataFqn();
        if (isAbstractPage) {
            dtoFqn = this.getCreatedAbstractPageDataFqn();
        }
        generator.withPageData(dtoFqn);
        if (!isAbstractPage && Strings.hasText((CharSequence)this.getServiceIfcFqn())) {
            generator.withPageServiceInterface(this.getServiceIfcFqn());
        }
    }

    protected IFuture<IType> createPage(boolean isPageWithTable, IEnvironment env, IProgress progress) {
        PageGenerator<?> pageBuilder = this.createPageBuilder(isPageWithTable, false);
        if (this.isCreateAbstractPage() && isPageWithTable) {
            String superTypeFqn = this.getCreatedAbstractPageFqn() + "<" + pageBuilder.fullyQualifiedName() + "$Table>.Table";
            pageBuilder.withTableSuperType(superTypeFqn);
        }
        this.setCreatedPageFqn(pageBuilder.fullyQualifiedName());
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)pageBuilder, this.getClientSourceFolder(), progress);
    }

    protected IFuture<IType> createPageData(String pageName, String sharedPackage, Consumer<String> fqnConsumer, IEnvironment env, IProgress progress) {
        PrimaryTypeGenerator pageDataGenerator = PrimaryTypeGenerator.create().withElementName(pageName + "Data").withPackageName(sharedPackage).asPublic().withSuperClassFrom(IScoutApi.class, api -> api.AbstractTablePageData().fqn());
        if (fqnConsumer != null) {
            fqnConsumer.accept(pageDataGenerator.fullyQualifiedName());
        }
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)pageDataGenerator, this.getPageDataSourceFolder(), progress);
    }

    public IFuture<IType> getCreatedPage() {
        return this.m_createdPage;
    }

    protected void setCreatedPage(IFuture<IType> page) {
        this.m_createdPage = page;
    }

    public String getCreatedPageFqn() {
        return this.m_createdPageFqn;
    }

    protected void setCreatedPageFqn(String createdPageFqn) {
        this.m_createdPageFqn = createdPageFqn;
    }

    public String getPageName() {
        return this.m_pageName;
    }

    public void setPageName(String pageName) {
        this.m_baseName = new FinalValue();
        this.m_pageName = pageName;
    }

    public IClasspathEntry getClientSourceFolder() {
        return this.m_clientSourceFolder;
    }

    public void setClientSourceFolder(IClasspathEntry clientSourceFolder) {
        this.m_clientSourceFolder = clientSourceFolder;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public String getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(String superType) {
        this.m_superType = superType;
    }

    public IClasspathEntry getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IClasspathEntry sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public IFuture<IType> getCreatedPageData() {
        return this.m_createdPageData;
    }

    protected void setCreatedPageData(IFuture<IType> createdPageData) {
        this.m_createdPageData = createdPageData;
    }

    public String getCreatedPageDataFqn() {
        return this.m_createdPageDataFqn;
    }

    protected void setCreatedPageDataFqn(String createdPageDataFqn) {
        this.m_createdPageDataFqn = createdPageDataFqn;
    }

    public IClasspathEntry getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IClasspathEntry serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    public IFuture<IType> getCreatedServiceIfc() {
        return this.m_createdServiceIfc;
    }

    protected void setCreatedServiceIfc(IFuture<IType> createdServiceIfc) {
        this.m_createdServiceIfc = createdServiceIfc;
    }

    public String getServiceIfcFqn() {
        return this.m_serviceIfcFqn;
    }

    protected void setServiceIfcFqn(String serviceIfcFqn) {
        this.m_serviceIfcFqn = serviceIfcFqn;
    }

    public IFuture<IType> getCreatedServiceImpl() {
        return this.m_createdServiceImpl;
    }

    protected void setCreatedServiceImpl(IFuture<IType> createdServiceImpl) {
        this.m_createdServiceImpl = createdServiceImpl;
    }

    public String getServiceImplFqn() {
        return this.m_serviceImplFqn;
    }

    protected void setServiceImplFqn(String serviceImplFqn) {
        this.m_serviceImplFqn = serviceImplFqn;
    }

    public IClasspathEntry getPageDataSourceFolder() {
        return this.m_pageDataSourceFolder;
    }

    public void setPageDataSourceFolder(IClasspathEntry pageDataSourceFolder) {
        this.m_pageDataSourceFolder = pageDataSourceFolder;
    }

    public IClasspathEntry getTestSourceFolder() {
        return this.m_testSourceFolder;
    }

    public void setTestSourceFolder(IClasspathEntry testSourceFolder) {
        this.m_testSourceFolder = testSourceFolder;
    }

    public IFuture<IType> getCreatedServiceTest() {
        return this.m_createdServiceTest;
    }

    protected void setCreatedServiceTest(IFuture<IType> createdServiceTest) {
        this.m_createdServiceTest = createdServiceTest;
    }

    public String getServiceTestFqn() {
        return this.m_serviceTestFqn;
    }

    protected void setServiceTestFqn(String serviceTestFqn) {
        this.m_serviceTestFqn = serviceTestFqn;
    }

    protected String getDataFetchMethodName() {
        return this.m_dataFetchMethodName;
    }

    protected void setDataFetchMethodName(String dataFetchMethodName) {
        this.m_dataFetchMethodName = dataFetchMethodName;
    }

    public boolean isCreateAbstractPage() {
        return this.m_createAbstractPage;
    }

    public void setCreateAbstractPage(boolean createAbstractPage) {
        this.m_createAbstractPage = createAbstractPage;
    }

    public boolean isPageWithTable() {
        return this.m_pageWithTable;
    }

    protected void setPageWithTable(boolean pageWithTable) {
        this.m_pageWithTable = pageWithTable;
    }

    public boolean isCreatePageData() {
        return this.m_createPageData;
    }

    protected void setCreatePageData(boolean createPageData) {
        this.m_createPageData = createPageData;
    }

    public boolean isCreateOrAppendService() {
        return this.m_createOrAppendService;
    }

    protected void setCreateOrAppendService(boolean createOrAppendService) {
        this.m_createOrAppendService = createOrAppendService;
    }

    public boolean isCreateService() {
        return this.isCreateOrAppendService() && this.getServiceNewOperation() == null;
    }

    public boolean isAppendService() {
        return this.isCreateOrAppendService() && this.getServiceNewOperation() != null;
    }

    public ServiceNewOperation getServiceNewOperation() {
        return this.m_serviceNewOperation;
    }

    public void setServiceNewOperation(ServiceNewOperation serviceNewOperation) {
        this.m_serviceNewOperation = serviceNewOperation;
    }

    public IFuture<IType> getCreatedAbstractPage() {
        return this.m_createdAbstractPage;
    }

    protected void setCreatedAbstractPage(IFuture<IType> createdAbstractPage) {
        this.m_createdAbstractPage = createdAbstractPage;
    }

    public String getCreatedAbstractPageFqn() {
        return this.m_createdAbstractPageFqn;
    }

    protected void setCreatedAbstractPageFqn(String createdAbstractPageFqn) {
        this.m_createdAbstractPageFqn = createdAbstractPageFqn;
    }

    public IFuture<IType> getCreatedAbstractPageData() {
        return this.m_createdAbstractPageData;
    }

    protected void setCreatedAbstractPageData(IFuture<IType> createdAbstractPageData) {
        this.m_createdAbstractPageData = createdAbstractPageData;
    }

    public String getCreatedAbstractPageDataFqn() {
        return this.m_createdAbstractPageDataFqn;
    }

    protected void setCreatedAbstractPageDataFqn(String createdAbstractPageDataFqn) {
        this.m_createdAbstractPageDataFqn = createdAbstractPageDataFqn;
    }

    public String getServerSession() {
        return this.m_serverSession;
    }

    public void setServerSession(String serverSession) {
        this.m_serverSession = serverSession;
    }

    public String toString() {
        return "Create new Page";
    }
}

