/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.manager.IStackedTranslation;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.core.util.Strings;

public final class TranslationValidator {
    public static final int OK = 0;
    public static final int KEY_OVERRIDES_OTHER_STORE_WARNING = 100;
    public static final int KEY_IS_OVERRIDDEN_BY_OTHER_STORE_WARNING = 200;
    public static final int KEY_OVERRIDES_AND_IS_OVERRIDDEN_WARNING = 300;
    public static final int TEXT_INHERITED_BECOMES_ACTIVE_IF_REMOVED_WARNING = 400;
    public static final int KEY_ALREADY_EXISTS_ERROR = 40000;
    public static final int DEFAULT_TRANSLATION_MISSING_ERROR = 50000;
    public static final int KEY_EMPTY_ERROR = 70000;
    public static final int KEY_INVALID_ERROR = 80000;

    private TranslationValidator() {
    }

    public static int validateDefaultText(CharSequence newText, IStackedTranslation current) {
        if (Strings.hasText((CharSequence)newText)) {
            return 0;
        }
        if (TranslationValidator.isOverriding(current, Language.LANGUAGE_DEFAULT)) {
            return 400;
        }
        return 50000;
    }

    public static int validateText(CharSequence newText, IStackedTranslation current, Language language) {
        if (Strings.hasText((CharSequence)newText)) {
            return 0;
        }
        if (TranslationValidator.isOverriding(current, language)) {
            return 400;
        }
        return 0;
    }

    private static boolean isOverriding(IStackedTranslation current, Language language) {
        if (current == null || language == null) {
            return false;
        }
        return current.entry(language).map(ITranslationEntry::store).filter(s -> current.isOverriding(language, (ITranslationStore)s)).isPresent();
    }

    public static boolean isForbidden(int result) {
        return result != 0 && result != 100 && result != 200 && result != 300 && result != 400;
    }

    public static int validateKey(String keyToValidate) {
        return TranslationValidator.validateKey(null, null, keyToValidate, Collections.singleton(keyToValidate));
    }

    public static int validateKey(TranslationManager manager, ITranslationStore target, String keyToValidate) {
        return TranslationValidator.validateKey(manager, target, keyToValidate, null);
    }

    public static int validateKey(TranslationManager manager, ITranslationStore target, String keyToValidate, Collection<String> acceptedKeys) {
        if (Strings.isBlank((CharSequence)keyToValidate)) {
            return 70000;
        }
        if (!ITranslation.KEY_REGEX.matcher(keyToValidate).matches()) {
            return 80000;
        }
        if (acceptedKeys != null && acceptedKeys.contains(keyToValidate)) {
            return 0;
        }
        if (target.containsKey(keyToValidate)) {
            return 40000;
        }
        boolean hasStoresWithKeyOverridden = manager.allStores().filter(store -> store.containsKey(keyToValidate)).anyMatch(store -> store.service().order() > target.service().order());
        boolean hasStoresOverridingKey = manager.allStores().filter(store -> store.containsKey(keyToValidate)).anyMatch(store -> store.service().order() < target.service().order());
        if (hasStoresWithKeyOverridden && hasStoresOverridingKey) {
            return 300;
        }
        if (hasStoresWithKeyOverridden) {
            return 100;
        }
        if (hasStoresOverridingKey) {
            return 200;
        }
        return 0;
    }
}

