/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;

public class NlsFile {
    public static final String NLS_CLASS_KEY_NAME = "Nls-Class";
    private final Path m_file;
    private final FinalValue<Optional<String>> m_nlsClass = new FinalValue();

    public NlsFile(Path file) {
        this.m_file = (Path)Ensure.notNull((Object)file);
    }

    public Optional<String> nlsClassFqn() {
        return (Optional)this.m_nlsClass.computeIfAbsentAndGet(this::parseNlsClass);
    }

    protected Optional<String> parseNlsClass() {
        Properties properties = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(this.path(), new OpenOption[0]));){
            properties.load(in);
        }
        catch (IOException e) {
            throw new SdkException((CharSequence)"Unable to read nls file '{}'.", new Object[]{this.path(), e});
        }
        String nlsClass = properties.getProperty(NLS_CLASS_KEY_NAME);
        if (nlsClass != null) {
            nlsClass = Strings.trim((CharSequence)nlsClass).toString();
        }
        return Strings.notBlank((CharSequence)nlsClass);
    }

    public Path path() {
        return this.m_file;
    }

    public Optional<ITranslationStore> findMatchingStoreIn(TranslationManager manager) {
        return this.nlsClassFqn().flatMap(fqn -> Optional.ofNullable(manager).map(TranslationManager::allStores).flatMap(stores -> stores.filter(store -> store.service().type().name().equals(fqn)).findAny()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NlsFile nlsFile = (NlsFile)o;
        return this.m_file.equals(nlsFile.m_file);
    }

    public int hashCode() {
        return Objects.hash(this.m_file);
    }

    public String toString() {
        return new StringJoiner(", ", NlsFile.class.getSimpleName() + " [", "]").add("file=" + this.m_file).toString();
    }
}

