/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.builder.java.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.builder.java.JavaBuilderContext;
import org.eclipse.scout.sdk.core.builder.java.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.apidef.IScoutAbstractApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutAnnotationApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.transformer.SimpleWorkingCopyTransformerBuilder;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebServiceUpdateOperation
implements BiConsumer<IEnvironment, IProgress> {
    private String m_package;
    private final Collection<Path> m_jaxwsBindingFiles = new ArrayList<Path>();
    private final Collection<BindingClassUpdate> m_bindingClassUpdates = new ArrayList<BindingClassUpdate>();
    private final Collection<EntryPointDefinitionUpdate> m_entryPointDefinitionUpdates = new ArrayList<EntryPointDefinitionUpdate>();
    private final Collection<WebServiceClientUpdate> m_webServiceClientUpdates = new ArrayList<WebServiceClientUpdate>();
    private final Collection<WebServiceImplementationUpdate> m_webServiceImplUpdates = new ArrayList<WebServiceImplementationUpdate>();

    @Override
    public void accept(IEnvironment env, IProgress progress) {
        progress.init(40, this.toString(), new Object[0]);
        this.updateJaxWsBinding(env, progress.newChild(10));
        this.updateWebServiceImpls(env, progress.newChild(10));
        this.updateEntryPointDefinitions(env, progress.newChild(10));
        this.updateWebServiceClients(env, progress.newChild(10));
    }

    protected void updateWebServiceImpls(IEnvironment env, IProgress progress) {
        if (this.m_webServiceImplUpdates.isEmpty()) {
            return;
        }
        for (WebServiceImplementationUpdate up : this.m_webServiceImplUpdates) {
            ICompilationUnit wsImpl = up.getWebServiceImpl().requireCompilationUnit();
            ICompilationUnitGenerator generator = wsImpl.toWorkingCopy();
            JavaBuilderContext builderContext = new JavaBuilderContext(wsImpl.javaEnvironment());
            generator.mainType().ifPresent(mainType -> {
                mainType.interfacesFunc().map(af -> (String)af.apply((IJavaBuilderContext)builderContext)).filter(Strings::hasText).forEach(arg_0 -> ((ICompilationUnitGenerator)generator).withoutImport(arg_0));
                WebServiceUpdateOperation.removePortTypeSuperInterfaces(mainType, (IJavaBuilderContext)builderContext);
                String newPortTypeFqn = up.getPackage() + "." + up.getPortTypeName();
                mainType.withInterface(newPortTypeFqn);
            });
            WebServiceUpdateOperation.updateWsdlFaults(generator, up.getPackage(), (IJavaBuilderContext)builderContext);
            env.writeCompilationUnit(generator, up.getSourceFolder(), progress);
        }
    }

    protected static void updateWsdlFaults(ICompilationUnitGenerator<?> icuBuilder, String newPackage, IJavaBuilderContext context) {
        icuBuilder.mainType().ifPresent(t -> t.methods().forEach(methodBuilder -> {
            List<ITypeNameSupplier> exceptions = methodBuilder.throwablesFunc().map(func -> (ITypeNameSupplier)func.apply(context)).filter(Objects::nonNull).toList();
            methodBuilder.withoutThrowable(element -> true);
            for (ITypeNameSupplier exc : exceptions) {
                methodBuilder.withThrowable(newPackage + "." + exc.simpleName());
                icuBuilder.withoutImport((CharSequence)exc.fqn());
            }
        }));
    }

    protected void updateWebServiceClients(IEnvironment env, IProgress progress) {
        if (this.m_webServiceClientUpdates.isEmpty()) {
            return;
        }
        for (WebServiceClientUpdate up : this.m_webServiceClientUpdates) {
            ICompilationUnit wsClient = up.getWebServiceClient().requireCompilationUnit();
            ICompilationUnitGenerator generator = wsClient.toWorkingCopy();
            JavaBuilderContext builderContext = new JavaBuilderContext(wsClient.javaEnvironment());
            generator.mainType().ifPresent(mainType -> {
                for (String oldImport : JavaTypes.typeArguments((CharSequence)mainType.superClassFunc().map(af -> (String)af.apply((IJavaBuilderContext)builderContext)).orElseThrow())) {
                    generator.withoutImport((CharSequence)oldImport);
                }
                WebServiceUpdateOperation.removePortTypeSuperInterfaces(mainType, (IJavaBuilderContext)builderContext);
                String newPortTypeFqn = up.getPackage() + "." + up.getPortTypeName();
                String newWebServiceFqn = up.getPackage() + "." + up.getWebServiceName();
                mainType.withInterface(newPortTypeFqn).withSuperClassFrom(IScoutApi.class, api -> WebServiceUpdateOperation.buildWebServiceClientSuperClass(api, newPortTypeFqn, newWebServiceFqn));
            });
            WebServiceUpdateOperation.updateWsdlFaults(generator, up.getPackage(), (IJavaBuilderContext)builderContext);
            env.writeCompilationUnit(generator, up.getSourceFolder(), progress);
        }
    }

    protected static String buildWebServiceClientSuperClass(IScoutAbstractApi api, String newPortTypeFqn, String newWebServiceFqn) {
        StringBuilder superTypeFqnBuilder = new StringBuilder(api.AbstractWebServiceClient().fqn());
        superTypeFqnBuilder.append('<').append(newWebServiceFqn).append(", ").append(newPortTypeFqn).append('>');
        return superTypeFqnBuilder.toString();
    }

    protected static void removePortTypeSuperInterfaces(ITypeGenerator<?> generator, IJavaBuilderContext context) {
        generator.withoutInterface(ifc -> Strings.notEmpty((CharSequence)((String)ifc.apply(context))).filter(ref -> ref.endsWith("PortType")).isPresent());
    }

    protected void updateJaxWsBinding(IEnvironment env, IProgress progress) {
        Collection<Path> jaxwsBindingFiles = this.getJaxwsBindingFiles();
        if (jaxwsBindingFiles.isEmpty()) {
            return;
        }
        progress.init(jaxwsBindingFiles.size() * 2, "Update Jax-Ws Bindings", new Object[0]);
        try {
            for (Path jaxwsBindingFile : jaxwsBindingFiles) {
                Document document = Xml.get((Path)jaxwsBindingFile);
                String prefix = document.lookupPrefix("http://java.sun.com/xml/ns/jaxws");
                for (BindingClassUpdate up : this.m_bindingClassUpdates) {
                    Element nodeElement = JaxWsUtils.getJaxWsBindingElement(up.getNodeValue(), document);
                    Xml.firstChildElement((Node)nodeElement, (String)"class").ifPresent(e -> e.setAttribute("name", up.getClassName()));
                }
                Element packageElement = JaxWsUtils.getJaxWsBindingElement("wsdl:definitions", document);
                if (packageElement == null) {
                    packageElement = document.createElement(prefix + ":bindings");
                    packageElement.setAttribute("node", "wsdl:definitions");
                    document.getDocumentElement().appendChild(packageElement);
                }
                Element packageNameElement = Xml.firstChildElement((Node)packageElement, (String)"package").orElseGet(() -> {
                    Element e = document.createElement(prefix + ":package");
                    e.appendChild(e);
                    return e;
                });
                packageNameElement.setAttribute("name", this.getPackage());
                progress.worked(1);
                env.writeResource(Xml.writeDocument((Document)document, (boolean)true), jaxwsBindingFile, progress.newChild(1));
            }
        }
        catch (IOException | TransformerException | XPathExpressionException e2) {
            throw new SdkException((Throwable)e2);
        }
    }

    protected void updateEntryPointDefinitions(IEnvironment env, IProgress progress) {
        for (EntryPointDefinitionUpdate up : this.m_entryPointDefinitionUpdates) {
            IType entryPointDefinition = up.getEntryPointDefinition();
            if (entryPointDefinition == null) continue;
            IScoutApi scoutApi = (IScoutApi)entryPointDefinition.javaEnvironment().requireApi(IScoutApi.class);
            ICompilationUnit definition = entryPointDefinition.requireCompilationUnit();
            IWorkingCopyTransformer transformer = new SimpleWorkingCopyTransformerBuilder().withAnnotationElementMapper(input -> WebServiceUpdateOperation.rewriteEntryPointDefAnnotationElements(input, scoutApi, up)).build();
            ICompilationUnitGenerator builder = definition.toWorkingCopy(transformer);
            env.writeCompilationUnit(builder, up.getSourceFolder(), progress);
        }
    }

    protected static ISourceGenerator<IExpressionBuilder<?>> rewriteEntryPointDefAnnotationElements(IWorkingCopyTransformer.ITransformInput<IAnnotationElement, ISourceGenerator<IExpressionBuilder<?>>> input, IScoutAnnotationApi scoutApi, EntryPointDefinitionUpdate up) {
        if (scoutApi.WebServiceEntryPoint().fqn().equals(((IAnnotationElement)input.model()).declaringAnnotation().name())) {
            if (scoutApi.WebServiceEntryPoint().endpointInterfaceElementName().equals(((IAnnotationElement)input.model()).elementName())) {
                String newPortTypeFqn = up.getPortTypePackage() + "." + up.getPortTypeName();
                return b -> b.classLiteral((CharSequence)newPortTypeFqn);
            }
            if (scoutApi.WebServiceEntryPoint().entryPointNameElementName().equals(((IAnnotationElement)input.model()).elementName())) {
                return b -> b.stringLiteral((CharSequence)up.getEntryPointName());
            }
            if (scoutApi.WebServiceEntryPoint().entryPointPackageElementName().equals(((IAnnotationElement)input.model()).elementName())) {
                return b -> b.stringLiteral((CharSequence)up.getEntryPointPackage());
            }
        }
        return (ISourceGenerator)input.requestDefaultWorkingCopy();
    }

    public Collection<Path> getJaxwsBindingFiles() {
        return Collections.unmodifiableCollection(this.m_jaxwsBindingFiles);
    }

    public void setJaxwsBindingFiles(Collection<? extends Path> files) {
        this.m_jaxwsBindingFiles.addAll(files);
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public void addWebServiceImplementationUpdate(WebServiceImplementationUpdate up) {
        this.m_webServiceImplUpdates.add(up);
    }

    public void addBindingClassUpdate(BindingClassUpdate up) {
        this.m_bindingClassUpdates.add(up);
    }

    public void addEntryPointDefinitionUpdate(EntryPointDefinitionUpdate up) {
        this.m_entryPointDefinitionUpdates.add(up);
    }

    public void addWebServiceClientUpdate(WebServiceClientUpdate up) {
        this.m_webServiceClientUpdates.add(up);
    }

    public String toString() {
        return "Update Web Service";
    }

    public static class WebServiceImplementationUpdate {
        private final IType m_webServiceImpl;
        private final String m_package;
        private final String m_portTypeName;
        private final IClasspathEntry m_sourceFolder;

        public WebServiceImplementationUpdate(IType webServiceImpl, String package1, String portTypeName, IClasspathEntry sourceFolder) {
            this.m_webServiceImpl = webServiceImpl;
            this.m_package = package1;
            this.m_portTypeName = portTypeName;
            this.m_sourceFolder = sourceFolder;
        }

        public IType getWebServiceImpl() {
            return this.m_webServiceImpl;
        }

        public String getPackage() {
            return this.m_package;
        }

        public String getPortTypeName() {
            return this.m_portTypeName;
        }

        public IClasspathEntry getSourceFolder() {
            return this.m_sourceFolder;
        }
    }

    public static class WebServiceClientUpdate {
        private final IType m_webServiceClient;
        private final String m_package;
        private final String m_portTypeName;
        private final String m_webServiceName;
        private final IClasspathEntry m_sourceFolder;

        public WebServiceClientUpdate(IType webServiceClient, String pck, String portTypeName, String webServiceName, IClasspathEntry sourceFolder) {
            this.m_webServiceClient = webServiceClient;
            this.m_package = pck;
            this.m_portTypeName = portTypeName;
            this.m_webServiceName = webServiceName;
            this.m_sourceFolder = sourceFolder;
        }

        public IType getWebServiceClient() {
            return this.m_webServiceClient;
        }

        public String getPackage() {
            return this.m_package;
        }

        public String getPortTypeName() {
            return this.m_portTypeName;
        }

        public String getWebServiceName() {
            return this.m_webServiceName;
        }

        public IClasspathEntry getSourceFolder() {
            return this.m_sourceFolder;
        }
    }

    public static class BindingClassUpdate {
        private String m_nodeValue;
        private String m_className;

        public BindingClassUpdate(String nodeValue, String className) {
            this.m_nodeValue = nodeValue;
            this.m_className = className;
        }

        public String getNodeValue() {
            return this.m_nodeValue;
        }

        public void setNodeValue(String nodeValue) {
            this.m_nodeValue = nodeValue;
        }

        public String getClassName() {
            return this.m_className;
        }

        public void setClassName(String className) {
            this.m_className = className;
        }
    }

    public static class EntryPointDefinitionUpdate {
        private final IType m_entryPointDefinition;
        private final String m_entryPointPackage;
        private final String m_entryPointName;
        private final String m_portTypeName;
        private final String m_portTypePackage;
        private final IClasspathEntry m_sourceFolder;

        public EntryPointDefinitionUpdate(IType entryPointDefinitions, String entryPointPackage, String entryPointName, String portTypeName, String portTypePackage, IClasspathEntry sourceFolder) {
            this.m_entryPointDefinition = entryPointDefinitions;
            this.m_entryPointPackage = entryPointPackage;
            this.m_entryPointName = entryPointName;
            this.m_portTypeName = portTypeName;
            this.m_portTypePackage = portTypePackage;
            this.m_sourceFolder = sourceFolder;
        }

        public IType getEntryPointDefinition() {
            return this.m_entryPointDefinition;
        }

        public String getEntryPointPackage() {
            return this.m_entryPointPackage;
        }

        public String getEntryPointName() {
            return this.m_entryPointName;
        }

        public String getPortTypeName() {
            return this.m_portTypeName;
        }

        public String getPortTypePackage() {
            return this.m_portTypePackage;
        }

        public IClasspathEntry getSourceFolder() {
            return this.m_sourceFolder;
        }
    }
}

