/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.scout.sdk.core.s.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JaxWsUtils {
    public static final String WSDL_FILE_SUFFIX = ".wsdl";
    public static final String BINDINGS_NAME_ATTRIBUTE = "name";
    public static final String BINDINGS_CLASS_ELEMENT_NAME = "class";
    public static final String BINDING_PACKAGE_ELEMENT_NAME = "package";
    public static final String BINDINGS_NODE_ATTRIBUTE_NAME = "node";
    public static final String JAX_WS_NAMESPACE = "http://java.sun.com/xml/ns/jaxws";
    public static final String JAX_B_NAMESPACE = "http://java.sun.com/xml/ns/jaxb";
    public static final String BINDINGS_ELEMENT_NAME = "bindings";
    public static final String GENERATE_ELEMENT_ATTRIBUTE_NAME = "generateElementProperty";
    public static final String GLOBAL_BINDINGS_ELEMENT_NAME = "globalBindings";
    public static final String MODULE_REL_WEB_INF_FOLDER_PATH = "src/main/resources/WEB-INF";
    public static final String BINDING_FILE_ELEMENT_NAME = "bindingFile";
    public static final String BINDING_FILES_ELEMENT_NAME = "bindingFiles";
    public static final String WSDL_FILE_ELEMENT_NAME = "wsdlFile";
    public static final String WSDL_FILES_ELEMENT_NAME = "wsdlFiles";
    public static final String WSDL_LOCATION = "wsdlLocation";
    public static final String GLOBAL_BINDINGS_FILE_NAME = "global-binding.xml";
    public static final String JAXB_BINDINGS_FILE_NAME = "jaxb-binding.xml";
    public static final String JAXWS_BINDINGS_FILE_NAME = "jaxws-binding.xml";
    public static final String WSDL_FOLDER_NAME = "wsdl";
    public static final String BINDING_FOLDER_NAME = "binding";
    public static final String WS_IMPORT_TOOL_NAME = "wsimport";
    public static final String JAXWS_MAVEN_PLUGIN_ARTIFACT_ID = "jaxws-maven-plugin";
    public static final String PACKAGE_XPATH = "wsdl:definitions";
    private static final String WEB_SERVICE_XPATH_START = "wsdl:definitions/wsdl:service[@name='";
    private static final String PORT_TYPE_XPATH_START = "wsdl:definitions/wsdl:portType[@name='";
    private static final String XPATH_END = "']";

    private JaxWsUtils() {
    }

    public static boolean isWsdlFile(Path p) {
        if (p == null) {
            return false;
        }
        Path fileName = p.getFileName();
        if (fileName == null || !Strings.endsWith((CharSequence)fileName.toString(), (CharSequence)WSDL_FILE_SUFFIX, (boolean)false)) {
            return false;
        }
        return Files.isRegularFile(p, new LinkOption[0]) && Files.isReadable(p);
    }

    public static String getWebServiceXPath(String webServiceNameInWsdl) {
        return WEB_SERVICE_XPATH_START + webServiceNameInWsdl + XPATH_END;
    }

    public static String getPortTypeXPath(String portTypeNameInWsdl) {
        return PORT_TYPE_XPATH_START + portTypeNameInWsdl + XPATH_END;
    }

    public static void addWsdlToPom(Document pomDocument, String wsdlFileName, String bindingFolderName, Iterable<String> bindingFileNames, IScoutVariousApi api) {
        Element root = pomDocument.getDocumentElement();
        Element executions = JaxWsUtils.getExecutionsElement(root, api);
        String nextId = JaxWsUtils.getNextExecutionId(executions);
        Element newExecution = root.getOwnerDocument().createElement("execution");
        Element idElement = JaxWsUtils.getOrCreateElement(newExecution, "id");
        idElement.setTextContent(nextId);
        Element goalsElement = JaxWsUtils.getOrCreateElement(newExecution, "goals");
        Element goalElement = JaxWsUtils.getOrCreateElement(goalsElement, "goal");
        goalElement.setTextContent(WS_IMPORT_TOOL_NAME);
        Element configurationElement = JaxWsUtils.getOrCreateElement(newExecution, "configuration");
        Element wsdlLocationElement = JaxWsUtils.getOrCreateElement(configurationElement, WSDL_LOCATION);
        wsdlLocationElement.setTextContent("WEB-INF/wsdl/" + wsdlFileName);
        Element wsdlFilesElement = JaxWsUtils.getOrCreateElement(configurationElement, WSDL_FILES_ELEMENT_NAME);
        Element wsdlFileElement = JaxWsUtils.getOrCreateElement(wsdlFilesElement, WSDL_FILE_ELEMENT_NAME);
        wsdlFileElement.setTextContent(wsdlFileName);
        Element bindingFilesElement = JaxWsUtils.getOrCreateElement(configurationElement, BINDING_FILES_ELEMENT_NAME);
        Element globalBindingFileElement = root.getOwnerDocument().createElement(BINDING_FILE_ELEMENT_NAME);
        globalBindingFileElement.setTextContent(GLOBAL_BINDINGS_FILE_NAME);
        bindingFilesElement.appendChild(globalBindingFileElement);
        for (String fileName : bindingFileNames) {
            Element bindingFileElement = root.getOwnerDocument().createElement(BINDING_FILE_ELEMENT_NAME);
            bindingFileElement.setTextContent(bindingFolderName + "/" + fileName);
            bindingFilesElement.appendChild(bindingFileElement);
        }
        executions.appendChild(newExecution);
    }

    public static List<String> getBindingPathsFromPom(Node pom, String wsdlFileName, IScoutVariousApi api) throws XPathExpressionException {
        if (wsdlFileName.indexOf(39) >= 0) {
            throw new IllegalArgumentException("apos character (') is not allowed in a WSDL file name.");
        }
        String prefix = "p";
        String p = prefix + ":";
        String lc = wsdlFileName.toLowerCase(Locale.US);
        String uc = wsdlFileName.toUpperCase(Locale.US);
        StringBuilder bindingFilesXPathBuilder = JaxWsUtils.getJaxWsMavenPluginXPath(p, api).append('/').append(p).append("executions").append('/').append(p).append("execution").append('/').append(p).append("configuration").append("[translate(./").append(p).append(WSDL_FILES_ELEMENT_NAME).append('/').append(p).append(WSDL_FILE_ELEMENT_NAME).append(", '").append(uc).append("', '").append(lc).append("')='").append(lc).append("']/").append(p).append(BINDING_FILES_ELEMENT_NAME).append('/').append(p).append(BINDING_FILE_ELEMENT_NAME);
        List nl = Xml.evaluateXPath((String)bindingFilesXPathBuilder.toString(), (Node)pom, (String)prefix, (String)"http://maven.apache.org/POM/4.0.0");
        if (nl.isEmpty()) {
            return Collections.emptyList();
        }
        return nl.stream().map(Node::getTextContent).filter(Strings::hasText).map(String::trim).collect(Collectors.toList());
    }

    public static StringBuilder getJaxWsMavenPluginXPath(String p, IScoutVariousApi api) {
        return new StringBuilder().append(p).append("project").append('/').append(p).append("build").append('/').append(p).append("plugins").append('/').append(p).append("plugin").append("[./").append(p).append("groupId").append("='").append(api.JaxWsConstants().mavenPluginGroupId()).append("' and ./").append(p).append("artifactId").append("='").append(JAXWS_MAVEN_PLUGIN_ARTIFACT_ID).append(XPATH_END);
    }

    static String getNextExecutionId(Node executions) {
        int curNum = 1;
        String idPrefix = "wsimport-";
        NodeList children = executions.getChildNodes();
        while (JaxWsUtils.isExecutionIdUsed(idPrefix + curNum, children)) {
            ++curNum;
        }
        return idPrefix + curNum;
    }

    static boolean isExecutionIdUsed(CharSequence id, NodeList executionList) {
        return IntStream.range(0, executionList.getLength()).mapToObj(executionList::item).filter(node -> node.getNodeType() == 1).map(node -> Xml.firstChildElement((Node)node, (String)"id")).flatMap(Optional::stream).anyMatch(idElement -> Strings.equals((CharSequence)id, (CharSequence)Strings.trim((CharSequence)idElement.getTextContent())));
    }

    static Element getExecutionsElement(Node root, IScoutVariousApi api) {
        Element build = JaxWsUtils.getOrCreateElement(root, "build");
        Element plugins = JaxWsUtils.getOrCreateElement(build, "plugins");
        Element jaxWsMavenPluginElement = JaxWsUtils.getOrCreateJaxWsMavenPluginElement(plugins, api);
        return JaxWsUtils.getOrCreateElement(jaxWsMavenPluginElement, "executions");
    }

    static Element getOrCreateJaxWsMavenPluginElement(Node pluginsElement, IScoutVariousApi api) {
        NodeList plugins = pluginsElement.getChildNodes();
        String jaxWsMavenPluginGroupId = api.JaxWsConstants().mavenPluginGroupId();
        for (int i = 0; i < plugins.getLength(); ++i) {
            Node plugin = plugins.item(i);
            if (plugin.getNodeType() != 1 || !"plugin".equals(plugin.getNodeName())) continue;
            Element pluginCandidate = (Element)plugin;
            Optional group = Xml.firstChildElement((Node)pluginCandidate, (String)"groupId");
            Optional artifact = Xml.firstChildElement((Node)pluginCandidate, (String)"artifactId");
            if (!group.isPresent() || !jaxWsMavenPluginGroupId.equals(((Element)group.orElseThrow()).getTextContent()) || !artifact.isPresent() || !JAXWS_MAVEN_PLUGIN_ARTIFACT_ID.equals(((Element)artifact.orElseThrow()).getTextContent())) continue;
            return pluginCandidate;
        }
        Element plugin = JaxWsUtils.getOrCreateElement(pluginsElement, "plugin");
        Element groupId = JaxWsUtils.getOrCreateElement(plugin, "groupId");
        groupId.setTextContent(jaxWsMavenPluginGroupId);
        Element artifactId = JaxWsUtils.getOrCreateElement(plugin, "artifactId");
        artifactId.setTextContent(JAXWS_MAVEN_PLUGIN_ARTIFACT_ID);
        return plugin;
    }

    static Element getOrCreateElement(Node parent, String tagName) {
        return Xml.firstChildElement((Node)parent, (String)tagName).orElseGet(() -> {
            Element element = parent.getOwnerDocument().createElement(tagName);
            parent.appendChild(element);
            return element;
        });
    }

    public static Element getJaxWsBindingElement(String nodeValue, Node document) throws XPathExpressionException {
        StringBuilder xPath = new StringBuilder();
        String prefix = "jaxws";
        String p = prefix + ":";
        xPath.append(p).append(BINDINGS_ELEMENT_NAME).append('/').append(p).append(BINDINGS_ELEMENT_NAME);
        List bindings = Xml.evaluateXPath((String)xPath.toString(), (Node)document, (String)prefix, (String)JAX_WS_NAMESPACE);
        for (Element binding : bindings) {
            String nodeAttribValue = binding.getAttribute(BINDINGS_NODE_ATTRIBUTE_NAME);
            if (!nodeValue.equals(nodeAttribValue)) continue;
            return binding;
        }
        return null;
    }

    public static String removeCommonSuffixes(String input) {
        String[] suffixes;
        if (Strings.isBlank((CharSequence)input)) {
            return input;
        }
        for (String s : suffixes = new String[]{"xml", "soap", "porttype", "port", "webservice", "services", "service"}) {
            if (!input.toLowerCase(Locale.US).endsWith(s)) continue;
            String newInputCandidate = input.substring(0, input.length() - s.length());
            if (Strings.isBlank((CharSequence)newInputCandidate)) {
                return input;
            }
            input = newInputCandidate;
        }
        return input;
    }

    public static class JaxWsBindingMapping {
        private final boolean m_isPortType;
        private final String m_wsdlName;
        private final String m_className;

        public JaxWsBindingMapping(boolean isPortType, String wsdlName, String className) {
            this.m_isPortType = isPortType;
            this.m_wsdlName = wsdlName;
            this.m_className = className;
        }

        public boolean isPortType() {
            return this.m_isPortType;
        }

        public String getWsdlName() {
            return this.m_wsdlName;
        }

        public String getClassName() {
            return this.m_className;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.m_className == null ? 0 : this.m_className.hashCode());
            result = prime * result + (this.m_isPortType ? 1231 : 1237);
            result = prime * result + (this.m_wsdlName == null ? 0 : this.m_wsdlName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxWsBindingMapping other = (JaxWsBindingMapping)obj;
            return this.m_isPortType == other.m_isPortType && Objects.equals(this.m_className, other.m_className) && Objects.equals(this.m_wsdlName, other.m_wsdlName);
        }
    }
}

