/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.transform.TransformerException;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.jaxws.EmptyWsdlGenerator;
import org.eclipse.scout.sdk.core.s.jaxws.EntryPointDefinitionGenerator;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.s.jaxws.JaxbBindingGenerator;
import org.eclipse.scout.sdk.core.s.jaxws.JaxwsBindingGenerator;
import org.eclipse.scout.sdk.core.s.jaxws.ParsedWsdl;
import org.eclipse.scout.sdk.core.s.jaxws.WebServiceClientGenerator;
import org.eclipse.scout.sdk.core.s.jaxws.WebServiceProviderGenerator;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.Xml;
import org.w3c.dom.Document;

public abstract class AbstractWebServiceNewOperation
implements BiConsumer<IEnvironment, IProgress> {
    private boolean m_isCreateNewModule;
    private boolean m_isCreateConsumer;
    private boolean m_isCreateEmptyWsdl;
    private String m_package;
    private Path m_projectRoot;
    private URL m_wsdlUrl;
    private String m_wsdlName;
    private IClasspathEntry m_sourceFolder;
    private Path m_createdWsdlFile;
    private Path m_createdJaxbBindingFile;
    private final List<Path> m_createdJaxwsBindingFiles;
    private final List<IType> m_createdWebServiceClients;
    private final List<IType> m_createdEntryPointDefinitions;
    private final List<IType> m_createdProviderServiceImpls;
    private final List<String> m_createdUrlProperties;
    private CharSequence m_wsdlContent;
    private ParsedWsdl m_parsedWsdl;

    protected AbstractWebServiceNewOperation() {
        int capacity = 2;
        this.m_createdWebServiceClients = new ArrayList<IType>(capacity);
        this.m_createdEntryPointDefinitions = new ArrayList<IType>(capacity);
        this.m_createdProviderServiceImpls = new ArrayList<IType>(capacity);
        this.m_createdUrlProperties = new ArrayList<String>(capacity);
        this.m_createdJaxwsBindingFiles = new ArrayList<Path>(capacity);
    }

    @Override
    public void accept(IEnvironment env, IProgress progress) {
        if (!this.isCreateNewModule()) {
            Ensure.notNull((Object)this.getProjectRoot());
        }
        if (this.isCreateEmptyWsdl()) {
            Ensure.notBlank((CharSequence)this.getWsdlName(), (CharSequence)"WSDL name cannot be empty when creating an empty WSDL.", (Object[])new Object[0]);
        } else {
            Ensure.notNull((Object)this.getWsdlUrl(), (CharSequence)"WSDL URL cannot be null.", (Object[])new Object[0]);
        }
        Ensure.notBlank((CharSequence)this.getPackage(), (CharSequence)"Target package cannot be empty.", (Object[])new Object[0]);
        progress.init(100, this.toString(), new Object[0]);
        if (this.isCreateNewModule()) {
            this.setProjectRoot(this.createNewJaxWsModule(env, progress.newChild(39)));
            IClasspathEntry primarySrcFolderOfNewModule = (IClasspathEntry)env.findJavaEnvironment(this.getProjectRoot()).flatMap(IJavaEnvironment::primarySourceFolder).orElseThrow(() -> Ensure.newFail((CharSequence)"Unable to find java environment for newly created jaxws project.", (Object[])new Object[0]));
            this.setSourceFolder(primarySrcFolderOfNewModule);
        }
        progress.setWorkRemaining(61);
        IScoutApi scoutApi = (IScoutApi)this.getSourceFolder().javaEnvironment().requireApi(IScoutApi.class);
        String wsdlBaseName = this.getWsdlBaseName();
        if (this.isCreateEmptyWsdl()) {
            EmptyWsdlGenerator generator = new EmptyWsdlGenerator().withName(wsdlBaseName).withPackage(this.getPackage());
            this.setWsdlContent(env.executeGenerator(generator, this.getSourceFolder()));
        } else {
            this.setWsdlContent(AbstractWebServiceNewOperation.readXmlFromUrl(this.getWsdlUrl()));
        }
        progress.worked(5);
        this.setParsedWsdl(this.parseWsdl(this.getWsdlBaseUri(wsdlBaseName)));
        if (this.getParsedWsdl().isEmpty()) {
            SdkLog.warning((CharSequence)"No service or port found in WSDL: Generation of web service aborted.", (Object[])new Object[0]);
            return;
        }
        progress.worked(8);
        Path bindingFolder = AbstractWebServiceNewOperation.getBindingFolder(this.getProjectRoot(), wsdlBaseName);
        this.setCreatedWsdlFile(this.writeWsdlToProject(wsdlBaseName, env, progress.newChild(2)));
        this.copyReferencedResources(wsdlBaseName, env, progress.newChild(1));
        this.setParsedWsdl(this.parseWsdl(this.getTargetWsdlFileUri(wsdlBaseName)));
        this.setCreatedJaxbBindingFile(AbstractWebServiceNewOperation.createJaxbBinding(bindingFolder, env, progress.newChild(1)));
        this.createJaxwsBindings(bindingFolder, env, progress.newChild(2));
        Path wsdlFolderRelativePath = AbstractWebServiceNewOperation.getWsdlRootFolder(this.getProjectRoot()).relativize(this.getCreatedWsdlFile());
        this.addWsdlToPom(wsdlFolderRelativePath, bindingFolder.getFileName().toString(), env, progress.newChild(2), scoutApi);
        if (this.isCreateConsumer()) {
            this.createDerivedResources(env, progress.newChild(30));
            this.getSourceFolder().javaEnvironment().reload();
            this.createWebServiceClients(env, progress.newChild(10));
        } else {
            this.createEntryPointDefinitions(env, progress.newChild(5));
            this.createDerivedResources(env, progress.newChild(30));
            this.getSourceFolder().javaEnvironment().reload();
            this.createProviderServiceImplementations(env, progress.newChild(5));
        }
    }

    protected String getWsdlBaseName() {
        return JaxWsUtils.removeCommonSuffixes(Strings.removeSuffix((String)this.getWsdlFileName(), (CharSequence)".wsdl"));
    }

    protected abstract void createDerivedResources(IEnvironment var1, IProgress var2);

    protected abstract Path createNewJaxWsModule(IEnvironment var1, IProgress var2);

    protected void createProviderServiceImplementations(IEnvironment env, IProgress progress) {
        for (Map.Entry<Service, ParsedWsdl.WebServiceNames> service : this.getParsedWsdl().getServiceNames().entrySet()) {
            Set<PortType> portTypes = this.getParsedWsdl().getPortTypes(service.getKey());
            for (PortType pt : portTypes) {
                String portTypeName = pt.getQName().getLocalPart();
                Object wspsb = ((WebServiceProviderGenerator)((WebServiceProviderGenerator)new WebServiceProviderGenerator().withElementName(ParsedWsdl.WebServiceNames.getWebServiceProviderImplClassName(portTypeName))).withPackageName(this.getPackage())).withPortType(this.getPackage() + "." + ParsedWsdl.WebServiceNames.getPortTypeClassName(portTypeName));
                this.m_createdProviderServiceImpls.add(env.writeCompilationUnit((ICompilationUnitGenerator<?>)wspsb, this.getSourceFolder(), progress));
            }
        }
    }

    protected void createEntryPointDefinitions(IEnvironment env, IProgress progress) {
        for (Map.Entry<Service, ParsedWsdl.WebServiceNames> service : this.getParsedWsdl().getServiceNames().entrySet()) {
            ParsedWsdl.WebServiceNames names = service.getValue();
            Set<PortType> portTypes = this.getParsedWsdl().getPortTypes(service.getKey());
            for (PortType pt : portTypes) {
                String portTypeName = pt.getQName().getLocalPart();
                Object epdsb = ((EntryPointDefinitionGenerator)((Object)((EntryPointDefinitionGenerator)((Object)((EntryPointDefinitionGenerator)((Object)((EntryPointDefinitionGenerator)((Object)((EntryPointDefinitionGenerator)((EntryPointDefinitionGenerator)new EntryPointDefinitionGenerator().withElementName(ParsedWsdl.WebServiceNames.getEntryPointDefinitionClassName(portTypeName))).withPackageName(this.getPackage())).withPortTypeFqn(this.getPackage() + "." + ParsedWsdl.WebServiceNames.getPortTypeClassName(portTypeName)))).withEntryPointName(ParsedWsdl.WebServiceNames.getEntryPointClassName(portTypeName)))).withEntryPointPackage(this.getPackage()))).withPortName(this.getParsedWsdl().getPortName(service.getKey(), pt)))).withServiceName(names.getWebServiceNameFromWsdl());
                this.m_createdEntryPointDefinitions.add(env.writeCompilationUnit((ICompilationUnitGenerator<?>)epdsb, this.getSourceFolder(), progress));
            }
        }
    }

    protected void createWebServiceClients(IEnvironment env, IProgress progress) {
        for (Map.Entry<Service, ParsedWsdl.WebServiceNames> service : this.getParsedWsdl().getServiceNames().entrySet()) {
            ParsedWsdl.WebServiceNames names = service.getValue();
            Set<PortType> portTypes = this.getParsedWsdl().getPortTypes(service.getKey());
            for (PortType pt : portTypes) {
                String portTypeName = pt.getQName().getLocalPart();
                Object wscsb = ((WebServiceClientGenerator)((Object)((WebServiceClientGenerator)((WebServiceClientGenerator)new WebServiceClientGenerator().withElementName(ParsedWsdl.WebServiceNames.getWebServiceClientClassName(portTypeName))).withPackageName(this.getPackage())).withPortType(this.getPackage() + "." + ParsedWsdl.WebServiceNames.getPortTypeClassName(portTypeName)))).withService(this.getPackage() + "." + names.getWebServiceClassName());
                this.m_createdWebServiceClients.add(env.writeCompilationUnit((ICompilationUnitGenerator<?>)wscsb, this.getSourceFolder(), progress));
                this.m_createdUrlProperties.add(((WebServiceClientGenerator)((Object)wscsb)).urlPropertyName());
            }
        }
    }

    protected void copyReferencedResources(String baseName, IEnvironment env, IProgress progress) {
        for (Map.Entry<URI, String> resource : this.getParsedWsdl().getReferencedResources().entrySet()) {
            URI sourceUri = resource.getKey();
            if (resource.getValue().equals(resource.getKey().toString())) continue;
            String relPath = resource.getValue();
            Path wsdlFolder = this.getWsdlFolder(baseName);
            Path target = wsdlFolder.resolve(relPath);
            try {
                StringBuffer content = AbstractWebServiceNewOperation.readXmlFromUrl(sourceUri.toURL());
                env.writeResource(content, target, progress);
            }
            catch (MalformedURLException e) {
                throw new SdkException((Throwable)e);
            }
        }
    }

    protected ParsedWsdl parseWsdl(URI documentBase) {
        try {
            return ParsedWsdl.create(documentBase, this.getWsdlContent(), true);
        }
        catch (UnsupportedEncodingException | WSDLException e) {
            throw new SdkException(e);
        }
    }

    protected URI getWsdlBaseUri(String baseName) {
        URL wsdlUrl = this.getWsdlUrl();
        if (wsdlUrl == null) {
            return this.getTargetWsdlFileUri(baseName);
        }
        try {
            return wsdlUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected static Path getBindingFolder(Path jaxWsProject, String wsBaseName) {
        String bindingFolderName = wsBaseName.toLowerCase(Locale.US);
        return AbstractWebServiceNewOperation.getBindingRootFolder(jaxWsProject).resolve(bindingFolderName);
    }

    protected URI getTargetWsdlFileUri(String baseName) {
        Path wsdlFolder = this.getWsdlFolder(baseName);
        Path wsdlFile = wsdlFolder.resolve(this.getWsdlFileName());
        return wsdlFile.toUri();
    }

    protected void addWsdlToPom(Path wsdlFolderRelativePath, String bindingFolderName, IEnvironment env, IProgress progress, IScoutVariousApi api) {
        Path pom = this.getProjectRoot().resolve("pom.xml");
        if (!Files.isReadable(pom) || !Files.isRegularFile(pom, new LinkOption[0])) {
            return;
        }
        Collection bindingFileNames = this.getCreatedJaxwsBindingFiles().stream().map(createdJaxWsBinding -> createdJaxWsBinding.getFileName().toString()).collect(Collectors.toList());
        bindingFileNames.add(this.getCreatedJaxbBindingFile().getFileName().toString());
        try {
            Document document = Xml.get((Path)pom);
            JaxWsUtils.addWsdlToPom(document, wsdlFolderRelativePath.toString().replace('\\', '/'), bindingFolderName, bindingFileNames, api);
            env.writeResource(Xml.writeDocument((Document)document, (boolean)true), pom, progress);
        }
        catch (IOException | TransformerException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected Path getWsdlFolder(String wsBaseName) {
        String wsdlFolderName = wsBaseName.toLowerCase(Locale.US);
        return AbstractWebServiceNewOperation.getWsdlRootFolder(this.getProjectRoot()).resolve(wsdlFolderName);
    }

    protected void createJaxwsBindings(Path wsdlBindingsFolder, IEnvironment env, IProgress progress) {
        URI parent = wsdlBindingsFolder.toUri();
        Map<String, StringBuilder> jaxwsBindingContents = this.getJaxwsBindingContents(this.getParsedWsdl(), parent, this.getPackage(), env);
        for (Map.Entry<String, StringBuilder> binding : jaxwsBindingContents.entrySet()) {
            Path jaxwsBindingXmlFile;
            if (jaxwsBindingContents.size() == 1) {
                jaxwsBindingXmlFile = wsdlBindingsFolder.resolve("jaxws-binding.xml");
            } else {
                String pathFileName = binding.getKey();
                if (pathFileName == null) {
                    throw new IllegalArgumentException("zero length path found.");
                }
                String partName = Strings.removeSuffix((String)pathFileName.toLowerCase(Locale.US), (CharSequence)".wsdl");
                int lastDotPos = "jaxws-binding.xml".lastIndexOf(46);
                StringBuilder fileName = new StringBuilder();
                fileName.append("jaxws-binding.xml", 0, lastDotPos);
                fileName.append('-').append(partName).append("jaxws-binding.xml".substring(lastDotPos));
                jaxwsBindingXmlFile = wsdlBindingsFolder.resolve(fileName.toString());
            }
            env.writeResource(binding.getValue(), jaxwsBindingXmlFile, progress);
            this.m_createdJaxwsBindingFiles.add(jaxwsBindingXmlFile);
        }
    }

    protected Map<String, StringBuilder> getJaxwsBindingContents(ParsedWsdl parsedWsdl, URI rootWsdlUri, String targetPackage, IEnvironment env) {
        HashMap<URI, Set> bindingsByFile = new HashMap<URI, Set>();
        for (Map.Entry<Service, URI> service : parsedWsdl.getWebServices().entrySet()) {
            ParsedWsdl.WebServiceNames names = parsedWsdl.getServiceNames().get(service.getKey());
            bindingsByFile.computeIfAbsent(service.getValue(), k -> new HashSet()).add(new JaxWsUtils.JaxWsBindingMapping(false, names.getWebServiceNameFromWsdl(), names.getWebServiceClassName()));
            Set<PortType> portTypesByService = parsedWsdl.getPortTypes(service.getKey());
            for (PortType portType : portTypesByService) {
                URI uriOfPortType = parsedWsdl.getPortTypes().get(portType);
                String portTypeName = portType.getQName().getLocalPart();
                bindingsByFile.computeIfAbsent(uriOfPortType, k -> new HashSet()).add(new JaxWsUtils.JaxWsBindingMapping(true, portTypeName, ParsedWsdl.WebServiceNames.getPortTypeClassName(portTypeName)));
            }
        }
        HashMap<String, StringBuilder> result = new HashMap<String, StringBuilder>(bindingsByFile.size());
        for (Map.Entry binding : bindingsByFile.entrySet()) {
            URI uri = (URI)binding.getKey();
            URI relPath = CoreUtils.relativizeURI((URI)rootWsdlUri, (URI)uri);
            Path path = "file".equals(uri.getScheme()) ? Paths.get(uri) : Paths.get(uri.getPath(), new String[0]);
            if (path.getNameCount() < 1) {
                SdkLog.warning((CharSequence)"Zero length path found for jax-ws binding content of URI '{}'. Skipping.", (Object[])new Object[]{uri});
                continue;
            }
            JaxwsBindingGenerator generator = new JaxwsBindingGenerator().withNames((Iterable)binding.getValue()).withWsdlLocation(relPath).withWsPackage(targetPackage);
            StringBuilder jaxwsBindingContent = env.executeGenerator(generator, this.getSourceFolder());
            result.put(path.getFileName().toString(), jaxwsBindingContent);
        }
        return result;
    }

    protected static Path createJaxbBinding(Path wsdlBindingsFolder, IEnvironment env, IProgress progress) {
        Path jaxbBindingXmlFile = wsdlBindingsFolder.resolve("jaxb-binding.xml");
        env.writeResource(new JaxbBindingGenerator(), jaxbBindingXmlFile, progress);
        return jaxbBindingXmlFile;
    }

    protected String getWsdlFileName() {
        Object wsdlFileName;
        URL wsdlUrl = this.getWsdlUrl();
        if (wsdlUrl != null) {
            wsdlFileName = wsdlUrl.getPath();
            int lastSlashPos = ((String)wsdlFileName).lastIndexOf(47);
            int lastDotPos = ((String)wsdlFileName).lastIndexOf(46);
            if (lastDotPos < lastSlashPos) {
                lastDotPos = ((String)wsdlFileName).length();
            }
            wsdlFileName = ((String)wsdlFileName).substring(lastSlashPos + 1, lastDotPos);
        } else {
            wsdlFileName = Strings.removeSuffix((String)this.getWsdlName(), (CharSequence)"WebService");
        }
        wsdlFileName = (String)wsdlFileName + ".wsdl";
        return wsdlFileName;
    }

    protected Path writeWsdlToProject(String baseName, IEnvironment env, IProgress progress) {
        Path wsdlFolder = this.getWsdlFolder(baseName);
        Path wsdlFile = wsdlFolder.resolve(this.getWsdlFileName());
        env.writeResource(this.getWsdlContent(), wsdlFile, progress);
        return wsdlFile;
    }

    protected static StringBuffer readXmlFromUrl(URL url) {
        try {
            return Xml.writeDocument((Document)Xml.get((URL)url), (boolean)false);
        }
        catch (IOException | TransformerException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public static Path getBindingRootFolder(Path jaxWsProject) {
        return AbstractWebServiceNewOperation.getWebInfFolder(jaxWsProject).resolve("binding");
    }

    public static Path getWsdlRootFolder(Path jaxWsProject) {
        return AbstractWebServiceNewOperation.getWebInfFolder(jaxWsProject).resolve("wsdl");
    }

    public static Path getWebInfFolder(Path jaxWsProject) {
        return jaxWsProject.resolve("src/main/resources/WEB-INF");
    }

    public boolean isCreateNewModule() {
        return this.m_isCreateNewModule;
    }

    public void setCreateNewModule(boolean isCreateNewModule) {
        this.m_isCreateNewModule = isCreateNewModule;
    }

    public URL getWsdlUrl() {
        return this.m_wsdlUrl;
    }

    public void setWsdlUrl(URL wsdlUrl) {
        this.m_wsdlUrl = wsdlUrl;
    }

    public Path getCreatedWsdlFile() {
        return this.m_createdWsdlFile;
    }

    protected void setCreatedWsdlFile(Path createdWsdlFile) {
        this.m_createdWsdlFile = createdWsdlFile;
    }

    public Path getCreatedJaxbBindingFile() {
        return this.m_createdJaxbBindingFile;
    }

    protected void setCreatedJaxbBindingFile(Path createdJaxbBindingFile) {
        this.m_createdJaxbBindingFile = createdJaxbBindingFile;
    }

    public List<Path> getCreatedJaxwsBindingFiles() {
        return Collections.unmodifiableList(this.m_createdJaxwsBindingFiles);
    }

    public CharSequence getWsdlContent() {
        return this.m_wsdlContent;
    }

    protected void setWsdlContent(CharSequence wsdlContent) {
        this.m_wsdlContent = wsdlContent;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String targetPackage) {
        this.m_package = targetPackage;
    }

    public List<IType> getCreatedWebServiceClients() {
        return Collections.unmodifiableList(this.m_createdWebServiceClients);
    }

    public boolean isCreateConsumer() {
        return this.m_isCreateConsumer;
    }

    public void setCreateConsumer(boolean isCreateConsumer) {
        this.m_isCreateConsumer = isCreateConsumer;
    }

    public boolean isCreateEmptyWsdl() {
        return this.m_isCreateEmptyWsdl;
    }

    public void setCreateEmptyWsdl(boolean isCreateEmptyWsdl) {
        this.m_isCreateEmptyWsdl = isCreateEmptyWsdl;
    }

    public String getWsdlName() {
        return this.m_wsdlName;
    }

    public void setWsdlName(String wsdlName) {
        this.m_wsdlName = wsdlName;
    }

    public List<IType> getCreatedEntryPointDefinitions() {
        return Collections.unmodifiableList(this.m_createdEntryPointDefinitions);
    }

    public List<IType> getCreatedProviderServiceImpls() {
        return Collections.unmodifiableList(this.m_createdProviderServiceImpls);
    }

    public List<String> getCreatedUrlProperties() {
        return Collections.unmodifiableList(this.m_createdUrlProperties);
    }

    public ParsedWsdl getParsedWsdl() {
        return this.m_parsedWsdl;
    }

    protected void setParsedWsdl(ParsedWsdl parsedWsdl) {
        this.m_parsedWsdl = parsedWsdl;
    }

    public Path getProjectRoot() {
        return this.m_projectRoot;
    }

    public void setProjectRoot(Path projectRoot) {
        this.m_projectRoot = projectRoot;
    }

    public IClasspathEntry getSourceFolder() {
        return this.m_sourceFolder;
    }

    public void setSourceFolder(IClasspathEntry sourceFolder) {
        this.m_sourceFolder = sourceFolder;
    }

    public String toString() {
        return "Create new Web Service";
    }
}

