/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.form;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.scout.sdk.core.builder.java.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.builder.java.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.builder.java.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.generator.field.FieldGenerator;
import org.eclipse.scout.sdk.core.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.generator.method.MethodGenerator;
import org.eclipse.scout.sdk.core.generator.methodparam.IMethodParameterGenerator;
import org.eclipse.scout.sdk.core.generator.methodparam.MethodParameterGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.generator.type.PrimaryTypeGenerator;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.s.builder.java.body.IScoutMethodBodyBuilder;
import org.eclipse.scout.sdk.core.s.dto.DtoGeneratorFactory;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.form.FormGenerator;
import org.eclipse.scout.sdk.core.s.generator.annotation.ScoutAnnotationGenerator;
import org.eclipse.scout.sdk.core.s.generator.method.IScoutMethodGenerator;
import org.eclipse.scout.sdk.core.s.generator.method.ScoutMethodGenerator;
import org.eclipse.scout.sdk.core.s.permission.PermissionGenerator;
import org.eclipse.scout.sdk.core.s.service.ServiceNewOperation;
import org.eclipse.scout.sdk.core.s.testcase.TestGenerator;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.Strings;

public class FormNewOperation
implements BiConsumer<IEnvironment, IProgress> {
    private String m_formName;
    private FinalValue<String> m_baseName = new FinalValue();
    private IClasspathEntry m_clientSourceFolder;
    private IClasspathEntry m_sharedSourceFolder;
    private IClasspathEntry m_serverSourceFolder;
    private IClasspathEntry m_formDataSourceFolder;
    private IClasspathEntry m_clientTestSourceFolder;
    private IClasspathEntry m_serverTestSourceFolder;
    private String m_clientPackage;
    private String m_superType;
    private String m_serverSession;
    private boolean m_createFormData;
    private boolean m_createOrAppendService;
    private boolean m_createPermissions;
    private List<String> m_attributes;
    private ServiceNewOperation m_serviceNewOperation;
    private IFuture<IType> m_createdForm;
    private String m_createdFormFqn;
    private IFuture<IType> m_createdFormData;
    private String m_createdFormDataFqn;
    private IFuture<IType> m_createdServiceInterface;
    private String m_serviceInterfaceFqn;
    private IFuture<IType> m_createdServiceImpl;
    private String m_serviceImplFqn;
    private IFuture<IType> m_createdReadPermission;
    private String m_createdReadPermissionFqn;
    private IFuture<IType> m_createdUpdatePermission;
    private String m_createdUpdatePermissionFqn;
    private IFuture<IType> m_createdCreatePermission;
    private String m_createdCreatePermissionFqn;
    private IFuture<IType> m_createdFormTest;
    private String m_createdFormTestFqn;
    private IFuture<IType> m_createdServiceTest;
    private String m_serviceTestFqn;

    @Override
    public void accept(IEnvironment env, IProgress progress) {
        this.validateOperation();
        this.prepareProgress(progress);
        this.executeOperation(env, progress);
    }

    protected void validateOperation() {
        Ensure.notBlank((CharSequence)this.getFormName(), (CharSequence)"No form name provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getClientSourceFolder(), (CharSequence)"No client source folder provided", (Object[])new Object[0]);
        if (this.isCreateService()) {
            Ensure.notNull((Object)this.getServerSourceFolder(), (CharSequence)"No server source folder provided", (Object[])new Object[0]);
        }
        if (this.isCreateService() || this.isCreatePermissions()) {
            Ensure.notNull((Object)this.getSharedSourceFolder(), (CharSequence)"No shared source folder provided", (Object[])new Object[0]);
        }
        if (this.isCreateFormData()) {
            Ensure.notNull((Object)this.getFormDataSourceFolder(), (CharSequence)"No form data source folder provided", (Object[])new Object[0]);
        }
        Ensure.notBlank((CharSequence)this.getClientPackage(), (CharSequence)"No package provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getSuperType(), (CharSequence)"Super type does not exist", (Object[])new Object[0]);
    }

    protected void prepareProgress(IProgress progress) {
        progress.init(this.getTotalWork(), this.toString(), new Object[0]);
    }

    protected void executeOperation(IEnvironment env, IProgress progress) {
        String sharedPackage = ScoutTier.Client.convert(ScoutTier.Shared, this.getClientPackage());
        if (this.isCreateFormData()) {
            this.setCreatedFormData(this.createFormData(sharedPackage, env, progress.newChild(1)));
        }
        if (this.isCreatePermissions()) {
            this.createPermissions(sharedPackage, this.getBaseName() + "Permission", env, progress);
        }
        if (this.isCreateOrAppendService()) {
            this.createOrAppendService(sharedPackage, env, progress);
        }
        this.setCreatedForm(this.createForm(env, progress.newChild(1)));
        this.setCreatedFormTest(this.createFormTest(env, progress.newChild(1)));
        if (this.isCreateFormData()) {
            this.updateFormData(env, progress.newChild(1));
        }
    }

    protected int getTotalWork() {
        int result = 2;
        if (this.isCreateFormData()) {
            result += 2;
        }
        if (this.isCreateService()) {
            result += 3;
        }
        if (this.isCreatePermissions()) {
            result += 3;
        }
        return result;
    }

    protected String getBaseName() {
        return (String)this.m_baseName.computeIfAbsentAndGet(this::calcFormBaseName);
    }

    protected String calcFormBaseName() {
        return Strings.removeSuffix((String)this.getFormName(), (CharSequence)"Form");
    }

    public String getServiceBaseName() {
        return this.getBaseName();
    }

    protected void updateFormData(IEnvironment env, IProgress progress) {
        this.getCreatedFormData().result();
        Optional<ICompilationUnitGenerator<?>> formDataGenerator = DtoGeneratorFactory.createFormDataGenerator(this.getCreatedForm().result(), this.getFormDataSourceFolder().javaEnvironment());
        env.writeCompilationUnitAsync(formDataGenerator.orElseThrow(), this.getFormDataSourceFolder(), progress);
    }

    protected TestGenerator<?> createFormTestBuilder(IScoutVariousApi scoutApi) {
        Object testBuilder = ((TestGenerator)((Object)((TestGenerator)((TestGenerator)new TestGenerator().withElementName(JavaTypes.simpleName((CharSequence)this.getCreatedFormFqn()) + "Test")).withPackageName(this.getClientPackage())).withRunner(scoutApi.ClientTestRunner().fqn()))).asClientTest(true);
        if (this.isCreateOrAppendService() && this.isCreateFormData()) {
            this.addMock((ITypeGenerator<?>)testBuilder);
        }
        return testBuilder;
    }

    protected void addMock(ITypeGenerator<?> testBuilder) {
        String mockVarName = "m_mockSvc";
        testBuilder.withField((IFieldGenerator)((IFieldGenerator)((IFieldGenerator)FieldGenerator.create().withElementName(mockVarName)).asPrivate()).withDataType(this.getServiceInterfaceFqn()).withAnnotation(ScoutAnnotationGenerator.createBeanMock()), new Object[0]).withMethod(((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().withElementName("setup")).asPublic()).withReturnType("void").withAnnotation(ScoutAnnotationGenerator.createBefore())).withBody(b -> {
            String varName = "answer";
            String formDataName = this.getCreatedFormDataFqn();
            ((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)b.ref((CharSequence)formDataName)).space()).append(varName)).equalSign()).appendNew((CharSequence)formDataName)).parenthesisClose()).semicolon()).nl();
            FormNewOperation.appendMockSource(b, varName, mockVarName, "prepareCreate");
            FormNewOperation.appendMockSource(b, varName, mockVarName, "create");
            FormNewOperation.appendMockSource(b, varName, mockVarName, "load");
            FormNewOperation.appendMockSource(b, varName, mockVarName, "store");
        }), new Object[0]);
    }

    protected static void appendMockSource(IMethodBodyBuilder<?> builder, String formDataVarName, String mockVarName, String methodToMock) {
        ((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)builder.refClassFrom(IScoutApi.class, IScoutVariousApi::Mockito)).dot()).appendFrom(IScoutApi.class, api -> api.Mockito().whenMethodName())).parenthesisOpen()).append(mockVarName)).dot()).append(methodToMock)).parenthesisOpen()).refClassFrom(IScoutApi.class, IScoutVariousApi::ArgumentMatchers)).dot()).appendFrom(IScoutApi.class, api -> api.ArgumentMatchers().anyMethodName())).parenthesisOpen()).parenthesisClose()).parenthesisClose()).parenthesisClose()).dot()).append("thenReturn")).parenthesisOpen()).append(formDataVarName)).parenthesisClose()).semicolon()).nl();
    }

    protected IFuture<IType> createFormTest(IEnvironment env, IProgress progress) {
        IClasspathEntry testSourceFolder = this.getClientTestSourceFolder();
        if (testSourceFolder == null) {
            return null;
        }
        IScoutApi scoutApi = (IScoutApi)testSourceFolder.javaEnvironment().requireApi(IScoutApi.class);
        TestGenerator<?> formTestBuilder = this.createFormTestBuilder(scoutApi);
        this.setCreatedFormTestFqn(formTestBuilder.fullyQualifiedName());
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)formTestBuilder, testSourceFolder, progress);
    }

    protected void createOrAppendService(String sharedPackage, IEnvironment env, IProgress progress) {
        if (this.isCreateService()) {
            this.createService(sharedPackage, this.getServiceBaseName(), env, progress.newChild(3));
        } else if (this.isAppendService()) {
            ServiceNewOperation op = this.getServiceNewOperation();
            this.addServiceMethods(op);
            String svcName = op.getServiceName() + "Service";
            String serverPackage = ScoutTier.Shared.convert(ScoutTier.Server, op.getSharedPackage());
            this.setServiceInterfaceFqn(sharedPackage + ".I" + svcName);
            this.setServiceImplFqn(serverPackage + "." + svcName);
            if (op.isCreateTest()) {
                this.setServiceTestFqn(this.getServiceImplFqn() + "Test");
            }
        }
    }

    protected void createService(String sharedPackage, String baseName, IEnvironment env, IProgress progress) {
        ServiceNewOperation serviceNewOperation = new ServiceNewOperation();
        this.prepareServiceOperation(serviceNewOperation, sharedPackage, baseName);
        this.addServiceMethods(serviceNewOperation);
        serviceNewOperation.accept(env, progress);
        this.setCreatedServiceImpl(serviceNewOperation.getCreatedServiceImpl());
        this.setServiceImplFqn(serviceNewOperation.getCreatedServiceImplFqn());
        this.setCreatedServiceInterface(serviceNewOperation.getCreatedServiceInterface());
        this.setServiceInterfaceFqn(serviceNewOperation.getCreatedServiceInterfaceFqn());
        this.setCreatedServiceTest(serviceNewOperation.getCreatedServiceTest());
        this.setServiceTestFqn(serviceNewOperation.getCreatedServiceTestFqn());
    }

    protected void prepareServiceOperation(ServiceNewOperation serviceNewOperation, String sharedPackage, String baseName) {
        serviceNewOperation.setServiceName(baseName);
        serviceNewOperation.setSharedPackage(sharedPackage);
        serviceNewOperation.setSharedSourceFolder(this.getSharedSourceFolder());
        serviceNewOperation.setServerSourceFolder(this.getServerSourceFolder());
        if (this.getServerTestSourceFolder() == null) {
            return;
        }
        serviceNewOperation.setTestSourceFolder(this.getServerTestSourceFolder());
        serviceNewOperation.setServerSession(this.getServerSession());
        serviceNewOperation.setCreateTest(true);
    }

    protected void addServiceMethods(ServiceNewOperation serviceNewOperation) {
        serviceNewOperation.addMethod(this.createServiceMethod("prepareCreate"));
        serviceNewOperation.addMethod(this.createServiceMethod("create"));
        serviceNewOperation.addMethod(this.createServiceMethod("load"));
        serviceNewOperation.addMethod(this.createServiceMethod("store"));
    }

    protected IMethodGenerator<?, ?> createServiceMethod(String name) {
        IMethodGenerator methodBuilder = ((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().asPublic()).withFlags(512)).withComment(IJavaElementCommentBuilder::appendDefaultElementComment)).withElementName(name)).withBody(b -> {
            if (this.isCreatePermissions()) {
                String methodName = b.surroundingMethod().elementName(b.context()).orElse(null);
                String permissionFqn = "load".equals(methodName) ? this.getCreatedReadPermissionFqn() : ("store".equals(methodName) ? this.getCreatedUpdatePermissionFqn() : this.getCreatedCreatePermissionFqn());
                this.createPermissionCheckSource((IScoutMethodBodyBuilder<?>)b, permissionFqn);
            }
            this.createServiceMethodBody((IScoutMethodBodyBuilder<?>)b);
        });
        if (this.isCreateFormData()) {
            methodBuilder.withReturnType(this.getCreatedFormDataFqn());
            methodBuilder.withParameter(((IMethodParameterGenerator)MethodParameterGenerator.create().withElementName("formData")).withDataType(this.getCreatedFormDataFqn()));
        } else {
            methodBuilder.withReturnType("void");
        }
        return methodBuilder;
    }

    protected void createPermissionCheckSource(IScoutMethodBodyBuilder<?> b, CharSequence permissionFqn) {
        b.appendPermissionCheck(permissionFqn);
    }

    protected void createServiceMethodBody(IScoutMethodBodyBuilder<?> builder) {
        builder.appendTodo("add business logic here.");
        if (!builder.needsReturnClause()) {
            return;
        }
        String returnType = (String)builder.surroundingMethodReturnType().orElseThrow();
        ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)builder.returnClause()).append(FormNewOperation.getParamNameHavingDataType(builder.surroundingMethod(), returnType, builder.context()).orElseGet(() -> JavaTypes.defaultValueOf((CharSequence)returnType)))).semicolon();
    }

    protected static Optional<String> getParamNameHavingDataType(IMethodGenerator<?, ?> msb, String returnType, IJavaBuilderContext context) {
        return msb.parameters().filter(p -> returnType.equals(p.reference(context))).findAny().flatMap(param -> param.elementName(context));
    }

    protected IFuture<IType> createFormData(String sharedPackage, IEnvironment env, IProgress progress) {
        PrimaryTypeGenerator formDataGenerator = PrimaryTypeGenerator.create().withElementName(this.getFormName() + "Data").withPackageName(sharedPackage).withSuperClassFrom(IScoutApi.class, api -> api.AbstractFormData().fqn());
        this.setCreatedFormDataFqn(formDataGenerator.fullyQualifiedName());
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)formDataGenerator, this.getFormDataSourceFolder(), progress);
    }

    protected void createPermissions(String sharedPackage, String permissionBaseName, IEnvironment env, IProgress progress) {
        this.setCreatedReadPermission(this.createReadPermission(permissionBaseName, sharedPackage, env, progress.newChild(1)));
        this.setCreatedUpdatePermission(this.createUpdatePermission(permissionBaseName, sharedPackage, env, progress.newChild(1)));
        this.setCreatedCreatePermission(this.createCreatePermission(permissionBaseName, sharedPackage, env, progress.newChild(1)));
    }

    protected IFuture<IType> createPermission(String permissionName, String sharedPackage, Consumer<String> fqnConsumer, IEnvironment env, IProgress progress) {
        PermissionGenerator psb = (PermissionGenerator)((PermissionGenerator)new PermissionGenerator().withElementName(permissionName)).withPackageName(sharedPackage);
        if (fqnConsumer != null) {
            fqnConsumer.accept(psb.fullyQualifiedName());
        }
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)psb, this.getSharedSourceFolder(), progress);
    }

    protected IFuture<IType> createCreatePermission(String permissionBaseName, String sharedPackage, IEnvironment env, IProgress progress) {
        return this.createPermission("Create" + permissionBaseName, sharedPackage, this::setCreatedCreatePermissionFqn, env, progress);
    }

    protected IFuture<IType> createReadPermission(String permissionBaseName, String sharedPackage, IEnvironment env, IProgress progress) {
        return this.createPermission("Read" + permissionBaseName, sharedPackage, this::setCreatedReadPermissionFqn, env, progress);
    }

    protected IFuture<IType> createUpdatePermission(String permissionBaseName, String sharedPackage, IEnvironment env, IProgress progress) {
        return this.createPermission("Update" + permissionBaseName, sharedPackage, this::setCreatedUpdatePermissionFqn, env, progress);
    }

    protected IFuture<IType> createForm(IEnvironment env, IProgress progress) {
        FormGenerator<?> formBuilder = this.createFormBuilder();
        this.setCreatedFormFqn(formBuilder.fullyQualifiedName());
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)formBuilder, this.getClientSourceFolder(), progress);
    }

    protected FormGenerator<?> createFormBuilderInstance() {
        return new FormGenerator();
    }

    protected FormGenerator<?> createFormBuilder() {
        Object formBuilder = ((FormGenerator)((FormGenerator)((FormGenerator)this.createFormBuilderInstance().withSuperClass(this.getSuperType())).withElementName(this.getFormName())).withPackageName(this.getClientPackage())).withFormFields(this.getAttributes());
        if (this.isCreateFormData()) {
            ((FormGenerator)((Object)formBuilder)).withFormData(this.getCreatedFormDataFqn());
        }
        if (this.isCreateOrAppendService()) {
            ((FormGenerator)((Object)formBuilder)).withServiceInterface(this.getServiceInterfaceFqn());
        }
        if (this.isCreatePermissions()) {
            ((FormGenerator)((Object)formBuilder)).withPermissionUpdate(this.getCreatedUpdatePermissionFqn());
            ((FormGenerator)((Object)formBuilder)).withPermissionCreate(this.getCreatedCreatePermissionFqn());
        }
        return formBuilder;
    }

    public String getFormName() {
        return this.m_formName;
    }

    public void setFormName(String formName) {
        this.m_baseName = new FinalValue();
        this.m_formName = formName;
    }

    public IClasspathEntry getClientSourceFolder() {
        return this.m_clientSourceFolder;
    }

    public void setClientSourceFolder(IClasspathEntry clientSourceFolder) {
        this.m_clientSourceFolder = clientSourceFolder;
    }

    public IClasspathEntry getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IClasspathEntry sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public IClasspathEntry getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IClasspathEntry serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    public String getClientPackage() {
        return this.m_clientPackage;
    }

    public void setClientPackage(String clientPackage) {
        this.m_clientPackage = clientPackage;
    }

    public String getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(String superType) {
        this.m_superType = superType;
    }

    public boolean isCreateFormData() {
        return this.m_createFormData;
    }

    public void setCreateFormData(boolean createFormData) {
        this.m_createFormData = createFormData;
    }

    public boolean isCreateOrAppendService() {
        return this.m_createOrAppendService;
    }

    public void setCreateOrAppendService(boolean createOrAppendService) {
        this.m_createOrAppendService = createOrAppendService;
    }

    public boolean isCreateService() {
        return this.isCreateOrAppendService() && this.getServiceNewOperation() == null;
    }

    public boolean isAppendService() {
        return this.isCreateOrAppendService() && this.getServiceNewOperation() != null;
    }

    public boolean isCreatePermissions() {
        return this.m_createPermissions;
    }

    public void setCreatePermissions(boolean createPermissions) {
        this.m_createPermissions = createPermissions;
    }

    public List<String> getAttributes() {
        return this.m_attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.m_attributes = attributes;
    }

    public ServiceNewOperation getServiceNewOperation() {
        return this.m_serviceNewOperation;
    }

    public void setServiceNewOperation(ServiceNewOperation serviceNewOperation) {
        this.m_serviceNewOperation = serviceNewOperation;
    }

    public IFuture<IType> getCreatedForm() {
        return this.m_createdForm;
    }

    protected void setCreatedForm(IFuture<IType> createdForm) {
        this.m_createdForm = createdForm;
    }

    public String getCreatedFormFqn() {
        return this.m_createdFormFqn;
    }

    protected void setCreatedFormFqn(String createdFormFqn) {
        this.m_createdFormFqn = createdFormFqn;
    }

    public IFuture<IType> getCreatedFormData() {
        return this.m_createdFormData;
    }

    protected void setCreatedFormData(IFuture<IType> createdFormData) {
        this.m_createdFormData = createdFormData;
    }

    public String getCreatedFormDataFqn() {
        return this.m_createdFormDataFqn;
    }

    protected void setCreatedFormDataFqn(String createdFormDataFqn) {
        this.m_createdFormDataFqn = createdFormDataFqn;
    }

    public IFuture<IType> getCreatedServiceInterface() {
        return this.m_createdServiceInterface;
    }

    protected void setCreatedServiceInterface(IFuture<IType> createdServiceInterface) {
        this.m_createdServiceInterface = createdServiceInterface;
    }

    public String getServiceInterfaceFqn() {
        return this.m_serviceInterfaceFqn;
    }

    protected void setServiceInterfaceFqn(String serviceInterfaceFqn) {
        this.m_serviceInterfaceFqn = serviceInterfaceFqn;
    }

    public IFuture<IType> getCreatedServiceImpl() {
        return this.m_createdServiceImpl;
    }

    protected void setCreatedServiceImpl(IFuture<IType> createdServiceImpl) {
        this.m_createdServiceImpl = createdServiceImpl;
    }

    public String getServiceImplFqn() {
        return this.m_serviceImplFqn;
    }

    protected void setServiceImplFqn(String serviceImplFqn) {
        this.m_serviceImplFqn = serviceImplFqn;
    }

    public IFuture<IType> getCreatedReadPermission() {
        return this.m_createdReadPermission;
    }

    protected void setCreatedReadPermission(IFuture<IType> createdReadPermission) {
        this.m_createdReadPermission = createdReadPermission;
    }

    public String getCreatedReadPermissionFqn() {
        return this.m_createdReadPermissionFqn;
    }

    protected void setCreatedReadPermissionFqn(String createdReadPermissionFqn) {
        this.m_createdReadPermissionFqn = createdReadPermissionFqn;
    }

    public IFuture<IType> getCreatedUpdatePermission() {
        return this.m_createdUpdatePermission;
    }

    protected void setCreatedUpdatePermission(IFuture<IType> createdUpdatePermission) {
        this.m_createdUpdatePermission = createdUpdatePermission;
    }

    public String getCreatedUpdatePermissionFqn() {
        return this.m_createdUpdatePermissionFqn;
    }

    protected void setCreatedUpdatePermissionFqn(String createdUpdatePermissionFqn) {
        this.m_createdUpdatePermissionFqn = createdUpdatePermissionFqn;
    }

    public IFuture<IType> getCreatedCreatePermission() {
        return this.m_createdCreatePermission;
    }

    protected void setCreatedCreatePermission(IFuture<IType> createdCreatePermission) {
        this.m_createdCreatePermission = createdCreatePermission;
    }

    public String getCreatedCreatePermissionFqn() {
        return this.m_createdCreatePermissionFqn;
    }

    protected void setCreatedCreatePermissionFqn(String createdCreatePermissionFqn) {
        this.m_createdCreatePermissionFqn = createdCreatePermissionFqn;
    }

    public IClasspathEntry getFormDataSourceFolder() {
        return this.m_formDataSourceFolder;
    }

    public void setFormDataSourceFolder(IClasspathEntry formDataSourceFolder) {
        this.m_formDataSourceFolder = formDataSourceFolder;
    }

    public IClasspathEntry getClientTestSourceFolder() {
        return this.m_clientTestSourceFolder;
    }

    public void setClientTestSourceFolder(IClasspathEntry clientTestSourceFolder) {
        this.m_clientTestSourceFolder = clientTestSourceFolder;
    }

    public IClasspathEntry getServerTestSourceFolder() {
        return this.m_serverTestSourceFolder;
    }

    public void setServerTestSourceFolder(IClasspathEntry serverTestSourceFolder) {
        this.m_serverTestSourceFolder = serverTestSourceFolder;
    }

    public IFuture<IType> getCreatedFormTest() {
        return this.m_createdFormTest;
    }

    protected void setCreatedFormTest(IFuture<IType> createdFormTest) {
        this.m_createdFormTest = createdFormTest;
    }

    public String getCreatedFormTestFqn() {
        return this.m_createdFormTestFqn;
    }

    protected void setCreatedFormTestFqn(String createdFormTestFqn) {
        this.m_createdFormTestFqn = createdFormTestFqn;
    }

    public IFuture<IType> getCreatedServiceTest() {
        return this.m_createdServiceTest;
    }

    protected void setCreatedServiceTest(IFuture<IType> createdServiceTest) {
        this.m_createdServiceTest = createdServiceTest;
    }

    public String getServiceTestFqn() {
        return this.m_serviceTestFqn;
    }

    protected void setServiceTestFqn(String serviceTestFqn) {
        this.m_serviceTestFqn = serviceTestFqn;
    }

    public String getServerSession() {
        return this.m_serverSession;
    }

    public void setServerSession(String serverSession) {
        this.m_serverSession = serverSession;
    }

    public String toString() {
        return "Create new Form";
    }
}

