/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.dto;

import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.PropertyBean;
import org.eclipse.scout.sdk.core.model.api.query.HierarchyInnerTypeQuery;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.builder.java.body.IScoutMethodBodyBuilder;
import org.eclipse.scout.sdk.core.s.dto.AbstractDtoGenerator;
import org.eclipse.scout.sdk.core.s.dto.DtoMemberSortObjectFactory;
import org.eclipse.scout.sdk.core.s.dto.form.FormDataGenerator;
import org.eclipse.scout.sdk.core.s.dto.table.TableFieldDataGenerator;
import org.eclipse.scout.sdk.core.s.dto.table.TableRowDataGenerator;
import org.eclipse.scout.sdk.core.s.generator.method.IScoutMethodGenerator;
import org.eclipse.scout.sdk.core.s.generator.method.ScoutMethodGenerator;
import org.eclipse.scout.sdk.core.util.Strings;

public class CompositeFormDataGenerator<TYPE extends CompositeFormDataGenerator<TYPE>>
extends FormDataGenerator<TYPE> {
    public CompositeFormDataGenerator(IType modelType, FormDataAnnotationDescriptor formDataAnnotation, IJavaEnvironment targetEnv) {
        super(modelType, formDataAnnotation, targetEnv);
    }

    @Override
    protected void setupBuilder() {
        this.processInnerTypes(this.modelType());
        super.setupBuilder();
    }

    protected void processInnerTypes(IType compositeType) {
        IScoutApi scoutApi = this.scoutApi();
        ((HierarchyInnerTypeQuery)((HierarchyInnerTypeQuery)compositeType.innerTypes().withFlags(1)).withInstanceOf((ITypeNameSupplier)scoutApi.IFormField())).stream().forEach(this::processFormField);
        ((HierarchyInnerTypeQuery)((HierarchyInnerTypeQuery)compositeType.innerTypes().withFlags(1)).withInstanceOf((ITypeNameSupplier)scoutApi.IFormFieldMenu())).stream().forEach(this::processInnerTypes);
        ((HierarchyInnerTypeQuery)compositeType.innerTypes().withInstanceOf((ITypeNameSupplier)scoutApi.ICompositeFieldExtension())).stream().forEach(this::processInnerTypes);
        ((HierarchyInnerTypeQuery)((HierarchyInnerTypeQuery)compositeType.innerTypes().withRecursiveInnerTypes(true)).withInstanceOf((ITypeNameSupplier)scoutApi.ITableExtension())).stream().forEach(this::processTableExtension);
    }

    protected void processFormField(IType formField) {
        IScoutApi scoutApi = this.scoutApi();
        FormDataAnnotationDescriptor fieldAnnotation = FormDataAnnotationDescriptor.of(formField);
        if (FormDataAnnotationDescriptor.isIgnore(fieldAnnotation)) {
            return;
        }
        boolean fieldExtendsTemplateField = false;
        boolean isCompositeField = formField.isInstanceOf((ITypeNameSupplier)scoutApi.ICompositeField());
        if (FormDataAnnotationDescriptor.isCreate(fieldAnnotation)) {
            AbstractDtoGenerator dtoGenerator;
            String formDataTypeName = CompositeFormDataGenerator.removeFieldSuffix(formField.elementName());
            if (fieldAnnotation.getSuperType().isInstanceOf((ITypeNameSupplier)scoutApi.AbstractTableFieldBeanData())) {
                dtoGenerator = new TableFieldDataGenerator(formField, fieldAnnotation, this.targetEnvironment());
            } else if (isCompositeField && !formField.isInstanceOf((ITypeNameSupplier)scoutApi.IValueField())) {
                fieldExtendsTemplateField = true;
                dtoGenerator = new CompositeFormDataGenerator<TYPE>(formField, fieldAnnotation, this.targetEnvironment());
            } else {
                dtoGenerator = new FormDataGenerator(formField, fieldAnnotation, this.targetEnvironment());
                this.methods().filter(msb -> this.hasSimilarNameAs((IMethodGenerator<?, ?>)msb, formDataTypeName)).findAny().ifPresent(msb -> dtoGenerator.withComment(b -> b.appendTodo((CharSequence)("Duplicate names '" + formDataTypeName + "'. Rename property or form field."))));
            }
            String methodName = Strings.capitalize((CharSequence)formDataTypeName).toString();
            ((CompositeFormDataGenerator)this.withType((ITypeGenerator)dtoGenerator.withElementName(formDataTypeName), DtoMemberSortObjectFactory.forTypeFormDataFormField(formDataTypeName))).withMethod(((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().asPublic()).withElementName("get" + methodName)).withReturnType(formDataTypeName)).withBody(b -> ((IScoutMethodBodyBuilder)b.returnClause()).appendGetFieldByClass(formDataTypeName).semicolon()), DtoMemberSortObjectFactory.forMethodFormDataFormField(methodName));
        }
        if (isCompositeField && !fieldExtendsTemplateField) {
            this.processInnerTypes(formField);
        }
    }

    protected boolean hasSimilarNameAs(IMethodGenerator<?, ?> msb, String formDataTypeName) {
        String dataType = (String)msb.returnType(this.currentBuilder().context()).orElseThrow();
        String name = PropertyBean.getterPrefixFor((CharSequence)dataType) + formDataTypeName;
        return name.equals(msb.elementName().orElseThrow());
    }

    protected void processTableExtension(IType tableExtension) {
        this.withType((ITypeGenerator)((TableRowDataGenerator)new TableRowDataGenerator(tableExtension, tableExtension, this.targetEnvironment()).withElementName(CompositeFormDataGenerator.getRowDataName(tableExtension.elementName()))).withExtendsAnnotationIfNecessary(tableExtension), DtoMemberSortObjectFactory.forTypeTableRowData(tableExtension.elementName()));
    }
}

