/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.dataobject;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.scout.sdk.core.model.api.IField;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.util.Strings;

public class DoContext {
    private final IType m_namespace;
    private final String m_namespaceId;
    private final IType m_typeVersion;

    protected DoContext() {
        this(null, null);
    }

    protected DoContext(IType namespace, IType typeVersion) {
        this.m_namespace = namespace;
        this.m_typeVersion = typeVersion;
        this.m_namespaceId = DoContext.parseId(namespace);
    }

    private static String parseId(IType namespace) {
        return Optional.ofNullable(namespace).flatMap(n -> n.fields().withName("ID").first()).flatMap(IField::constantValue).map(v -> (String)v.as(String.class)).orElse(null);
    }

    public Optional<IType> namespace() {
        return Optional.ofNullable(this.m_namespace);
    }

    public Optional<String> namespaceId() {
        return Strings.notBlank((CharSequence)this.m_namespaceId);
    }

    public Optional<IType> typeVersion() {
        return Optional.ofNullable(this.m_typeVersion);
    }

    public String toString() {
        return DoContext.class.getSimpleName() + " [namespace=" + (this.m_namespace == null ? null : this.m_namespace.name()) + ", namespaceId=" + this.m_namespaceId + ", typeVersion=" + (this.m_typeVersion == null ? null : this.m_typeVersion.name()) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoContext doContext = (DoContext)o;
        return Objects.equals(this.m_namespace, doContext.m_namespace) && Objects.equals(this.m_typeVersion, doContext.m_typeVersion);
    }

    public int hashCode() {
        int result = this.m_namespace != null ? this.m_namespace.hashCode() : 0;
        result = 31 * result + (this.m_typeVersion != null ? this.m_typeVersion.hashCode() : 0);
        return result;
    }
}

