/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.dataobject;

import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.eclipse.scout.sdk.core.model.api.IMethod;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.apidef.IScout22DoApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.util.Ensure;

public class DataObjectNode {
    private final DataObjectNodeKind m_kind;
    private final IMethod m_method;
    private final IType m_dataType;
    private final boolean m_inherited;
    private final boolean m_hasJavaDoc;

    public DataObjectNode(DataObjectNodeKind kind, IMethod method, IType dataType, boolean inherited, boolean hasJavaDoc) {
        this.m_kind = (DataObjectNodeKind)((Object)Ensure.notNull((Object)((Object)kind)));
        this.m_method = (IMethod)Ensure.notNull((Object)method);
        this.m_dataType = (IType)Ensure.notNull((Object)dataType);
        this.m_inherited = inherited;
        this.m_hasJavaDoc = hasJavaDoc;
    }

    public DataObjectNodeKind kind() {
        return this.m_kind;
    }

    public IMethod method() {
        return this.m_method;
    }

    public String name() {
        return this.m_method.elementName();
    }

    public IType dataType() {
        return this.m_dataType;
    }

    public boolean isInherited() {
        return this.m_inherited;
    }

    public boolean hasJavaDoc() {
        return this.m_hasJavaDoc;
    }

    public String toString() {
        return new StringJoiner(", ", DataObjectNode.class.getSimpleName() + " [", "]").add("name='" + this.name() + "'").add("kind=" + this.kind()).add("dataType='" + this.dataType() + "'").add("inherited=" + this.isInherited()).add("hasJavaDoc=" + this.hasJavaDoc()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataObjectNode that = (DataObjectNode)o;
        return this.m_inherited == that.m_inherited && this.m_hasJavaDoc == that.m_hasJavaDoc && this.m_kind == that.m_kind && Objects.equals(this.m_dataType, that.m_dataType) && Objects.equals(this.m_method, that.m_method);
    }

    public int hashCode() {
        int result = this.m_kind.hashCode();
        result = 31 * result + this.m_method.hashCode();
        result = 31 * result + this.m_dataType.hashCode();
        result = 31 * result + (this.m_inherited ? 1 : 0);
        result = 31 * result + (this.m_hasJavaDoc ? 1 : 0);
        return result;
    }

    public static enum DataObjectNodeKind {
        VALUE,
        LIST,
        SET,
        COLLECTION;


        public static Optional<DataObjectNodeKind> valueOf(IType type) {
            return Optional.ofNullable(type).flatMap(t -> t.javaEnvironment().api(IScoutApi.class).flatMap(api -> DataObjectNodeKind.detectDoNodeKind(api, t)));
        }

        static Optional<DataObjectNodeKind> detectDoNodeKind(IScoutApi scoutApi, IType t) {
            String name = t.name();
            if (scoutApi.DoValue().fqn().equals(name)) {
                return Optional.of(VALUE);
            }
            if (scoutApi.DoList().fqn().equals(name)) {
                return Optional.of(LIST);
            }
            return scoutApi.api(IScout22DoApi.class).flatMap(a -> DataObjectNodeKind.detectDoCollection(a, name));
        }

        static Optional<DataObjectNodeKind> detectDoCollection(IScout22DoApi extendedApi, String name) {
            if (extendedApi.DoSet().fqn().equals(name)) {
                return Optional.of(SET);
            }
            if (extendedApi.DoCollection().fqn().equals(name)) {
                return Optional.of(COLLECTION);
            }
            return Optional.empty();
        }
    }
}

