/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.ecj;

import java.util.List;
import org.eclipse.scout.sdk.core.model.api.IPackage;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.PackageImplementor;
import org.eclipse.scout.sdk.core.model.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public class PackageWithEcj
extends AbstractJavaElementWithEcj<IPackage>
implements PackageSpi {
    private final String m_name;
    private final FinalValue<TypeSpi> m_packageInfo;

    protected PackageWithEcj(AbstractJavaEnvironment env, String name) {
        super(env);
        this.m_name = name;
        this.m_packageInfo = new FinalValue();
    }

    public PackageSpi internalFindNewElement() {
        return this.getJavaEnvironment().getPackage(this.getElementName());
    }

    protected IPackage internalCreateApi() {
        return new PackageImplementor((PackageSpi)this);
    }

    public String getElementName() {
        return this.m_name;
    }

    public ISourceRange getSource() {
        return null;
    }

    public TypeSpi getPackageInfo() {
        return (TypeSpi)this.m_packageInfo.computeIfAbsentAndGet(() -> this.getJavaEnvironment().findType(this.getElementName() + ".package-info"));
    }

    public PackageSpi getParentPackage() {
        if (Strings.isBlank((CharSequence)this.m_name)) {
            return null;
        }
        int lastDot = this.m_name.lastIndexOf(46);
        if (lastDot < 0) {
            return this.javaEnvWithEcj().createDefaultPackage();
        }
        return this.javaEnvWithEcj().createPackage(this.m_name.substring(0, lastDot));
    }

    public List<? extends AnnotationSpi> getAnnotations() {
        throw new UnsupportedOperationException();
    }
}

