/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.ecj;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.ecj.ClasspathEntry;
import org.eclipse.scout.sdk.core.model.ecj.EcjAstCompiler;
import org.eclipse.scout.sdk.core.model.ecj.JavaEnvironmentWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.JreInfo;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;

public class JavaEnvironmentWithEcjBuilder<T extends JavaEnvironmentWithEcjBuilder<T>> {
    private final Path m_curDir = Paths.get("", new String[0]).toAbsolutePath().normalize();
    private final Map<String, Pattern> m_sourceExcludes = new HashMap<String, Pattern>();
    private final Map<String, Pattern> m_binaryExcludes = new HashMap<String, Pattern>();
    private final List<ClasspathEntry> m_paths = new ArrayList<ClasspathEntry>();
    private Path m_javaHome;
    private boolean m_parseMethodBodies;
    private boolean m_includeRunningClasspath = true;
    private boolean m_includeSources = true;

    public static JavaEnvironmentWithEcjBuilder<?> create() {
        return new JavaEnvironmentWithEcjBuilder();
    }

    public T withRunningClasspath(boolean b) {
        this.m_includeRunningClasspath = b;
        return this.thisInstance();
    }

    protected T thisInstance() {
        return (T)this;
    }

    public boolean isIncludeRunningClasspath() {
        return this.m_includeRunningClasspath;
    }

    public T withoutScoutSdk() {
        this.excludeIfContains("wsdl4j");
        this.exclude(".*" + Pattern.quote(".scout.sdk.") + ".*target/.*\\.jar");
        this.exclude(".*ecj-.*\\.jar");
        return this.exclude(".*" + Pattern.quote(".scout.sdk.") + ".*target/classes");
    }

    public Path javaHome() {
        return this.m_javaHome;
    }

    public T withJavaHome(Path javaHome) {
        this.m_javaHome = javaHome;
        return this.thisInstance();
    }

    public T exclude(String regex) {
        Pattern pat = Pattern.compile(regex, 2);
        this.m_sourceExcludes.put(regex, pat);
        this.m_binaryExcludes.put(regex, pat);
        return this.thisInstance();
    }

    public T excludeIfContains(String string) {
        return this.exclude(".*" + Pattern.quote(string) + ".*");
    }

    public T include(String regex) {
        this.m_sourceExcludes.remove(regex);
        this.m_binaryExcludes.remove(regex);
        return this.thisInstance();
    }

    public T withParseMethodBodies(boolean parseBodies) {
        this.m_parseMethodBodies = parseBodies;
        return this.thisInstance();
    }

    public boolean isParseMethodBodies() {
        return this.m_parseMethodBodies;
    }

    public T withSourcesIncluded(boolean includeSources) {
        this.m_includeSources = includeSources;
        return this.thisInstance();
    }

    public boolean isSourceIncluded() {
        return this.m_includeSources;
    }

    public T withoutSources(String regex) {
        this.m_sourceExcludes.put(regex, Pattern.compile(regex, 2));
        return this.thisInstance();
    }

    public T withSourceFolder(String sourceFolder) {
        return this.withSourceFolder(sourceFolder, null);
    }

    public T withSourceFolder(String sourceFolder, Charset encoding) {
        if (sourceFolder != null) {
            JavaEnvironmentWithEcjBuilder.appendSourcePath(this.m_curDir.resolve(sourceFolder), encoding, this.m_paths);
        }
        return this.thisInstance();
    }

    public T withClassesFolder(String classesFolder) {
        if (classesFolder != null) {
            JavaEnvironmentWithEcjBuilder.appendBinaryPath(this.m_curDir.resolve(classesFolder), this.m_paths);
        }
        return this.thisInstance();
    }

    public T withAbsoluteSourcePath(String sourcePath) {
        return this.withAbsoluteSourcePath(sourcePath, null);
    }

    public T withAbsoluteSourcePath(String sourcePath, Charset encoding) {
        if (sourcePath != null) {
            JavaEnvironmentWithEcjBuilder.appendSourcePath(Paths.get(sourcePath, new String[0]), encoding, this.m_paths);
        }
        return this.thisInstance();
    }

    public T withAbsoluteBinaryPath(String binaryPath) {
        if (binaryPath != null) {
            JavaEnvironmentWithEcjBuilder.appendBinaryPath(Paths.get(binaryPath, new String[0]), this.m_paths);
        }
        return this.thisInstance();
    }

    public Path currentDirectory() {
        return this.m_curDir;
    }

    protected void collectRunningClassPath(Collection<ClasspathEntry> collector, Collection<Path> sourceAttachmentFor) {
        JreInfo.runningUserClassPath(this.javaHome()).forEach(classpathItem -> this.filterAndAppendBinaryPath((Path)classpathItem, sourceAttachmentFor, collector));
    }

    protected void filterAndAppendBinaryPath(Path f, Collection<Path> sourceAttachmentForCollector, Collection<ClasspathEntry> collector) {
        if (JavaEnvironmentWithEcjBuilder.isExcluded(f, this.m_binaryExcludes.values())) {
            return;
        }
        sourceAttachmentForCollector.add(f);
        JavaEnvironmentWithEcjBuilder.appendBinaryPath(f, collector);
    }

    protected void filterAndAppendSourcePath(Path f, Collection<ClasspathEntry> collector) {
        if (JavaEnvironmentWithEcjBuilder.isExcluded(f, this.m_sourceExcludes.values())) {
            return;
        }
        JavaEnvironmentWithEcjBuilder.appendSourcePath(f, null, collector);
    }

    protected static boolean isExcluded(Path f, Collection<Pattern> exclusions) {
        if (f == null) {
            return true;
        }
        if (exclusions.isEmpty()) {
            return false;
        }
        String s = f.toString().replace(File.separatorChar, '/');
        return exclusions.stream().anyMatch(p -> p.matcher(s).matches());
    }

    protected static void appendBinaryPath(Path f, Collection<ClasspathEntry> collector) {
        JavaEnvironmentWithEcjBuilder.appendPath(f, false, null, collector);
    }

    protected static void appendSourcePath(Path f, Charset encoding, Collection<ClasspathEntry> collector) {
        JavaEnvironmentWithEcjBuilder.appendPath(f, true, encoding, collector);
    }

    protected static void appendPath(Path f, boolean isSource, Charset encoding, Collection<ClasspathEntry> collector) {
        if (f == null || !Files.isReadable(f)) {
            return;
        }
        String charsetName = Optional.ofNullable(encoding).map(Charset::name).orElse(null);
        collector.add(new ClasspathEntry(f, isSource ? 1 : 2, charsetName));
    }

    protected void appendSourceAttachments(Iterable<Path> sourceAttachmentsFor, Collection<ClasspathEntry> collector) {
        if (!this.isSourceIncluded()) {
            return;
        }
        for (Path path : sourceAttachmentsFor) {
            if (path.endsWith("target/classes")) {
                this.filterAndAppendSourcePath(path.getParent().getParent().resolve("src/main/java"), collector);
                this.filterAndAppendSourcePath(path.getParent().getParent().resolve("target/generated-sources/annotations"), collector);
                this.filterAndAppendSourcePath(path.getParent().getParent().resolve("target/generated-sources/wsimport"), collector);
                continue;
            }
            if (path.endsWith("target/test-classes")) {
                this.filterAndAppendSourcePath(path.getParent().getParent().resolve("src/test/java"), collector);
                continue;
            }
            String extension = CoreUtils.extensionOf((Path)path);
            if (!"jar".equals(extension) && !"zip".equals(extension)) continue;
            Object fileName = path.getFileName().toString();
            fileName = ((String)fileName).substring(0, ((String)fileName).length() - 4) + "-sources" + ((String)fileName).substring(((String)fileName).length() - 4);
            this.filterAndAppendSourcePath(path.getParent().resolve((String)fileName), collector);
        }
    }

    protected static Collection<ClasspathEntry> sort(Collection<ClasspathEntry> allEntries) {
        int numBuckets = 4;
        HashMap<Integer, List<ClasspathEntry>> buckets = new HashMap<Integer, List<ClasspathEntry>>(numBuckets);
        for (ClasspathEntry entry : allEntries) {
            buckets.computeIfAbsent(JavaEnvironmentWithEcjBuilder.bucketOf(entry), ArrayList::new).add(entry);
        }
        ArrayList<ClasspathEntry> grouped = new ArrayList<ClasspathEntry>(allEntries.size());
        for (int i = 0; i < numBuckets; ++i) {
            JavaEnvironmentWithEcjBuilder.addBucket(i, grouped, buckets);
        }
        return grouped;
    }

    protected static void addBucket(int index, Collection<ClasspathEntry> grouped, Map<Integer, List<ClasspathEntry>> buckets) {
        List<ClasspathEntry> bucketContent = buckets.get(index);
        if (bucketContent == null) {
            return;
        }
        grouped.addAll(bucketContent);
    }

    protected static Integer bucketOf(ClasspathEntry entry) {
        int result = 0;
        if (!Files.isDirectory(entry.path(), new LinkOption[0])) {
            ++result;
        }
        if (entry.mode() == 2) {
            result += 2;
        }
        return result;
    }

    protected JavaEnvironmentWithEcj build() {
        ArrayList<ClasspathEntry> allEntries = new ArrayList<ClasspathEntry>(this.m_paths);
        if (this.isIncludeRunningClasspath()) {
            LinkedHashSet<Path> sourceAttachmentFor = new LinkedHashSet<Path>();
            this.collectRunningClassPath(allEntries, sourceAttachmentFor);
            this.appendSourceAttachments(sourceAttachmentFor, allEntries);
        }
        CompilerOptions opts = EcjAstCompiler.createDefaultOptions();
        opts.ignoreMethodBodies = !this.isParseMethodBodies();
        return this.build(this.javaHome(), JavaEnvironmentWithEcjBuilder.sort(allEntries), opts);
    }

    protected JavaEnvironmentWithEcj build(Path javaHome, Collection<? extends ClasspathEntry> classpath, CompilerOptions options) {
        return new JavaEnvironmentWithEcj(javaHome, classpath, options);
    }

    public <R> R call(Function<IJavaEnvironment, R> task) {
        try (JavaEnvironmentWithEcj env = this.build();){
            Object r = ((Function)Ensure.notNull(task)).apply(env.wrap());
            return r;
        }
    }

    public void accept(Consumer<IJavaEnvironment> task) {
        this.call(env -> {
            ((Consumer)Ensure.notNull((Object)task)).accept(env);
            return null;
        });
    }
}

