/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.ecj;

import java.nio.CharBuffer;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.CompilationUnitInfo;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.SourceRange;
import org.eclipse.scout.sdk.core.model.ecj.AbstractMemberWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.AbstractTypeWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingAnnotationElementWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingAnnotationWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingArrayTypeWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingBaseTypeWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingFieldWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingMethodParameterWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingMethodWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingTypeParameterWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingTypeWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.ClasspathBuilder;
import org.eclipse.scout.sdk.core.model.ecj.ClasspathEntry;
import org.eclipse.scout.sdk.core.model.ecj.ClasspathWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.CompilationUnitOverrideSupport;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationAnnotationElementWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationAnnotationWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationCompilationUnitWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationFieldWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationImportWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationMethodParameterWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationMethodWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationTypeParameterWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.DeclarationTypeWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.EcjAstCompiler;
import org.eclipse.scout.sdk.core.model.ecj.FileSystemWithOverride;
import org.eclipse.scout.sdk.core.model.ecj.NullAnnotationElementWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.PackageWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.SameCompositeObject;
import org.eclipse.scout.sdk.core.model.ecj.SourcePositionComparators;
import org.eclipse.scout.sdk.core.model.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.model.ecj.StringBasedCompilationUnitWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.SyntheticCompilationUnitWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.TypeNameDescriptor;
import org.eclipse.scout.sdk.core.model.ecj.VoidTypeWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.WildcardOnlyTypeWithEcj;
import org.eclipse.scout.sdk.core.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.model.spi.ClasspathSpi;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public class JavaEnvironmentWithEcj
extends AbstractJavaEnvironment
implements AutoCloseable {
    private final Path m_javaHome;
    private final CompilerOptions m_options;
    private final Collection<? extends ClasspathEntry> m_rawClassPath;
    private final Map<Object, JavaElementSpi> m_elements;
    private final Map<ReferenceBinding, Map<String, ElementValuePair>> m_evpCache;
    private final Map<TypeBinding, Map<String, MemberValuePair>> m_mvpCache;
    private final Map<CharBuffer, char[]> m_sourceCache;
    private FinalValue<FileSystemWithOverride> m_fs;
    private FinalValue<EcjAstCompiler> m_compiler;
    private FinalValue<List<ClasspathSpi>> m_classpath;
    private FileSystemWithOverride m_oldFsDuringReload;
    private volatile boolean m_initialized;

    protected JavaEnvironmentWithEcj(Path javaHome, Collection<? extends ClasspathEntry> classpath, CompilerOptions options) {
        this.m_javaHome = javaHome;
        this.m_options = options;
        this.m_rawClassPath = JavaEnvironmentWithEcj.withoutNullElements(classpath);
        this.m_elements = new ConcurrentHashMap<Object, JavaElementSpi>();
        this.m_evpCache = new ConcurrentHashMap<ReferenceBinding, Map<String, ElementValuePair>>();
        this.m_mvpCache = new ConcurrentHashMap<TypeBinding, Map<String, MemberValuePair>>();
        this.m_sourceCache = new HashMap<CharBuffer, char[]>();
        this.m_fs = new FinalValue();
        this.m_compiler = new FinalValue();
        this.m_classpath = new FinalValue();
        this.m_initialized = true;
    }

    protected static <T> List<T> withoutNullElements(Collection<T> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected TypeSpi doFindType(String fqn) {
        this.assertInitialized();
        TypeNameDescriptor desc = TypeNameDescriptor.of(fqn);
        if (desc.getArrayDimension() <= 0) {
            return this.resolveAsType(desc);
        }
        return this.resolveAsArray(desc);
    }

    protected TypeSpi resolveAsType(TypeNameDescriptor desc) {
        TypeBinding binding = this.lookupTypeBinding(desc.getPrimaryTypeName());
        if (binding == null) {
            return null;
        }
        TypeSpi result = SpiWithEcjUtils.bindingToType(this, binding, () -> {
            AbstractTypeWithEcj type = (AbstractTypeWithEcj)this.findType(desc.getFullyQualifiedName());
            if (type == null) {
                return null;
            }
            return type.getInternalBinding();
        });
        if (!desc.hasInnerType()) {
            return result;
        }
        return JavaEnvironmentWithEcj.findInnerType(result, desc.getInnerTypeNames());
    }

    protected static TypeSpi findInnerType(TypeSpi primaryType, String innerTypes) {
        TypeSpi result = primaryType;
        StringTokenizer st = new StringTokenizer(innerTypes, "$", false);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            TypeSpi innerType = result.getTypes().stream().filter(t -> t.getElementName().equals(name)).findFirst().orElse(null);
            if (innerType == null) {
                return null;
            }
            result = innerType;
        }
        return result;
    }

    protected TypeBinding getArrayTypeBinding(TypeNameDescriptor desc) {
        TypeSpi elementType = this.resolveAsType(desc);
        if (elementType == null) {
            return null;
        }
        TypeBinding elementTypeBinding = ((AbstractTypeWithEcj)elementType).getInternalBinding();
        return this.getCompiler().lookupEnvironment.createArrayType(elementTypeBinding, desc.getArrayDimension());
    }

    protected TypeSpi resolveAsArray(TypeNameDescriptor desc) {
        return SpiWithEcjUtils.bindingToType(this, this.getArrayTypeBinding(desc), () -> this.getArrayTypeBinding(desc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeBinding lookupTypeBinding(String fqn) {
        ReferenceBinding binding;
        if (fqn.length() <= 7) {
            switch (fqn) {
                case "boolean": {
                    return TypeBinding.BOOLEAN;
                }
                case "char": {
                    return TypeBinding.CHAR;
                }
                case "byte": {
                    return TypeBinding.BYTE;
                }
                case "short": {
                    return TypeBinding.SHORT;
                }
                case "int": {
                    return TypeBinding.INT;
                }
                case "long": {
                    return TypeBinding.LONG;
                }
                case "float": {
                    return TypeBinding.FLOAT;
                }
                case "double": {
                    return TypeBinding.DOUBLE;
                }
                case "void": {
                    return TypeBinding.VOID;
                }
            }
        }
        char[][] lookupName = CharOperation.splitOn((char)'.', (char[])fqn.toCharArray());
        Object object = this.lock();
        synchronized (object) {
            binding = this.getCompiler().lookupEnvironment.getType(lookupName);
        }
        if (binding instanceof MissingTypeBinding) {
            return null;
        }
        return binding;
    }

    protected Collection<JavaElementSpi> allElements() {
        return this.m_elements.values();
    }

    public Path javaHome() {
        return this.m_javaHome;
    }

    protected void onReloadStart() {
        this.runPreservingOverrides(this, this, this::doReloadStart);
    }

    private void doReloadStart() {
        this.m_oldFsDuringReload = (FileSystemWithOverride)((Object)this.m_fs.get());
        this.clear(false);
        this.m_initialized = true;
    }

    protected boolean isInitialized() {
        return this.m_initialized;
    }

    protected void assertInitialized() {
        if (this.isInitialized()) {
            return;
        }
        Ensure.fail((CharSequence)"JavaEnvironment has already been closed.", (Object[])new Object[0]);
    }

    @Override
    public void close() {
        this.runPreservingOverrides(this, this, this::doClose);
    }

    private void doClose() {
        this.clear(true);
        this.m_initialized = false;
    }

    private void clear(boolean closeFs) {
        this.cleanup();
        this.m_elements.clear();
        this.m_evpCache.clear();
        this.m_mvpCache.clear();
        this.m_sourceCache.clear();
        FileSystemWithOverride oldFs = (FileSystemWithOverride)((Object)this.m_fs.get());
        this.m_fs = new FinalValue();
        if (closeFs && oldFs != null) {
            oldFs.cleanup();
        }
        this.m_compiler = new FinalValue();
        this.m_classpath = new FinalValue();
    }

    protected void onReloadEnd() {
        super.onReloadEnd();
        FileSystemWithOverride oldFs = this.m_oldFsDuringReload;
        if (oldFs != null) {
            oldFs.cleanup();
            this.m_oldFsDuringReload = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPreservingOverrides(JavaEnvironmentWithEcj src, JavaEnvironmentWithEcj dest, Runnable task) {
        Object object = this.lock();
        synchronized (object) {
            ArrayList units = new ArrayList(src.m_fs.opt().map(FileSystemWithOverride::overrideSupport).map(CompilationUnitOverrideSupport::getCompilationUnits).orElse(Collections.emptyList()));
            if (task != null) {
                task.run();
            }
            if (units.isEmpty()) {
                return;
            }
            CompilationUnitOverrideSupport overrideSupport = dest.getNameEnvironment().overrideSupport();
            for (ICompilationUnit cu : units) {
                overrideSupport.addCompilationUnit(cu);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCompileErrors(TypeSpi typeSpi) {
        CompilationUnitSpi cuSpi = ((TypeSpi)Ensure.notNull((Object)typeSpi)).getCompilationUnit();
        CompilationUnitDeclaration decl = ((DeclarationCompilationUnitWithEcj)((Object)Ensure.instanceOf((Object)cuSpi, DeclarationCompilationUnitWithEcj.class, (CharSequence)"Type '{}' is not a source type.", (Object[])new Object[]{typeSpi.getName()}))).getInternalCompilationUnitDeclaration();
        Object object = this.lock();
        synchronized (object) {
            return this.getCompiler().getCompileErrors(decl);
        }
    }

    public List<String> getCompileErrors(String fqn) {
        return this.getCompileErrors((TypeSpi)Ensure.notNull((Object)this.findType(fqn), (CharSequence)"Cannot find type '{}'.", (Object[])new Object[]{fqn}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerCompilationUnitOverride(char[] src, CompilationUnitInfo cuInfo) {
        Ensure.notNull((Object)cuInfo);
        Ensure.notNull((Object)src);
        StringBasedCompilationUnitWithEcj cu = new StringBasedCompilationUnitWithEcj(cuInfo, src, null);
        Object object = this.lock();
        synchronized (object) {
            boolean reloadRequired = this.getNameEnvironment().overrideSupport().addCompilationUnit(cu);
            String fqn = cu.getFullyQualifiedName();
            this.removeTypeFromCache(fqn);
            if (!reloadRequired && this.isInitialized()) {
                reloadRequired = this.isLoadedInCompiler(fqn, src);
            }
            if (!Strings.isEmpty((CharSequence)cuInfo.packageName()) && this.isInitialized()) {
                this.getCompiler().lookupEnvironment.createPackage(cu.getPackageName());
            }
            if (reloadRequired) {
                this.m_sourceCache.keySet().removeIf(cuFileName -> CharOperation.endsWith((char[])cuFileName.array(), (char[])cu.getFileName()));
            }
            return reloadRequired;
        }
    }

    private boolean isLoadedInCompiler(String fqn, char[] src) {
        ReferenceBinding cachedType = this.findExistingBindingFor(fqn);
        if (cachedType == null) {
            return false;
        }
        if (cachedType instanceof SourceTypeBinding) {
            CompilationUnitDeclaration decl = ((SourceTypeBinding)cachedType).scope.compilationUnitScope().referenceContext;
            char[] existing = this.getSource(decl);
            return !Arrays.equals(existing, src);
        }
        return true;
    }

    private ReferenceBinding findExistingBindingFor(String fqn) {
        LookupEnvironment lookupEnvironment = this.getCompiler().lookupEnvironment;
        char[][] compoundName = CharOperation.splitOn((char)'.', (char[])fqn.toCharArray());
        ReferenceBinding cachedType = lookupEnvironment.getCachedType(compoundName);
        if (cachedType != null) {
            return cachedType;
        }
        return Arrays.stream(lookupEnvironment.knownModules.valueTable).filter(Objects::nonNull).map(module -> module.environment.getCachedType(compoundName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public ISourceRange getSource(CompilationUnitSpi cu, int start, int end) {
        if (!(cu instanceof DeclarationCompilationUnitWithEcj)) {
            return null;
        }
        this.assertInitialized();
        char[] src = this.getSource(((DeclarationCompilationUnitWithEcj)cu).getInternalCompilationUnitDeclaration());
        if (src == null) {
            return null;
        }
        return new SourceRange((CharSequence)CharBuffer.wrap(src, start, end - start + 1), start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] getSource(CompilationUnitDeclaration decl) {
        Object object = this.lock();
        synchronized (object) {
            ICompilationUnit sourceUnit = this.getCompiler().getSource(decl);
            if (sourceUnit == null) {
                return null;
            }
            return this.m_sourceCache.computeIfAbsent(CharBuffer.wrap(sourceUnit.getFileName()), k -> sourceUnit.getContents());
        }
    }

    protected FileSystemWithOverride getNameEnvironment() {
        return (FileSystemWithOverride)((Object)this.m_fs.computeIfAbsentAndGet(this::buildNameEnvironment));
    }

    private FileSystemWithOverride buildNameEnvironment() {
        ClasspathBuilder cp = new ClasspathBuilder(this.javaHome(), this.m_rawClassPath);
        while (true) {
            try {
                return new FileSystemWithOverride(cp);
            }
            catch (FileSystemAlreadyExistsException e) {
                SdkLog.debug((CharSequence)"Concurrent registration of process wide filesystem.", (Object[])new Object[]{SdkLog.onTrace((Object)e)});
                continue;
            }
            break;
        }
    }

    private EcjAstCompiler getCompiler() {
        return (EcjAstCompiler)((Object)this.m_compiler.computeIfAbsentAndGet(() -> new EcjAstCompiler((INameEnvironment)this.getNameEnvironment(), this.m_options, this.lock())));
    }

    public List<ClasspathSpi> getClasspath() {
        return (List)this.m_classpath.computeIfAbsentAndGet(() -> this.m_rawClassPath.stream().map(this::classpathEntryToSpi).toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoidTypeWithEcj createVoidType() {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            return (VoidTypeWithEcj)this.m_elements.computeIfAbsent(VoidTypeWithEcj.class, k -> new VoidTypeWithEcj(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WildcardOnlyTypeWithEcj createWildcardOnlyType() {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            return (WildcardOnlyTypeWithEcj)this.m_elements.computeIfAbsent(WildcardOnlyTypeWithEcj.class, k -> new WildcardOnlyTypeWithEcj(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingAnnotationWithEcj createBindingAnnotation(AnnotatableSpi owner, AnnotationBinding binding) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(binding, owner);
            return (BindingAnnotationWithEcj)this.m_elements.computeIfAbsent(key, k -> new BindingAnnotationWithEcj(this, owner, binding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingAnnotationElementWithEcj createBindingAnnotationValue(AnnotationSpi owner, ElementValuePair bindingPair, boolean syntheticDefaultValue) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(owner, bindingPair);
            return (BindingAnnotationElementWithEcj)this.m_elements.computeIfAbsent(key, k -> new BindingAnnotationElementWithEcj(this, owner, bindingPair, syntheticDefaultValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NullAnnotationElementWithEcj createNullAnnotationValue(AnnotationSpi owner, String name, boolean syntheticDefaultValue) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(NullAnnotationElementWithEcj.class, owner, name);
            return (NullAnnotationElementWithEcj)this.m_elements.computeIfAbsent(key, k -> new NullAnnotationElementWithEcj(this, owner, name, syntheticDefaultValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingArrayTypeWithEcj createBindingArrayType(ArrayBinding binding, boolean isWildcard, Supplier<ArrayBinding> newElementLookupStrategy) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(binding, isWildcard);
            return (BindingArrayTypeWithEcj)this.m_elements.computeIfAbsent(key, k -> new BindingArrayTypeWithEcj(this, binding, isWildcard, newElementLookupStrategy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingBaseTypeWithEcj createBindingBaseType(BaseTypeBinding binding) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(binding);
            return (BindingBaseTypeWithEcj)this.m_elements.computeIfAbsent(key, k -> new BindingBaseTypeWithEcj(this, binding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingFieldWithEcj createBindingField(AbstractTypeWithEcj declaringType, FieldBinding binding) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(binding);
            return (BindingFieldWithEcj)this.m_elements.computeIfAbsent(key, k -> new BindingFieldWithEcj(this, declaringType, binding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingMethodWithEcj createBindingMethod(BindingTypeWithEcj declaringType, MethodBinding binding) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(binding);
            return (BindingMethodWithEcj)this.m_elements.computeIfAbsent(key, k -> new BindingMethodWithEcj(this, declaringType, binding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingMethodParameterWithEcj createBindingMethodParameter(BindingMethodWithEcj declaringMethod, TypeBinding binding, char[] name, int flags, int index) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(new Object[]{BindingMethodParameterWithEcj.class, declaringMethod, binding, index});
            return (BindingMethodParameterWithEcj)this.m_elements.computeIfAbsent(key, k -> new BindingMethodParameterWithEcj(this, declaringMethod, binding, name, flags, index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingTypeWithEcj createBindingType(ReferenceBinding binding, TypeSpi declaringType, boolean isWildcard, Supplier<? extends ReferenceBinding> newElementLookupStrategy) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(binding, isWildcard);
            return (BindingTypeWithEcj)this.m_elements.computeIfAbsent(key, k -> new BindingTypeWithEcj(this, binding, declaringType, isWildcard, newElementLookupStrategy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindingTypeParameterWithEcj createBindingTypeParameter(AbstractMemberWithEcj<?> declaringMember, TypeVariableBinding binding, int index) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(new Object[]{declaringMember, binding, index});
            return (BindingTypeParameterWithEcj)this.m_elements.computeIfAbsent(key, k -> new BindingTypeParameterWithEcj(this, declaringMember, binding, index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationAnnotationWithEcj createDeclarationAnnotation(AnnotatableSpi owner, Annotation astNode) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(astNode);
            return (DeclarationAnnotationWithEcj)this.m_elements.computeIfAbsent(key, k -> new DeclarationAnnotationWithEcj(this, owner, astNode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationAnnotationElementWithEcj createDeclarationAnnotationValue(AnnotationSpi declaringAnnotation, MemberValuePair astNode, boolean syntheticDefaultValue) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(astNode);
            return (DeclarationAnnotationElementWithEcj)this.m_elements.computeIfAbsent(key, k -> new DeclarationAnnotationElementWithEcj(this, declaringAnnotation, astNode, syntheticDefaultValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationCompilationUnitWithEcj createDeclarationCompilationUnit(CompilationUnitDeclaration astNode) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(astNode);
            return (DeclarationCompilationUnitWithEcj)this.m_elements.computeIfAbsent(key, k -> new DeclarationCompilationUnitWithEcj(this, astNode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationFieldWithEcj createDeclarationField(DeclarationTypeWithEcj declaringType, FieldDeclaration astNode) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(astNode);
            return (DeclarationFieldWithEcj)this.m_elements.computeIfAbsent(key, k -> new DeclarationFieldWithEcj(this, declaringType, astNode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationImportWithEcj createDeclarationImport(DeclarationCompilationUnitWithEcj owner, ImportReference astNode) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(astNode);
            return (DeclarationImportWithEcj)this.m_elements.computeIfAbsent(key, k -> new DeclarationImportWithEcj(this, owner, astNode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationMethodWithEcj createDeclarationMethod(DeclarationTypeWithEcj declaringType, AbstractMethodDeclaration astNode) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(astNode);
            return (DeclarationMethodWithEcj)this.m_elements.computeIfAbsent(key, k -> new DeclarationMethodWithEcj(this, declaringType, astNode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationMethodParameterWithEcj createDeclarationMethodParameter(DeclarationMethodWithEcj declaringMethod, Argument astNode, int index) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(astNode);
            return (DeclarationMethodParameterWithEcj)this.m_elements.computeIfAbsent(key, k -> new DeclarationMethodParameterWithEcj(this, declaringMethod, astNode, index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationTypeWithEcj createDeclarationType(CompilationUnitSpi cu, DeclarationTypeWithEcj declaringType, TypeDeclaration astNode) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(astNode);
            return (DeclarationTypeWithEcj)this.m_elements.computeIfAbsent(key, k -> new DeclarationTypeWithEcj(this, cu, declaringType, astNode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationTypeParameterWithEcj createDeclarationTypeParameter(AbstractMemberWithEcj<?> declaringMember, TypeParameter astNode, int index) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(astNode);
            return (DeclarationTypeParameterWithEcj)this.m_elements.computeIfAbsent(key, k -> new DeclarationTypeParameterWithEcj(this, declaringMember, astNode, index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageWithEcj createPackage(String name) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            CompositeObject key = new CompositeObject(new Object[]{PackageWithEcj.class, name});
            return (PackageWithEcj)this.m_elements.computeIfAbsent(key, k -> new PackageWithEcj(this, name));
        }
    }

    public PackageWithEcj createDefaultPackage() {
        return this.createPackage(null);
    }

    public PackageSpi getPackage(String name) {
        return this.createPackage(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyntheticCompilationUnitWithEcj createSyntheticCompilationUnit(BindingTypeWithEcj mainType) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            SameCompositeObject key = new SameCompositeObject(new Object[]{SyntheticCompilationUnitWithEcj.class, mainType});
            return (SyntheticCompilationUnitWithEcj)this.m_elements.computeIfAbsent(key, k -> new SyntheticCompilationUnitWithEcj(this, mainType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ElementValuePair> getBindingAnnotationSyntheticDefaultValues(ReferenceBinding annotationType) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            return this.m_evpCache.computeIfAbsent(annotationType, JavaEnvironmentWithEcj::computeBindingAnnotationSyntheticDefaultValues);
        }
    }

    protected static Map<String, ElementValuePair> computeBindingAnnotationSyntheticDefaultValues(ReferenceBinding annotationType) {
        MethodBinding[] valueMethods = annotationType.methods();
        if (valueMethods == null || valueMethods.length < 1) {
            return Collections.emptyMap();
        }
        valueMethods = Arrays.copyOf(valueMethods, valueMethods.length);
        Arrays.sort(valueMethods, SourcePositionComparators.MethodBindingComparator.INSTANCE);
        LinkedHashMap<String, ElementValuePair> defaultValues = new LinkedHashMap<String, ElementValuePair>(valueMethods.length);
        for (MethodBinding mb : valueMethods) {
            String name = new String(mb.selector);
            Object value = mb.getDefaultValue();
            if (value != null) {
                defaultValues.put(name, new ElementValuePair(mb.selector, value, mb));
                continue;
            }
            defaultValues.put(name, null);
        }
        return Collections.unmodifiableMap(defaultValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MemberValuePair> getDeclarationAnnotationSyntheticDefaultValues(TypeBinding typeBinding) {
        this.assertInitialized();
        Object object = this.lock();
        synchronized (object) {
            return this.m_mvpCache.computeIfAbsent(typeBinding, JavaEnvironmentWithEcj::computeDeclarationAnnotationSyntheticDefaultValues);
        }
    }

    protected static Map<String, MemberValuePair> computeDeclarationAnnotationSyntheticDefaultValues(TypeBinding typeBinding) {
        MethodBinding[] valueMethods = ((ReferenceBinding)typeBinding).methods();
        if (valueMethods == null || valueMethods.length < 1) {
            return Collections.emptyMap();
        }
        valueMethods = Arrays.copyOf(valueMethods, valueMethods.length);
        Arrays.sort(valueMethods, SourcePositionComparators.MethodBindingComparator.INSTANCE);
        LinkedHashMap<String, MemberValuePair> defaultValues = new LinkedHashMap<String, MemberValuePair>(valueMethods.length);
        for (MethodBinding mb : valueMethods) {
            String name = new String(mb.selector);
            AbstractMethodDeclaration md0 = (AbstractMethodDeclaration)Ensure.notNull((Object)SpiWithEcjUtils.sourceMethodOf(mb), (CharSequence)"binding is binary. Source method could not be found.", (Object[])new Object[0]);
            if (!(md0 instanceof AnnotationMethodDeclaration)) continue;
            AnnotationMethodDeclaration md = (AnnotationMethodDeclaration)md0;
            if (md.defaultValue != null) {
                defaultValues.put(name, new MemberValuePair(mb.selector, md.defaultValue.sourceStart, md.defaultValue.sourceEnd, md.defaultValue));
                continue;
            }
            defaultValues.put(name, null);
        }
        return Collections.unmodifiableMap(defaultValues);
    }

    protected ClasspathSpi classpathEntryToSpi(ClasspathEntry entry) {
        return new ClasspathWithEcj(entry, this);
    }
}

