/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.ecj;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class ClasspathEntry {
    private final Path m_classpath;
    private final int m_mode;
    private final String m_encoding;

    public ClasspathEntry(Path classpath, int mode, String encoding) {
        this.m_classpath = (Path)Ensure.notNull((Object)classpath);
        this.m_mode = mode;
        this.m_encoding = Strings.isBlank((CharSequence)encoding) ? StandardCharsets.UTF_8.name() : encoding;
    }

    public Path path() {
        return this.m_classpath;
    }

    public String encoding() {
        return this.m_encoding;
    }

    public int mode() {
        return this.m_mode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClasspathEntry [");
        builder.append("path=").append(this.m_classpath).append(", ");
        builder.append("mode=");
        boolean sourceAttached = false;
        if ((this.m_mode & 1) != 0) {
            builder.append("source");
            sourceAttached = true;
        }
        if ((this.m_mode & 2) != 0) {
            if (sourceAttached) {
                builder.append('&');
            }
            builder.append("binary");
        }
        builder.append(", encoding=").append(this.m_encoding);
        builder.append(']');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = prime + this.m_classpath.hashCode();
        return prime * result + this.m_mode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClasspathEntry other = (ClasspathEntry)obj;
        return this.m_mode == other.m_mode && this.m_classpath.equals(other.m_classpath);
    }
}

