/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.ecj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.MissingTypeException;
import org.eclipse.scout.sdk.core.model.api.internal.TypeImplementor;
import org.eclipse.scout.sdk.core.model.ecj.AbstractTypeWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingAnnotationWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingFieldWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.BindingMethodWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.JavaEnvironmentWithEcj;
import org.eclipse.scout.sdk.core.model.ecj.SourcePositionComparators;
import org.eclipse.scout.sdk.core.model.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class BindingTypeWithEcj
extends AbstractTypeWithEcj {
    private final ReferenceBinding m_binding;
    private final boolean m_isWildcard;
    private final FinalValue<PackageSpi> m_package;
    private final FinalValue<TypeSpi> m_declaringType;
    private final FinalValue<TypeSpi> m_superClass;
    private final FinalValue<String> m_elementName;
    private final FinalValue<String> m_name;
    private final FinalValue<List<TypeSpi>> m_memberTypes;
    private final FinalValue<List<TypeSpi>> m_superInterfaces;
    private final FinalValue<List<TypeParameterSpi>> m_typeParameters;
    private final FinalValue<List<TypeSpi>> m_typeArguments;
    private final FinalValue<List<BindingAnnotationWithEcj>> m_annotations;
    private final FinalValue<List<MethodSpi>> m_methods;
    private final FinalValue<List<FieldSpi>> m_fields;
    private final FinalValue<SourceTypeBinding> m_sourceTypeBindingRef;
    private final FinalValue<CompilationUnitSpi> m_unit;
    private final FinalValue<ISourceRange> m_source;
    private final FinalValue<ISourceRange> m_javaDocSource;
    private final FinalValue<ISourceRange> m_staticInitSource;
    private final Supplier<? extends ReferenceBinding> m_newElementLookupStrategy;
    private int m_flags;

    protected BindingTypeWithEcj(AbstractJavaEnvironment env, ReferenceBinding binding, TypeSpi declaringType, boolean isWildcard, Supplier<? extends ReferenceBinding> newElementLookupStrategy) {
        super(env);
        if (binding == null || binding instanceof MissingTypeBinding || binding instanceof ProblemReferenceBinding) {
            throw new MissingTypeException(String.valueOf(binding));
        }
        this.m_binding = (ReferenceBinding)Ensure.notNull((Object)binding);
        this.m_newElementLookupStrategy = (Supplier)Ensure.notNull(newElementLookupStrategy);
        this.m_isWildcard = isWildcard;
        this.m_declaringType = new FinalValue();
        if (declaringType != null) {
            this.m_declaringType.set((Object)declaringType);
        }
        this.m_flags = -1;
        this.m_package = new FinalValue();
        this.m_superClass = new FinalValue();
        this.m_elementName = new FinalValue();
        this.m_name = new FinalValue();
        this.m_memberTypes = new FinalValue();
        this.m_superInterfaces = new FinalValue();
        this.m_typeParameters = new FinalValue();
        this.m_typeArguments = new FinalValue();
        this.m_annotations = new FinalValue();
        this.m_methods = new FinalValue();
        this.m_fields = new FinalValue();
        this.m_sourceTypeBindingRef = new FinalValue();
        this.m_unit = new FinalValue();
        this.m_source = new FinalValue();
        this.m_javaDocSource = new FinalValue();
        this.m_staticInitSource = new FinalValue();
    }

    static PackageSpi packageOf(TypeBinding binding, JavaEnvironmentWithEcj env) {
        char[] qualifiedPackageName = binding.qualifiedPackageName();
        if (qualifiedPackageName == null || qualifiedPackageName.length < 1) {
            return env.createDefaultPackage();
        }
        return env.createPackage(new String(qualifiedPackageName));
    }

    public TypeSpi internalFindNewElement() {
        TypeSpi same = SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), (TypeBinding)this.m_newElementLookupStrategy.get(), this.getDeclaringType(), this.m_isWildcard, this.m_newElementLookupStrategy);
        if (same != null) {
            return same;
        }
        if (this.m_binding instanceof ParameterizedTypeBinding) {
            return null;
        }
        return this.getJavaEnvironment().findType(this.getName());
    }

    protected IType internalCreateApi() {
        return new TypeImplementor((TypeSpi)this);
    }

    public ClassScope getInternalClassScope() {
        SourceTypeBinding stb = this.getSourceTypeBinding();
        return stb != null ? stb.scope : null;
    }

    public ReferenceBinding getInternalBinding() {
        return this.m_binding;
    }

    public int getArrayDimension() {
        return 0;
    }

    public TypeSpi getLeafComponentType() {
        return null;
    }

    public CompilationUnitSpi getCompilationUnit() {
        return (CompilationUnitSpi)this.m_unit.computeIfAbsentAndGet(() -> {
            CompilationUnitScope cuScope;
            ClassScope scope = this.getInternalClassScope();
            if (scope != null && (cuScope = scope.compilationUnitScope()) != null) {
                return this.javaEnvWithEcj().createDeclarationCompilationUnit(cuScope.referenceContext);
            }
            TypeSpi parent = this.getDeclaringType();
            if (parent == null) {
                return this.javaEnvWithEcj().createSyntheticCompilationUnit(this);
            }
            return parent.getCompilationUnit();
        });
    }

    public boolean isPrimitive() {
        return false;
    }

    public PackageSpi getPackage() {
        return (PackageSpi)this.m_package.computeIfAbsentAndGet(() -> BindingTypeWithEcj.packageOf((TypeBinding)this.m_binding, this.javaEnvWithEcj()));
    }

    public String getName() {
        return (String)this.m_name.computeIfAbsentAndGet(() -> {
            if (this.isAnonymous()) {
                return new String(this.m_binding.sourceName);
            }
            return SpiWithEcjUtils.qualifiedNameOf(this.m_binding.qualifiedPackageName(), this.m_binding.qualifiedSourceName());
        });
    }

    public String getElementName() {
        return (String)this.m_elementName.computeIfAbsentAndGet(() -> new String(this.m_binding.sourceName));
    }

    public List<FieldSpi> getFields() {
        return (List)this.m_fields.computeIfAbsentAndGet(() -> {
            FieldBinding[] fields;
            this.getSourceTypeBinding();
            Object object = this.javaEnvWithEcj().lock();
            synchronized (object) {
                fields = this.m_binding.fields();
            }
            if (fields == null || fields.length < 1) {
                return Collections.emptyList();
            }
            fields = Arrays.copyOf(fields, fields.length);
            Arrays.sort(fields, SourcePositionComparators.FieldBindingComparator.INSTANCE);
            ArrayList<BindingFieldWithEcj> result = new ArrayList<BindingFieldWithEcj>(fields.length);
            for (FieldBinding fd : fields) {
                if (fd.isSynthetic()) continue;
                result.add(this.javaEnvWithEcj().createBindingField(this, fd));
            }
            return result;
        });
    }

    public List<MethodSpi> getMethods() {
        return (List)this.m_methods.computeIfAbsentAndGet(() -> {
            MethodBinding[] methods;
            Object object = this.javaEnvWithEcj().lock();
            synchronized (object) {
                this.getSourceTypeBinding();
                methods = this.m_binding.methods();
            }
            if (methods == null || methods.length < 1) {
                return Collections.emptyList();
            }
            methods = Arrays.copyOf(methods, methods.length);
            Arrays.sort(methods, SourcePositionComparators.MethodBindingComparator.INSTANCE);
            ArrayList<BindingMethodWithEcj> result = new ArrayList<BindingMethodWithEcj>(methods.length);
            for (MethodBinding a : methods) {
                if ((a.modifiers & 0x4000000) != 0 || a.isBridge() || a.isSynthetic() || a.isDefaultAbstract() || a.isConstructor() && a.sourceMethod() != null && a.sourceMethod().bodyStart == 0) continue;
                result.add(this.javaEnvWithEcj().createBindingMethod(this, a));
            }
            return result;
        });
    }

    public List<TypeSpi> getTypes() {
        return (List)this.m_memberTypes.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingsToTypes(this.javaEnvWithEcj(), (TypeBinding[])BindingTypeWithEcj.computeMemberTypes(this), this, () -> (TypeBinding[])this.withNewElement(BindingTypeWithEcj::computeMemberTypes)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ReferenceBinding[] computeMemberTypes(BindingTypeWithEcj owner) {
        ReferenceBinding[] memberTypes;
        Object object = owner.javaEnvWithEcj().lock();
        synchronized (object) {
            owner.getSourceTypeBinding();
            memberTypes = owner.m_binding.memberTypes();
        }
        if (memberTypes == null || memberTypes.length < 1) {
            return Binding.NO_MEMBER_TYPES;
        }
        memberTypes = Arrays.copyOf(memberTypes, memberTypes.length);
        Arrays.sort(memberTypes, SourcePositionComparators.TypeBindingComparator.INSTANCE);
        return memberTypes;
    }

    protected static ReferenceBinding getEnclosingTypeBinding(BindingTypeWithEcj t) {
        return t.m_binding.enclosingType();
    }

    public TypeSpi getDeclaringType() {
        return (TypeSpi)this.m_declaringType.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), (TypeBinding)BindingTypeWithEcj.getEnclosingTypeBinding(this), null, false, () -> (TypeBinding)this.withNewElement(BindingTypeWithEcj::getEnclosingTypeBinding)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ReferenceBinding getSuperClassBinding(BindingTypeWithEcj ref) {
        Object object = ref.javaEnvWithEcj().lock();
        synchronized (object) {
            ref.getSourceTypeBinding();
            return ref.m_binding.superclass();
        }
    }

    public TypeSpi getSuperClass() {
        return (TypeSpi)this.m_superClass.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), (TypeBinding)BindingTypeWithEcj.getSuperClassBinding(this), () -> (TypeBinding)this.withNewElement(BindingTypeWithEcj::getSuperClassBinding)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ReferenceBinding[] getSuperInterfaceBindings(BindingTypeWithEcj ref) {
        Object object = ref.javaEnvWithEcj().lock();
        synchronized (object) {
            ref.getSourceTypeBinding();
            return ref.m_binding.superInterfaces();
        }
    }

    public List<TypeSpi> getSuperInterfaces() {
        return (List)this.m_superInterfaces.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingsToTypes(this.javaEnvWithEcj(), (TypeBinding[])BindingTypeWithEcj.getSuperInterfaceBindings(this), () -> (TypeBinding[])this.withNewElement(BindingTypeWithEcj::getSuperInterfaceBindings)));
    }

    public boolean isWildcardType() {
        return this.m_isWildcard;
    }

    public List<TypeSpi> getTypeArguments() {
        return (List)this.m_typeArguments.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingsToTypes(this.javaEnvWithEcj(), BindingTypeWithEcj.computeTypeArguments(this), () -> (TypeBinding[])this.withNewElement(BindingTypeWithEcj::computeTypeArguments)));
    }

    protected static TypeBinding[] computeTypeArguments(BindingTypeWithEcj type) {
        type.getSourceTypeBinding();
        ReferenceBinding owner = type.m_binding;
        if (owner instanceof ParameterizedTypeBinding) {
            return ((ParameterizedTypeBinding)owner).arguments;
        }
        return Binding.NO_TYPES;
    }

    protected TypeVariableBinding[] getTypeVariables() {
        ReferenceBinding refType = this.m_binding;
        if (this.m_binding.actualType() != null) {
            refType = this.m_binding.actualType();
        }
        return refType.typeVariables();
    }

    public boolean hasTypeParameters() {
        this.getSourceTypeBinding();
        TypeVariableBinding[] typeVariables = this.getTypeVariables();
        return typeVariables != null && typeVariables.length > 0;
    }

    public List<TypeParameterSpi> getTypeParameters() {
        return (List)this.m_typeParameters.computeIfAbsentAndGet(() -> {
            this.getSourceTypeBinding();
            return SpiWithEcjUtils.createTypeParameters(this, this.getTypeVariables());
        });
    }

    public List<BindingAnnotationWithEcj> getAnnotations() {
        return (List)this.m_annotations.computeIfAbsentAndGet(() -> {
            this.getSourceTypeBinding();
            return SpiWithEcjUtils.createBindingAnnotations((AnnotatableSpi)this, (Binding)SpiWithEcjUtils.nvl(this.m_binding.actualType(), this.m_binding));
        });
    }

    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithEcjUtils.getTypeFlags(this.m_binding.modifiers, null, SpiWithEcjUtils.hasDeprecatedAnnotation(this.getAnnotations()));
        }
        return this.m_flags;
    }

    protected SourceTypeBinding getSourceTypeBinding() {
        return (SourceTypeBinding)this.m_sourceTypeBindingRef.computeIfAbsentAndGet(() -> {
            TypeBinding b = (TypeBinding)SpiWithEcjUtils.nvl(this.m_binding.original(), this.m_binding);
            if (b instanceof SourceTypeBinding) {
                return (SourceTypeBinding)b;
            }
            return null;
        });
    }

    public boolean isAnonymous() {
        return this.m_binding.compoundName == null || this.m_binding.compoundName.length < 1;
    }

    public ISourceRange getSource() {
        return (ISourceRange)this.m_source.computeIfAbsentAndGet(() -> {
            TypeBinding reference = (TypeBinding)SpiWithEcjUtils.nvl(this.m_binding.original(), this.m_binding);
            if (reference instanceof SourceTypeBinding) {
                TypeDeclaration decl = ((SourceTypeBinding)reference).scope.referenceContext;
                return this.javaEnvWithEcj().getSource(this.getCompilationUnit(), decl.declarationSourceStart, decl.declarationSourceEnd);
            }
            return null;
        });
    }

    public ISourceRange getSourceOfStaticInitializer() {
        return (ISourceRange)this.m_staticInitSource.computeIfAbsentAndGet(() -> {
            if (this.m_binding instanceof SourceTypeBinding) {
                TypeDeclaration decl = ((SourceTypeBinding)this.m_binding).scope.referenceContext;
                return Arrays.stream(decl.fields).filter(fieldDecl -> fieldDecl.type == null && fieldDecl.name == null).findAny().map(fieldDecl -> this.javaEnvWithEcj().getSource(this.getCompilationUnit(), fieldDecl.declarationSourceStart, fieldDecl.declarationSourceEnd)).orElse(null);
            }
            return null;
        });
    }

    public ISourceRange getJavaDoc() {
        return (ISourceRange)this.m_javaDocSource.computeIfAbsentAndGet(() -> {
            if (this.m_binding instanceof SourceTypeBinding) {
                TypeDeclaration decl = ((SourceTypeBinding)this.m_binding).scope.referenceContext;
                return SpiWithEcjUtils.createSourceRange((ASTNode)decl.javadoc, this.getCompilationUnit(), this.javaEnvWithEcj());
            }
            return null;
        });
    }
}

