/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.eclipse.wildwebdeveloper.xml.internal.ui.preferences.XMLPreferenceServerConstants;
import org.osgi.framework.Bundle;

public class XMLCatalogs {
    private static final Comparator<File> FILE_CASE_INSENSITIVE_ORDER = Comparator.comparing(File::getAbsolutePath, String.CASE_INSENSITIVE_ORDER);
    private static final File SYSTEM_CATALOG = Activator.getDefault().getStateLocation().append("system-catalog.xml").toFile();

    public static Set<File> getUserCatalogs(IPreferenceStore store) {
        TreeSet<File> catalogs = new TreeSet<File>(FILE_CASE_INSENSITIVE_ORDER);
        String[] stringArray = store.getString(XMLPreferenceServerConstants.XML_PREFERENCES_CATAGLOGS.preferenceId).split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filepath = stringArray[n2];
            if (!filepath.isEmpty()) {
                catalogs.add(new File(filepath));
            }
            ++n2;
        }
        return catalogs;
    }

    public static Set<File> getAllCatalogs(IPreferenceStore store) {
        Set<File> res = XMLCatalogs.getUserCatalogs(store);
        res.add(XMLCatalogs.getWTPExtensionCatalog());
        return res;
    }

    private static File getWTPExtensionCatalog() {
        StringBuilder catalogFile = new StringBuilder();
        catalogFile.append("<?xml version=\"1.0\"?>\n<!DOCTYPE catalog PUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\" \"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">\n<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"public\">\n");
        Arrays.stream(Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.xml.core.catalogContributions")).filter(element -> "catalogContribution".equals(element.getName())).flatMap(element -> Arrays.stream(element.getChildren())).forEach(element -> {
            switch (element.getName()) {
                case "public": {
                    String publicId = element.getAttribute("publicId");
                    URI uri = XMLCatalogs.resolveURI(element);
                    if (publicId == null || uri == null) break;
                    catalogFile.append("<public publicId=\"").append(publicId).append("\" uri=\"").append(uri).append("\"/>\n");
                    break;
                }
                case "system": {
                    String namespace = element.getAttribute("systemId");
                    URI uri = XMLCatalogs.resolveURI(element);
                    if (namespace == null || uri == null) break;
                    catalogFile.append("<system systemId=\"").append(namespace).append("\" uri=\"").append(uri).append("\"/>\n");
                    break;
                }
                case "uri": {
                    String name = element.getAttribute("name");
                    URI uri = XMLCatalogs.resolveURI(element);
                    if (name == null || uri == null) break;
                    catalogFile.append("<uri name=\"").append(name).append("\" uri=\"").append(uri).append("\"/>\n");
                }
            }
        });
        catalogFile.append("</catalog>");
        try {
            Files.writeString(SYSTEM_CATALOG.toPath(), (CharSequence)catalogFile.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.xml", e.getMessage(), (Throwable)e));
        }
        return SYSTEM_CATALOG;
    }

    private static URI resolveURI(IConfigurationElement element) {
        URI uri;
        block7: {
            uri = URI.create(element.getAttribute("uri"));
            if (!uri.isAbsolute()) {
                try {
                    String contributorName = element.getContributor().getName();
                    URL url = FileLocator.find((Bundle)Platform.getBundle((String)contributorName), (IPath)Path.fromPortableString((String)uri.toString()));
                    if (url != null) {
                        uri = new URI(url.getProtocol(), url.getAuthority(), url.getPath(), null, null);
                        break block7;
                    }
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.wildwebdeveloper.xml", "A URL object was not found for the given URI " + uri + " from  " + contributorName));
                    return null;
                }
                catch (URISyntaxException | InvalidRegistryObjectException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.xml", e.getMessage(), e));
                    return null;
                }
            }
        }
        if (!"file".equals(uri.getScheme())) {
            try {
                URL url = FileLocator.toFileURL((URL)uri.toURL());
                return new URI(url.getProtocol(), url.getAuthority(), url.getPath(), null, null);
            }
            catch (IOException | URISyntaxException | InvalidRegistryObjectException e) {
                String plugin = element.getNamespaceIdentifier();
                String uriString = element.getAttribute("uri");
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.xml", "Error while getting URI '" + uriString + "' from plugin '" + plugin + "' : " + e.getMessage(), e));
                return null;
            }
        }
        return uri;
    }

    public static void storeUserCatalogs(IPreferenceStore store, Set<File> catalogs) {
        StringBuilder catalogsStr = new StringBuilder();
        if (!catalogs.isEmpty()) {
            for (File f : catalogs) {
                catalogsStr.append(f.getAbsolutePath()).append(',');
            }
        }
        store.setValue(XMLPreferenceServerConstants.XML_PREFERENCES_CATAGLOGS.preferenceId, catalogsStr.toString());
    }
}

