/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util.visitor;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.visitor.IBreadthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.ITreeTraversal;
import org.eclipse.scout.sdk.core.util.visitor.TreeVisitResult;

public class BreadthFirstTraversal<T>
implements ITreeTraversal<T> {
    private final IBreadthFirstVisitor<T> m_visitor;
    private final Function<T, Stream<? extends T>> m_childrenSupplier;

    protected BreadthFirstTraversal(IBreadthFirstVisitor<T> visitor, Function<T, Stream<? extends T>> childrenSupplier) {
        this.m_visitor = visitor;
        this.m_childrenSupplier = childrenSupplier;
    }

    @Override
    public TreeVisitResult traverse(T root) {
        Ensure.notNull(root);
        ArrayDeque<P_BreadthFirstNode<T>> dek = new ArrayDeque<P_BreadthFirstNode<T>>();
        this.enqueue(dek, root, 0, 0);
        while (!dek.isEmpty()) {
            P_BreadthFirstNode node = (P_BreadthFirstNode)dek.poll();
            TreeVisitResult nextAction = this.m_visitor.visit(node.m_element, node.m_level, node.m_index);
            if (nextAction == TreeVisitResult.TERMINATE) {
                return TreeVisitResult.TERMINATE;
            }
            if (nextAction == TreeVisitResult.SKIP_SIBLINGS) {
                this.removeQueuedSiblings(dek);
            }
            if (nextAction == TreeVisitResult.SKIP_SUBTREE) continue;
            this.enqueueChildren(dek, node);
        }
        return TreeVisitResult.CONTINUE;
    }

    protected void enqueueChildren(Deque<P_BreadthFirstNode<T>> dek, P_BreadthFirstNode<T> node) {
        Stream<Object> children = this.m_childrenSupplier.apply(node.m_element);
        if (children == null) {
            return;
        }
        AtomicInteger index = new AtomicInteger();
        children.forEach(child -> this.enqueueChild(child, dek, node, index.getAndIncrement()));
    }

    protected void enqueueChild(T child, Deque<P_BreadthFirstNode<T>> dek, P_BreadthFirstNode<T> node, int index) {
        if (child == null) {
            return;
        }
        this.enqueue(dek, child, node.m_level + 1, index);
    }

    protected void enqueue(Deque<P_BreadthFirstNode<T>> dek, T element, int level, int index) {
        P_BreadthFirstNode<T> e = new P_BreadthFirstNode<T>(element, level, index);
        dek.addLast(e);
    }

    protected void removeQueuedSiblings(Iterable<P_BreadthFirstNode<T>> dek) {
        Iterator<P_BreadthFirstNode<T>> iterator = dek.iterator();
        while (iterator.hasNext()) {
            P_BreadthFirstNode<T> siblingCandidate = iterator.next();
            if (siblingCandidate.m_index > 0) {
                iterator.remove();
                continue;
            }
            return;
        }
    }

    protected static class P_BreadthFirstNode<T> {
        private final int m_level;
        private final T m_element;
        private final int m_index;

        protected P_BreadthFirstNode(T element, int level, int index) {
            this.m_element = element;
            this.m_level = level;
            this.m_index = index;
        }
    }
}

