/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Resources;
import org.eclipse.scout.sdk.core.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Xml {
    private Xml() {
    }

    public static Document get(Path xmlFile) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(Ensure.notNull(xmlFile), StandardOpenOption.READ));){
            Document document = Xml.get(in);
            return document;
        }
    }

    public static Document get(URL url) throws IOException {
        try {
            return Xml.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static Document get(URI uri) throws IOException {
        try (InputStream in = Resources.openStream(uri);){
            Document document = Xml.get(in);
            return document;
        }
    }

    public static Document get(String rawXmlAsString) throws IOException {
        Document document;
        StringReader r = new StringReader(Ensure.notBlank(rawXmlAsString));
        try {
            document = Xml.createDocumentBuilder().parse(new InputSource(r));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new IOException(e);
            }
        }
        ((Reader)r).close();
        return document;
    }

    static Document get(InputStream in) throws IOException {
        try {
            return Xml.createDocumentBuilder().parse(in);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    public static Optional<Element> firstChildElement(Node parent, String tagName) {
        if (parent == null) {
            return Optional.empty();
        }
        if (tagName == null) {
            return Optional.empty();
        }
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            String nodeName = n.getLocalName();
            if (n.getNodeType() != 1 || !Objects.equals(nodeName, tagName)) continue;
            return Optional.of((Element)n);
        }
        return Optional.empty();
    }

    public static List<Element> evaluateXPath(String xPath, Node applyToDocument) throws XPathExpressionException {
        return Xml.evaluateXPath(xPath, applyToDocument, null);
    }

    public static List<Element> evaluateXPath(String xPath, Node applyToDocument, String prefix, String namespace) throws XPathExpressionException {
        return Xml.evaluateXPath(xPath, applyToDocument, Collections.singletonMap(prefix, namespace));
    }

    public static List<Element> evaluateXPath(String xPath, Node applyToDocument, Map<String, String> usedPrefixToNamespaceMap) throws XPathExpressionException {
        NodeList result = Xml.doEvaluateXPath(xPath, applyToDocument, usedPrefixToNamespaceMap);
        if (result == null) {
            return Collections.emptyList();
        }
        int size = result.getLength();
        if (size < 1) {
            return Collections.emptyList();
        }
        return IntStream.range(0, size).mapToObj(result::item).filter(n -> n.getNodeType() == 1).map(n -> (Element)n).collect(Collectors.toList());
    }

    static NodeList doEvaluateXPath(String xPath, final Node applyToDocument, final Map<String, String> usedPrefixToNamespaceMap) throws XPathExpressionException {
        if (applyToDocument == null || Strings.isBlank(xPath)) {
            return null;
        }
        XPathFactory xPathFactory = XPathFactory.newDefaultInstance();
        XPath xpath = xPathFactory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                String ns;
                if (usedPrefixToNamespaceMap != null && (ns = (String)usedPrefixToNamespaceMap.get(prefix)) != null) {
                    return ns;
                }
                return applyToDocument.lookupNamespaceURI(prefix);
            }

            @Override
            public Iterator<String> getPrefixes(String val) {
                return Collections.singletonList(this.getPrefix(val)).iterator();
            }

            @Override
            public String getPrefix(String uri) {
                if (usedPrefixToNamespaceMap != null) {
                    for (Map.Entry entry : usedPrefixToNamespaceMap.entrySet()) {
                        if (!((String)entry.getValue()).equals(uri)) continue;
                        return (String)entry.getKey();
                    }
                }
                return applyToDocument.lookupPrefix(uri);
            }
        });
        XPathExpression expr = xpath.compile(xPath);
        return (NodeList)expr.evaluate(applyToDocument, XPathConstants.NODESET);
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newDefaultInstance();
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        dbf.setNamespaceAware(true);
        try {
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException e) {
            SdkLog.debug("Attribute '{}' is not supported in the current DocumentBuilderFactory: {}", "http://javax.xml.XMLConstants/property/accessExternalDTD", dbf.getClass().getName(), e);
        }
        try {
            dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (IllegalArgumentException e) {
            SdkLog.debug("Attribute '{}' is not supported in the current DocumentBuilderFactory: {}", "http://javax.xml.XMLConstants/property/accessExternalSchema", dbf.getClass().getName(), e);
        }
        HashMap<String, Boolean> features = new HashMap<String, Boolean>(5);
        features.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        features.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        features.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        features.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        for (Map.Entry a : features.entrySet()) {
            String feature = (String)a.getKey();
            boolean enabled = (Boolean)a.getValue();
            try {
                dbf.setFeature(feature, enabled);
            }
            catch (ParserConfigurationException e) {
                SdkLog.debug("Feature '{}' is not supported in the current XML parser. Skipping.", feature, e);
            }
        }
        return dbf;
    }

    public static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        return Xml.createDocumentBuilderFactory().newDocumentBuilder();
    }

    public static StringBuffer writeDocument(Document document, boolean format) throws TransformerException {
        StringBuffer stringBuffer;
        StringWriter out = new StringWriter();
        try {
            Xml.doWriteDocument(document, format, new StreamResult(out));
            stringBuffer = out.getBuffer();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }
        out.close();
        return stringBuffer;
    }

    public static void writeDocument(Document document, boolean format, Path targetFile) throws TransformerException {
        try (OutputStream out = Files.newOutputStream(targetFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Xml.writeDocument(document, format, out);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    public static void writeDocument(Document document, boolean format, Writer out) throws TransformerException {
        Xml.doWriteDocument(document, format, new StreamResult(out));
    }

    public static void writeDocument(Document document, boolean format, OutputStream out) throws TransformerException {
        Xml.doWriteDocument(document, format, new StreamResult(out));
    }

    static void doWriteDocument(Document document, boolean format, Result out) throws TransformerException {
        if (format) {
            document.normalize();
            try {
                NodeList nodeList = Xml.doEvaluateXPath("//text()[normalize-space()='']", document, null);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        node.getParentNode().removeChild(node);
                    }
                }
            }
            catch (XPathExpressionException e) {
                throw new TransformerException(e);
            }
        }
        Xml.createTransformer(format).transform(new DOMSource(document), out);
    }

    public static Transformer createTransformer(boolean format) throws TransformerConfigurationException {
        TransformerFactory tf = TransformerFactory.newDefaultInstance();
        try {
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            SdkLog.debug("Feature '{}' is not supported in the current TransformerFactory: {}", "http://javax.xml.XMLConstants/feature/secure-processing", tf.getClass().getName(), e);
        }
        HashMap<String, String> attribs = new HashMap<String, String>(2);
        attribs.put("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        attribs.put("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        for (Map.Entry a : attribs.entrySet()) {
            try {
                tf.setAttribute((String)a.getKey(), a.getValue());
            }
            catch (IllegalArgumentException e) {
                SdkLog.debug("Attribute '{}' is not supported in the current TransformerFactory: {}", a.getKey(), tf.getClass().getName(), e);
            }
        }
        Transformer transformer = tf.newTransformer();
        HashMap<String, String> outputProps = new HashMap<String, String>(4);
        outputProps.put("encoding", StandardCharsets.UTF_8.name());
        outputProps.put("method", "xml");
        if (format) {
            outputProps.put("indent", "yes");
            outputProps.put("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
        } else {
            outputProps.put("indent", "no");
        }
        for (Map.Entry o : outputProps.entrySet()) {
            try {
                transformer.setOutputProperty((String)o.getKey(), (String)o.getValue());
            }
            catch (IllegalArgumentException e) {
                SdkLog.debug("Error applying output property '{}' on transformer of class '{}'.", o.getKey(), transformer.getClass().getName(), e);
            }
        }
        return transformer;
    }
}

