/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.CookieManager;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.zip.GZIPInputStream;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.SdkException;

public final class Resources {
    private static final int BUFFER_SIZE = 8192;
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    public static final String HEADER_PRAGMA = "Pragma";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String ENCODING_GZIP = "gzip";

    private Resources() {
    }

    public static InputStream openStream(URL url) throws IOException {
        return Resources.openStream(Resources.toURI(url));
    }

    public static InputStream openStream(String uri) throws IOException {
        try {
            return Resources.openStream(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new SdkException((CharSequence)"Invalid URI: '{}'.", uri, e);
        }
    }

    public static InputStream openStream(URI uri) throws IOException {
        String scheme = uri.getScheme();
        if (PROTOCOL_HTTPS.equalsIgnoreCase(scheme) || PROTOCOL_HTTP.equalsIgnoreCase(scheme)) {
            return Resources.httpGet(uri);
        }
        InputStream stream = uri.toURL().openStream();
        if (stream instanceof BufferedInputStream) {
            return stream;
        }
        return new BufferedInputStream(stream, 8192);
    }

    public static InputStream httpGet(URL url) throws IOException {
        return Resources.httpGet(Resources.toURI(url));
    }

    public static InputStream httpGet(String uri) throws IOException {
        try {
            return Resources.httpGet(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new SdkException((CharSequence)"Invalid URI: '{}'.", uri, e);
        }
    }

    public static InputStream httpGet(URI uri) throws IOException {
        try {
            return Resources.doHttpGetWithRetry(uri);
        }
        catch (InterruptedException e) {
            throw new SdkException((CharSequence)"Interrupted while reading from URI {}", Resources.toSimple(uri), e);
        }
    }

    static InputStream doHttpGetWithRetry(URI uri) throws IOException, InterruptedException {
        IOException exception = null;
        int numRetries = 5;
        for (int attempt = 1; attempt <= numRetries; ++attempt) {
            try {
                return Resources.doHttpGet(uri);
            }
            catch (HttpTimeoutException e) {
                exception = new IOException("HTTP GET timed out for URI " + Resources.toSimple(uri), e);
                SdkLog.debug(exception);
            }
            catch (IOException e) {
                SdkLog.debug(e);
                exception = e;
            }
            if (attempt >= numRetries) continue;
            Thread.sleep(Resources.getSleepTimeAfterAttempt(attempt));
        }
        throw exception;
    }

    static long getSleepTimeAfterAttempt(int attempt) {
        long baseTimeout = (long)attempt * 300L;
        long randomOffset = (long)(Math.random() * 200.0);
        return baseTimeout + randomOffset;
    }

    static InputStream doHttpGet(URI uri) throws IOException, InterruptedException {
        HttpResponse<InputStream> response;
        int statusCode;
        Duration timeout = Duration.ofSeconds(10L);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).version(HttpClient.Version.HTTP_2).timeout(timeout).setHeader(HEADER_PRAGMA, "no-cache").setHeader(HEADER_CACHE_CONTROL, "no-cache, no-store, must-revalidate").setHeader(HEADER_ACCEPT_ENCODING, ENCODING_GZIP).GET().build();
        HttpResponse.BodyHandler<InputStream> handler = HttpResponse.BodyHandlers.buffering(HttpResponse.BodyHandlers.ofInputStream(), 8192);
        ProxySelector proxySelector = ProxySelector.getDefault();
        Authenticator authenticator = Authenticator.getDefault();
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).cookieHandler(new CookieManager(null, null)).connectTimeout(timeout);
        if (proxySelector != null) {
            clientBuilder.proxy(proxySelector);
        }
        if (authenticator != null) {
            clientBuilder.authenticator(authenticator);
        }
        if ((statusCode = (response = clientBuilder.build().send(request, handler)).statusCode()) < 200 || statusCode > 299) {
            throw new IOException("HTTP status code " + statusCode + " received from " + Resources.toSimple(uri));
        }
        String encoding = response.headers().firstValue(HEADER_CONTENT_ENCODING).orElse("").trim();
        if (ENCODING_GZIP.equalsIgnoreCase(encoding)) {
            return new GZIPInputStream(response.body());
        }
        return response.body();
    }

    static String toSimple(URI uri) {
        try {
            URI shortened = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null);
            if (shortened.equals(uri)) {
                return uri.toString();
            }
            return shortened + " (url shortened)";
        }
        catch (URISyntaxException e) {
            SdkLog.debug("Cannot simplify uri '{}'.", uri, e);
            return uri.toString();
        }
    }

    static URI toURI(URL url) throws IOException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("URL '" + url + "' cannot be converted to URI.", e);
        }
    }
}

