/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;

public final class CoreUtils {
    private static final Pattern PATH_SEGMENT_SPLIT_PATTERN = Pattern.compile("/");
    private static final Pattern REGEX_COMMENT_REMOVE_1 = Pattern.compile("//.*?\r\n");
    private static final Pattern REGEX_COMMENT_REMOVE_2 = Pattern.compile("//.*?\n");
    private static final Pattern REGEX_COMMENT_REMOVE_3 = Pattern.compile("(?s)/\\*.*?\\*/");
    private static final ThreadLocal<String> CURRENT_USER_NAME = ThreadLocal.withInitial(() -> null);

    private CoreUtils() {
    }

    public static String getUsername() {
        String name = CURRENT_USER_NAME.get();
        if (name != null) {
            return name;
        }
        return System.getProperty("user.name");
    }

    public static void setUsernameForThread(String newUsernameForCurrentThread) {
        CoreUtils.setThreadLocal(CURRENT_USER_NAME, newUsernameForCurrentThread);
    }

    public static String removeComments(CharSequence methodBody) {
        if (methodBody == null) {
            return null;
        }
        if (Strings.isBlank(methodBody)) {
            return methodBody.toString();
        }
        String retVal = REGEX_COMMENT_REMOVE_1.matcher(methodBody).replaceAll("");
        retVal = REGEX_COMMENT_REMOVE_2.matcher(retVal).replaceAll("");
        retVal = REGEX_COMMENT_REMOVE_3.matcher(retVal).replaceAll("");
        return retVal;
    }

    public static void deleteDirectory(Path toDelete) throws IOException {
        if (!Files.exists(Ensure.notNull(toDelete), new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(toDelete, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                try {
                    Files.delete(file);
                }
                catch (IOException e) {
                    SdkLog.debug("Unable to delete '{}' after failed visit.", file, e);
                }
                if (exc instanceof NoSuchFileException) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                throw exc;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return super.postVisitDirectory(dir, exc);
            }
        });
    }

    public static void moveDirectory(final Path sourceDir, Path targetDir) throws IOException {
        Ensure.notNull(sourceDir);
        Ensure.notNull(targetDir);
        Ensure.isDirectory(sourceDir);
        Ensure.isDirectory(targetDir);
        Path fileName = Ensure.notNull(sourceDir.getFileName());
        final Path targetPath = targetDir.resolve(fileName.toString());
        Files.createDirectories(targetPath, new FileAttribute[0]);
        if (Objects.equals(Files.getFileStore(sourceDir), Files.getFileStore(targetPath))) {
            Files.move(sourceDir, targetPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, targetPath.resolve(sourceDir.relativize(file)), new CopyOption[0]);
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(targetPath.resolve(sourceDir.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static URI relativizeURI(URI base, URI child) {
        int i;
        if (!Objects.equals(base.getAuthority(), child.getAuthority()) || !Objects.equals(base.getScheme(), child.getScheme())) {
            return child;
        }
        base = base.normalize();
        child = child.normalize();
        String[] bParts = PATH_SEGMENT_SPLIT_PATTERN.split(base.getRawPath());
        String[] cParts = PATH_SEGMENT_SPLIT_PATTERN.split(child.getRawPath());
        if (bParts.length > 0 && !base.getPath().endsWith("/")) {
            bParts = Arrays.copyOf(bParts, bParts.length - 1);
        }
        for (i = 0; i < bParts.length && i < cParts.length && bParts[i].equals(cParts[i]); ++i) {
        }
        StringBuilder sb = new StringBuilder();
        sb.append("../".repeat(Math.max(0, bParts.length - i)));
        for (int j = i; j < cParts.length; ++j) {
            if (j != i) {
                sb.append('/');
            }
            sb.append(cParts[j]);
        }
        return URI.create(sb.toString()).normalize();
    }

    public static URI getParentURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.getPath().endsWith("/")) {
            return uri.resolve("..");
        }
        return uri.resolve(".");
    }

    public static boolean isDoubleDifferent(double d1, double d2, double delta) {
        if (Double.compare(d1, d2) == 0) {
            return false;
        }
        return !(Math.abs(d1 - d2) <= Math.abs(delta));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R callInContext(ThreadLocal<T> threadLocal, T context, Supplier<R> callable) {
        T orig = threadLocal.get();
        try {
            CoreUtils.setThreadLocal(threadLocal, context);
            R r = callable.get();
            return r;
        }
        finally {
            CoreUtils.setThreadLocal(threadLocal, orig);
        }
    }

    private static <T> void setThreadLocal(ThreadLocal<T> tl, T context) {
        if (context == null) {
            tl.remove();
        } else {
            tl.set(context);
        }
    }

    public static String extensionOf(String filePath) {
        if (Strings.isBlank(filePath)) {
            return "";
        }
        int lastDot = filePath.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return filePath.substring(lastDot + 1).toLowerCase(Locale.US);
    }

    public static String extensionOf(Path file) {
        if (file == null) {
            return "";
        }
        Path lastSegment = file.getFileName();
        if (lastSegment == null) {
            return "";
        }
        return CoreUtils.extensionOf(lastSegment.toString());
    }

    public static Optional<String> toStringIfOverwritten(Object o) {
        if (o == null) {
            return Optional.empty();
        }
        try {
            String declaringClassFqn = o.getClass().getMethod("toString", new Class[0]).getDeclaringClass().getName();
            if (Object.class.getName().equals(declaringClassFqn) || "kotlin.jvm.internal.Lambda".equals(declaringClassFqn)) {
                return Optional.empty();
            }
        }
        catch (NoSuchMethodException e) {
            SdkLog.debug("Cannot get toString method of object {}", o.getClass(), e);
            return Optional.empty();
        }
        String val = null;
        try {
            val = o.toString();
        }
        catch (Throwable t) {
            SdkLog.warning("Failed toString() invocation on an object of type [{}]", o.getClass().getName(), t);
        }
        return Strings.notBlank(val);
    }

    public static boolean setTextToClipboard(String text) {
        return CoreUtils.setTextToClipboard(text, null);
    }

    public static boolean setTextToClipboard(String text, ClipboardOwner ownershipLostCallback) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        try {
            StringSelection stringSelection = new StringSelection(text);
            ClipboardOwner owner = ownershipLostCallback == null ? stringSelection : ownershipLostCallback;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, owner);
            return true;
        }
        catch (Exception e) {
            SdkLog.debug("Error setting text to system clipboard.", e);
            return false;
        }
    }

    public static Object invokeDefaultMethod(Object instance, Method method, Object[] args) {
        try {
            Class<?> ifcClass = method.getDeclaringClass();
            return MethodHandles.lookup().findSpecial(ifcClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), ifcClass).bindTo(instance).invokeWithArguments(args);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            SdkLog.debug("Exception calling default method '{}'.", method, e);
            throw new SdkException(e);
        }
    }
}

