/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.internal.AbstractJavaElementImplementor;
import org.eclipse.scout.sdk.core.model.api.internal.JavaEnvironmentImplementor;
import org.eclipse.scout.sdk.core.model.spi.AbstractSpiElement;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaEnvironmentSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;

public abstract class AbstractJavaEnvironment
implements JavaEnvironmentSpi {
    private static final Object NULL_OBJECT = new Object();
    private final AtomicInteger m_hashSeq;
    private final Map<String, Object> m_typeCache;
    private final JavaEnvironmentImplementor m_api;
    private final Object m_instanceLock = new Object();
    private final Map<AbstractJavaElementImplementor<JavaElementSpi>, Object> m_detachedApis;

    protected AbstractJavaEnvironment() {
        this.m_typeCache = new HashMap<String, Object>();
        this.m_detachedApis = new WeakHashMap<AbstractJavaElementImplementor<JavaElementSpi>, Object>();
        this.m_api = new JavaEnvironmentImplementor(this);
        this.m_hashSeq = new AtomicInteger();
    }

    @Override
    public IJavaEnvironment wrap() {
        return this.m_api;
    }

    public int nextHashCode() {
        return this.m_hashSeq.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeSpi findType(String fqn) {
        Object elem = this.m_typeCache.get(fqn);
        if (elem == null) {
            Object object = this.lock();
            synchronized (object) {
                elem = this.m_typeCache.computeIfAbsent(fqn, this::doFindTypeInternal);
            }
        }
        if (elem == NULL_OBJECT) {
            return null;
        }
        return (TypeSpi)elem;
    }

    private Object doFindTypeInternal(String fqn) {
        TypeSpi result = this.doFindType(fqn);
        if (result == null) {
            return NULL_OBJECT;
        }
        return result;
    }

    protected abstract TypeSpi doFindType(String var1);

    protected abstract Collection<JavaElementSpi> allElements();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Object object = this.lock();
        synchronized (object) {
            this.m_typeCache.clear();
            this.m_api.spiChanged();
        }
    }

    protected void onReloadStart() {
        this.cleanup();
    }

    protected void onReloadEnd() {
    }

    protected Object removeTypeFromCache(String fqn) {
        return this.m_typeCache.remove(fqn);
    }

    public Object lock() {
        return this.m_instanceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        Object object = this.lock();
        synchronized (object) {
            ArrayList<JavaElementSpi> detachedSpiElements = new ArrayList<JavaElementSpi>(this.allElements());
            Map<JavaElementSpi, List<AbstractJavaElementImplementor>> detachedApisBySpi = this.m_detachedApis.keySet().stream().collect(Collectors.groupingBy(IJavaElement::unwrap));
            try {
                this.onReloadStart();
                for (JavaElementSpi old : detachedSpiElements) {
                    List<AbstractJavaElementImplementor> detachedApisToUpdate;
                    AbstractSpiElement newAbsSpiElement;
                    AbstractJavaElementImplementor previousApi;
                    AbstractSpiElement oldSpiElement = (AbstractSpiElement)((Object)old);
                    AbstractJavaElementImplementor apiElement = (AbstractJavaElementImplementor)oldSpiElement.getExistingApi();
                    if (apiElement == null) continue;
                    JavaElementSpi newSpiElement = oldSpiElement.internalFindNewElement();
                    apiElement.internalSetSpi(newSpiElement);
                    if (newSpiElement != null && (previousApi = (newAbsSpiElement = (AbstractSpiElement)((Object)newSpiElement)).internalSetApi(apiElement)) != null && previousApi != apiElement) {
                        this.m_detachedApis.put(previousApi, null);
                    }
                    if ((detachedApisToUpdate = detachedApisBySpi.get(oldSpiElement)) != null && !detachedApisToUpdate.isEmpty()) {
                        detachedApisToUpdate.forEach(api -> api.internalSetSpi(newSpiElement));
                    }
                    oldSpiElement.internalSetApi(null);
                }
            }
            finally {
                this.onReloadEnd();
            }
        }
    }
}

